/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sourcerepo.v1;

/**
 * Service definition for CloudSourceRepositories (v1).
 *
 * <p>
 * Accesses source code repositories hosted by Google.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/source-repositories/docs/apis" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudSourceRepositoriesRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class CloudSourceRepositories extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.9 of the Cloud Source Repositories API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://sourcerepo.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public CloudSourceRepositories(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  CloudSourceRepositories(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudSourceRepositories sourcerepo = new CloudSourceRepositories(...);}
   *   {@code CloudSourceRepositories.Projects.List request = sourcerepo.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Returns the Cloud Source Repositories configuration of the project.
     *
     * Create a request for the method "projects.getConfig".
     *
     * This request holds the parameters needed by the sourcerepo server.  After setting any optional
     * parameters, call the {@link GetConfig#execute()} method to invoke the remote operation.
     *
     * @param name The name of the requested project. Values are of the form
    `projects/`.
     * @return the request
     */
    public GetConfig getConfig(java.lang.String name) throws java.io.IOException {
      GetConfig result = new GetConfig(name);
      initialize(result);
      return result;
    }

    public class GetConfig extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.ProjectConfig> {

      private static final String REST_PATH = "v1/{+name}/config";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Returns the Cloud Source Repositories configuration of the project.
       *
       * Create a request for the method "projects.getConfig".
       *
       * This request holds the parameters needed by the the sourcerepo server.  After setting any
       * optional parameters, call the {@link GetConfig#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the requested project. Values are of the form
    `projects/`.
       * @since 1.13
       */
      protected GetConfig(java.lang.String name) {
        super(CloudSourceRepositories.this, "GET", REST_PATH, null, com.google.api.services.sourcerepo.v1.model.ProjectConfig.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetConfig set$Xgafv(java.lang.String $Xgafv) {
        return (GetConfig) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetConfig setAccessToken(java.lang.String accessToken) {
        return (GetConfig) super.setAccessToken(accessToken);
      }

      @Override
      public GetConfig setAlt(java.lang.String alt) {
        return (GetConfig) super.setAlt(alt);
      }

      @Override
      public GetConfig setCallback(java.lang.String callback) {
        return (GetConfig) super.setCallback(callback);
      }

      @Override
      public GetConfig setFields(java.lang.String fields) {
        return (GetConfig) super.setFields(fields);
      }

      @Override
      public GetConfig setKey(java.lang.String key) {
        return (GetConfig) super.setKey(key);
      }

      @Override
      public GetConfig setOauthToken(java.lang.String oauthToken) {
        return (GetConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public GetConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetConfig setQuotaUser(java.lang.String quotaUser) {
        return (GetConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetConfig setUploadType(java.lang.String uploadType) {
        return (GetConfig) super.setUploadType(uploadType);
      }

      @Override
      public GetConfig setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetConfig) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The name of the requested project. Values are of the form `projects/`.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the requested project. Values are of the form `projects/`.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * The name of the requested project. Values are of the form `projects/`.
       */
      public GetConfig setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GetConfig set(String parameterName, Object value) {
        return (GetConfig) super.set(parameterName, value);
      }
    }
    /**
     * Updates the Cloud Source Repositories configuration of the project.
     *
     * Create a request for the method "projects.updateConfig".
     *
     * This request holds the parameters needed by the sourcerepo server.  After setting any optional
     * parameters, call the {@link UpdateConfig#execute()} method to invoke the remote operation.
     *
     * @param name The name of the requested project. Values are of the form
    `projects/`.
     * @param content the {@link com.google.api.services.sourcerepo.v1.model.UpdateProjectConfigRequest}
     * @return the request
     */
    public UpdateConfig updateConfig(java.lang.String name, com.google.api.services.sourcerepo.v1.model.UpdateProjectConfigRequest content) throws java.io.IOException {
      UpdateConfig result = new UpdateConfig(name, content);
      initialize(result);
      return result;
    }

    public class UpdateConfig extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.ProjectConfig> {

      private static final String REST_PATH = "v1/{+name}/config";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+$");

      /**
       * Updates the Cloud Source Repositories configuration of the project.
       *
       * Create a request for the method "projects.updateConfig".
       *
       * This request holds the parameters needed by the the sourcerepo server.  After setting any
       * optional parameters, call the {@link UpdateConfig#execute()} method to invoke the remote
       * operation. <p> {@link
       * UpdateConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the requested project. Values are of the form
    `projects/`.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.UpdateProjectConfigRequest}
       * @since 1.13
       */
      protected UpdateConfig(java.lang.String name, com.google.api.services.sourcerepo.v1.model.UpdateProjectConfigRequest content) {
        super(CloudSourceRepositories.this, "PATCH", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.ProjectConfig.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^projects/[^/]+$");
        }
      }

      @Override
      public UpdateConfig set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateConfig) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateConfig setAccessToken(java.lang.String accessToken) {
        return (UpdateConfig) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateConfig setAlt(java.lang.String alt) {
        return (UpdateConfig) super.setAlt(alt);
      }

      @Override
      public UpdateConfig setCallback(java.lang.String callback) {
        return (UpdateConfig) super.setCallback(callback);
      }

      @Override
      public UpdateConfig setFields(java.lang.String fields) {
        return (UpdateConfig) super.setFields(fields);
      }

      @Override
      public UpdateConfig setKey(java.lang.String key) {
        return (UpdateConfig) super.setKey(key);
      }

      @Override
      public UpdateConfig setOauthToken(java.lang.String oauthToken) {
        return (UpdateConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateConfig setQuotaUser(java.lang.String quotaUser) {
        return (UpdateConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateConfig setUploadType(java.lang.String uploadType) {
        return (UpdateConfig) super.setUploadType(uploadType);
      }

      @Override
      public UpdateConfig setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateConfig) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The name of the requested project. Values are of the form `projects/`.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the requested project. Values are of the form `projects/`.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * The name of the requested project. Values are of the form `projects/`.
       */
      public UpdateConfig setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^projects/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public UpdateConfig set(String parameterName, Object value) {
        return (UpdateConfig) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Repos collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudSourceRepositories sourcerepo = new CloudSourceRepositories(...);}
     *   {@code CloudSourceRepositories.Repos.List request = sourcerepo.repos().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Repos repos() {
      return new Repos();
    }

    /**
     * The "repos" collection of methods.
     */
    public class Repos {

      /**
       * Creates a repo in the given project with the given name.
       *
       * If the named repository already exists, `CreateRepo` returns `ALREADY_EXISTS`.
       *
       * Create a request for the method "repos.create".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The project in which to create the repo. Values are of the form
      `projects/`.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.Repo}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.sourcerepo.v1.model.Repo content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Repo> {

        private static final String REST_PATH = "v1/{+parent}/repos";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a repo in the given project with the given name.
         *
         * If the named repository already exists, `CreateRepo` returns `ALREADY_EXISTS`.
         *
         * Create a request for the method "repos.create".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The project in which to create the repo. Values are of the form
      `projects/`.
         * @param content the {@link com.google.api.services.sourcerepo.v1.model.Repo}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.sourcerepo.v1.model.Repo content) {
          super(CloudSourceRepositories.this, "POST", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.Repo.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project in which to create the repo. Values are of the form `projects/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The project in which to create the repo. Values are of the form `projects/`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The project in which to create the repo. Values are of the form `projects/`.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a repo.
       *
       * Create a request for the method "repos.delete".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The name of the repo to delete. Values are of the form
      `projects//repos/`.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Deletes a repo.
         *
         * Create a request for the method "repos.delete".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the repo to delete. Values are of the form
      `projects//repos/`.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(CloudSourceRepositories.this, "DELETE", REST_PATH, null, com.google.api.services.sourcerepo.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the repo to delete. Values are of the form `projects//repos/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the repo to delete. Values are of the form `projects//repos/`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the repo to delete. Values are of the form `projects//repos/`.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns information about a repo.
       *
       * Create a request for the method "repos.get".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The name of the requested repository. Values are of the form
      `projects//repos/`.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Repo> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Returns information about a repo.
         *
         * Create a request for the method "repos.get".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the requested repository. Values are of the form
      `projects//repos/`.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(CloudSourceRepositories.this, "GET", REST_PATH, null, com.google.api.services.sourcerepo.v1.model.Repo.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the requested repository. Values are of the form `projects//repos/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the requested repository. Values are of the form `projects//repos/`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the requested repository. Values are of the form `projects//repos/`.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "repos.getIamPolicy".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "repos.getIamPolicy".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
         * operation. <p> {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(CloudSourceRepositories.this, "GET", REST_PATH, null, com.google.api.services.sourcerepo.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The policy format version to be returned.
         *
         * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
         *
         * Requests for policies with any conditional bindings must specify version 3. Policies
         * without any conditional bindings may specify any valid value or leave the field unset.
         *
         * To learn which resources support conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The policy format version to be returned.

       Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.

       Requests for policies with any conditional bindings must specify version 3. Policies without any
       conditional bindings may specify any valid value or leave the field unset.

       To learn which resources support conditions in their IAM policies, see the [IAM
       documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The policy format version to be returned.
         *
         * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
         *
         * Requests for policies with any conditional bindings must specify version 3. Policies
         * without any conditional bindings may specify any valid value or leave the field unset.
         *
         * To learn which resources support conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns all repos belonging to a project. The sizes of the repos are not set by ListRepos.  To
       * get the size of a repo, use GetRepo.
       *
       * Create a request for the method "repos.list".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project ID whose repos should be listed. Values are of the form
      `projects/`.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.ListReposResponse> {

        private static final String REST_PATH = "v1/{+name}/repos";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Returns all repos belonging to a project. The sizes of the repos are not set by ListRepos.  To
         * get the size of a repo, use GetRepo.
         *
         * Create a request for the method "repos.list".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project ID whose repos should be listed. Values are of the form
      `projects/`.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(CloudSourceRepositories.this, "GET", REST_PATH, null, com.google.api.services.sourcerepo.v1.model.ListReposResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project ID whose repos should be listed. Values are of the form `projects/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project ID whose repos should be listed. Values are of the form `projects/`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project ID whose repos should be listed. Values are of the form `projects/`.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Maximum number of repositories to return; between 1 and 500. If not set or zero, defaults
         * to 100 at the server.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of repositories to return; between 1 and 500. If not set or zero, defaults to 100 at
       the server.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Maximum number of repositories to return; between 1 and 500. If not set or zero, defaults
         * to 100 at the server.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Resume listing repositories where a prior ListReposResponse left off. This is an opaque
         * token that must be obtained from a recent, prior ListReposResponse's next_page_token
         * field.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Resume listing repositories where a prior ListReposResponse left off. This is an opaque token that
       must be obtained from a recent, prior ListReposResponse's next_page_token field.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Resume listing repositories where a prior ListReposResponse left off. This is an opaque
         * token that must be obtained from a recent, prior ListReposResponse's next_page_token
         * field.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates information about a repo.
       *
       * Create a request for the method "repos.patch".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The name of the requested repository. Values are of the form
      `projects//repos/`.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.UpdateRepoRequest}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.sourcerepo.v1.model.UpdateRepoRequest content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Repo> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Updates information about a repo.
         *
         * Create a request for the method "repos.patch".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the requested repository. Values are of the form
      `projects//repos/`.
         * @param content the {@link com.google.api.services.sourcerepo.v1.model.UpdateRepoRequest}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.sourcerepo.v1.model.UpdateRepoRequest content) {
          super(CloudSourceRepositories.this, "PATCH", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.Repo.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the requested repository. Values are of the form `projects//repos/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the requested repository. Values are of the form `projects//repos/`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the requested repository. Values are of the form `projects//repos/`.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "repos.setIamPolicy".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.sourcerepo.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy.
         *
         * Create a request for the method "repos.setIamPolicy".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
         * operation. <p> {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.sourcerepo.v1.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.sourcerepo.v1.model.SetIamPolicyRequest content) {
          super(CloudSourceRepositories.this, "POST", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Synchronize a connected repo.
       *
       * The response contains SyncRepoMetadata in the metadata field.
       *
       * Create a request for the method "repos.sync".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link Sync#execute()} method to invoke the remote operation.
       *
       * @param name The name of the repo to synchronize. Values are of the form
      `projects//repos/`.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.SyncRepoRequest}
       * @return the request
       */
      public Sync sync(java.lang.String name, com.google.api.services.sourcerepo.v1.model.SyncRepoRequest content) throws java.io.IOException {
        Sync result = new Sync(name, content);
        initialize(result);
        return result;
      }

      public class Sync extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.Operation> {

        private static final String REST_PATH = "v1/{+name}:sync";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Synchronize a connected repo.
         *
         * The response contains SyncRepoMetadata in the metadata field.
         *
         * Create a request for the method "repos.sync".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link Sync#execute()} method to invoke the remote operation. <p>
         * {@link Sync#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the repo to synchronize. Values are of the form
      `projects//repos/`.
         * @param content the {@link com.google.api.services.sourcerepo.v1.model.SyncRepoRequest}
         * @since 1.13
         */
        protected Sync(java.lang.String name, com.google.api.services.sourcerepo.v1.model.SyncRepoRequest content) {
          super(CloudSourceRepositories.this, "POST", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public Sync set$Xgafv(java.lang.String $Xgafv) {
          return (Sync) super.set$Xgafv($Xgafv);
        }

        @Override
        public Sync setAccessToken(java.lang.String accessToken) {
          return (Sync) super.setAccessToken(accessToken);
        }

        @Override
        public Sync setAlt(java.lang.String alt) {
          return (Sync) super.setAlt(alt);
        }

        @Override
        public Sync setCallback(java.lang.String callback) {
          return (Sync) super.setCallback(callback);
        }

        @Override
        public Sync setFields(java.lang.String fields) {
          return (Sync) super.setFields(fields);
        }

        @Override
        public Sync setKey(java.lang.String key) {
          return (Sync) super.setKey(key);
        }

        @Override
        public Sync setOauthToken(java.lang.String oauthToken) {
          return (Sync) super.setOauthToken(oauthToken);
        }

        @Override
        public Sync setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Sync) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Sync setQuotaUser(java.lang.String quotaUser) {
          return (Sync) super.setQuotaUser(quotaUser);
        }

        @Override
        public Sync setUploadType(java.lang.String uploadType) {
          return (Sync) super.setUploadType(uploadType);
        }

        @Override
        public Sync setUploadProtocol(java.lang.String uploadProtocol) {
          return (Sync) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the repo to synchronize. Values are of the form `projects//repos/`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the repo to synchronize. Values are of the form `projects//repos/`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the repo to synchronize. Values are of the form `projects//repos/`.
         */
        public Sync setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Sync set(String parameterName, Object value) {
          return (Sync) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a NOT_FOUND error.
       *
       * Create a request for the method "repos.testIamPermissions".
       *
       * This request holds the parameters needed by the sourcerepo server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.sourcerepo.v1.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.sourcerepo.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends CloudSourceRepositoriesRequest<com.google.api.services.sourcerepo.v1.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/repos/.*$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a NOT_FOUND error.
         *
         * Create a request for the method "repos.testIamPermissions".
         *
         * This request holds the parameters needed by the the sourcerepo server.  After setting any
         * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.sourcerepo.v1.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.sourcerepo.v1.model.TestIamPermissionsRequest content) {
          super(CloudSourceRepositories.this, "POST", REST_PATH, content, com.google.api.services.sourcerepo.v1.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See the operation
       documentation for the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/repos/.*$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link CloudSourceRepositories}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link CloudSourceRepositories}. */
    @Override
    public CloudSourceRepositories build() {
      return new CloudSourceRepositories(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CloudSourceRepositoriesRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCloudSourceRepositoriesRequestInitializer(
        CloudSourceRepositoriesRequestInitializer cloudsourcerepositoriesRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(cloudsourcerepositoriesRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
