/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sourcerepo.v1.model;

/**
 * Configuration to publish a Cloud Pub/Sub message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Source Repositories API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PubsubConfig extends com.google.api.client.json.GenericJson {

  /**
   * The format of the Cloud Pub/Sub messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageFormat;

  /**
   * Email address of the service account used for publishing Cloud Pub/Sub messages. This service
   * account needs to be in the same project as the PubsubConfig. When added, the caller needs to
   * have iam.serviceAccounts.actAs permission on this service account. If unspecified, it defaults
   * to the compute engine default service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceAccountEmail;

  /**
   * A topic of Cloud Pub/Sub. Values are of the form `projects//topics/`. The project needs to be
   * the same project as this config is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * The format of the Cloud Pub/Sub messages.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageFormat() {
    return messageFormat;
  }

  /**
   * The format of the Cloud Pub/Sub messages.
   * @param messageFormat messageFormat or {@code null} for none
   */
  public PubsubConfig setMessageFormat(java.lang.String messageFormat) {
    this.messageFormat = messageFormat;
    return this;
  }

  /**
   * Email address of the service account used for publishing Cloud Pub/Sub messages. This service
   * account needs to be in the same project as the PubsubConfig. When added, the caller needs to
   * have iam.serviceAccounts.actAs permission on this service account. If unspecified, it defaults
   * to the compute engine default service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceAccountEmail() {
    return serviceAccountEmail;
  }

  /**
   * Email address of the service account used for publishing Cloud Pub/Sub messages. This service
   * account needs to be in the same project as the PubsubConfig. When added, the caller needs to
   * have iam.serviceAccounts.actAs permission on this service account. If unspecified, it defaults
   * to the compute engine default service account.
   * @param serviceAccountEmail serviceAccountEmail or {@code null} for none
   */
  public PubsubConfig setServiceAccountEmail(java.lang.String serviceAccountEmail) {
    this.serviceAccountEmail = serviceAccountEmail;
    return this;
  }

  /**
   * A topic of Cloud Pub/Sub. Values are of the form `projects//topics/`. The project needs to be
   * the same project as this config is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * A topic of Cloud Pub/Sub. Values are of the form `projects//topics/`. The project needs to be
   * the same project as this config is in.
   * @param topic topic or {@code null} for none
   */
  public PubsubConfig setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public PubsubConfig set(String fieldName, Object value) {
    return (PubsubConfig) super.set(fieldName, value);
  }

  @Override
  public PubsubConfig clone() {
    return (PubsubConfig) super.clone();
  }

}
