/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sourcerepo.v1.model;

/**
 * A repository (or repo) is a Git repository storing versioned source content.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Source Repositories API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Repo extends com.google.api.client.json.GenericJson {

  /**
   * How this repository mirrors a repository managed by another service. Read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MirrorConfig mirrorConfig;

  /**
   * Resource name of the repository, of the form `projects//repos/`.  The repo name may contain
   * slashes. eg, `projects/myproject/repos/name/with/slash`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * How this repository publishes a change in the repository through Cloud Pub/Sub. Keyed by the
   * topic names.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, PubsubConfig> pubsubConfigs;

  static {
    // hack to force ProGuard to consider PubsubConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PubsubConfig.class);
  }

  /**
   * The disk usage of the repo, in bytes. Read-only field. Size is only returned by GetRepo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long size;

  /**
   * URL to clone the repository from Google Cloud Source Repositories. Read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * How this repository mirrors a repository managed by another service. Read-only field.
   * @return value or {@code null} for none
   */
  public MirrorConfig getMirrorConfig() {
    return mirrorConfig;
  }

  /**
   * How this repository mirrors a repository managed by another service. Read-only field.
   * @param mirrorConfig mirrorConfig or {@code null} for none
   */
  public Repo setMirrorConfig(MirrorConfig mirrorConfig) {
    this.mirrorConfig = mirrorConfig;
    return this;
  }

  /**
   * Resource name of the repository, of the form `projects//repos/`.  The repo name may contain
   * slashes. eg, `projects/myproject/repos/name/with/slash`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the repository, of the form `projects//repos/`.  The repo name may contain
   * slashes. eg, `projects/myproject/repos/name/with/slash`
   * @param name name or {@code null} for none
   */
  public Repo setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * How this repository publishes a change in the repository through Cloud Pub/Sub. Keyed by the
   * topic names.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, PubsubConfig> getPubsubConfigs() {
    return pubsubConfigs;
  }

  /**
   * How this repository publishes a change in the repository through Cloud Pub/Sub. Keyed by the
   * topic names.
   * @param pubsubConfigs pubsubConfigs or {@code null} for none
   */
  public Repo setPubsubConfigs(java.util.Map<String, PubsubConfig> pubsubConfigs) {
    this.pubsubConfigs = pubsubConfigs;
    return this;
  }

  /**
   * The disk usage of the repo, in bytes. Read-only field. Size is only returned by GetRepo.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSize() {
    return size;
  }

  /**
   * The disk usage of the repo, in bytes. Read-only field. Size is only returned by GetRepo.
   * @param size size or {@code null} for none
   */
  public Repo setSize(java.lang.Long size) {
    this.size = size;
    return this;
  }

  /**
   * URL to clone the repository from Google Cloud Source Repositories. Read-only field.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * URL to clone the repository from Google Cloud Source Repositories. Read-only field.
   * @param url url or {@code null} for none
   */
  public Repo setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public Repo set(String fieldName, Object value) {
    return (Repo) super.set(fieldName, value);
  }

  @Override
  public Repo clone() {
    return (Repo) super.clone();
  }

}
