/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sourcerepo.v1.model;

/**
 * Metadata of SyncRepo.
 *
 * This message is in the metadata field of Operation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Source Repositories API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SyncRepoMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The name of the repo being synchronized. Values are of the form `projects//repos/`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The time this operation is started.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The latest status message on syncing the repository.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * The time this operation's status message is updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * The name of the repo being synchronized. Values are of the form `projects//repos/`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the repo being synchronized. Values are of the form `projects//repos/`.
   * @param name name or {@code null} for none
   */
  public SyncRepoMetadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The time this operation is started.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The time this operation is started.
   * @param startTime startTime or {@code null} for none
   */
  public SyncRepoMetadata setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The latest status message on syncing the repository.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * The latest status message on syncing the repository.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public SyncRepoMetadata setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * The time this operation's status message is updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * The time this operation's status message is updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public SyncRepoMetadata setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public SyncRepoMetadata set(String fieldName, Object value) {
    return (SyncRepoMetadata) super.set(fieldName, value);
  }

  @Override
  public SyncRepoMetadata clone() {
    return (SyncRepoMetadata) super.clone();
  }

}
