/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sourcerepo.v1.model;

/**
 * Request for UpdateProjectConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Source Repositories API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateProjectConfigRequest extends com.google.api.client.json.GenericJson {

  /**
   * The new configuration for the project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProjectConfig projectConfig;

  /**
   * A FieldMask specifying which fields of the project_config to modify. Only the fields in the
   * mask will be modified. If no mask is provided, this request is no-op.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * The new configuration for the project.
   * @return value or {@code null} for none
   */
  public ProjectConfig getProjectConfig() {
    return projectConfig;
  }

  /**
   * The new configuration for the project.
   * @param projectConfig projectConfig or {@code null} for none
   */
  public UpdateProjectConfigRequest setProjectConfig(ProjectConfig projectConfig) {
    this.projectConfig = projectConfig;
    return this;
  }

  /**
   * A FieldMask specifying which fields of the project_config to modify. Only the fields in the
   * mask will be modified. If no mask is provided, this request is no-op.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * A FieldMask specifying which fields of the project_config to modify. Only the fields in the
   * mask will be modified. If no mask is provided, this request is no-op.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateProjectConfigRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateProjectConfigRequest set(String fieldName, Object value) {
    return (UpdateProjectConfigRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateProjectConfigRequest clone() {
    return (UpdateProjectConfigRequest) super.clone();
  }

}
