/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * SslCert insert response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SslCertsInsertResponse extends com.google.api.client.json.GenericJson {

  /**
   * The new client certificate and private key.  For First Generation instances, the new
   * certificate does not take effect until the instance is restarted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SslCertDetail clientCert;

  /**
   * This is always sql#sslCertsInsert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The operation to track the ssl certs insert request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Operation operation;

  /**
   * The server Certificate Authority's certificate.  If this is missing you can force a new one to
   * be generated by calling resetSslConfig method on instances resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SslCert serverCaCert;

  /**
   * The new client certificate and private key.  For First Generation instances, the new
   * certificate does not take effect until the instance is restarted.
   * @return value or {@code null} for none
   */
  public SslCertDetail getClientCert() {
    return clientCert;
  }

  /**
   * The new client certificate and private key.  For First Generation instances, the new
   * certificate does not take effect until the instance is restarted.
   * @param clientCert clientCert or {@code null} for none
   */
  public SslCertsInsertResponse setClientCert(SslCertDetail clientCert) {
    this.clientCert = clientCert;
    return this;
  }

  /**
   * This is always sql#sslCertsInsert.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always sql#sslCertsInsert.
   * @param kind kind or {@code null} for none
   */
  public SslCertsInsertResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The operation to track the ssl certs insert request.
   * @return value or {@code null} for none
   */
  public Operation getOperation() {
    return operation;
  }

  /**
   * The operation to track the ssl certs insert request.
   * @param operation operation or {@code null} for none
   */
  public SslCertsInsertResponse setOperation(Operation operation) {
    this.operation = operation;
    return this;
  }

  /**
   * The server Certificate Authority's certificate.  If this is missing you can force a new one to
   * be generated by calling resetSslConfig method on instances resource.
   * @return value or {@code null} for none
   */
  public SslCert getServerCaCert() {
    return serverCaCert;
  }

  /**
   * The server Certificate Authority's certificate.  If this is missing you can force a new one to
   * be generated by calling resetSslConfig method on instances resource.
   * @param serverCaCert serverCaCert or {@code null} for none
   */
  public SslCertsInsertResponse setServerCaCert(SslCert serverCaCert) {
    this.serverCaCert = serverCaCert;
    return this;
  }

  @Override
  public SslCertsInsertResponse set(String fieldName, Object value) {
    return (SslCertsInsertResponse) super.set(fieldName, value);
  }

  @Override
  public SslCertsInsertResponse clone() {
    return (SslCertsInsertResponse) super.clone();
  }

}
