/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * A Cloud SQL user resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class User extends com.google.api.client.json.GenericJson {

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The host name from which the user can connect. For insert operations, host defaults to an empty
   * string. For update operations, host is specified as part of the request URL. The host name
   * cannot be updated after insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * The name of the Cloud SQL instance. This does not include the project ID. Can be omitted for
   * update since it is already specified on the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * This is always sql#user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the user in the Cloud SQL instance. Can be omitted for update since it is already
   * specified in the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The password for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String password;

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable. Can be omitted for update since it is already specified on the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String project;

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * @param etag etag or {@code null} for none
   */
  public User setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The host name from which the user can connect. For insert operations, host defaults to an empty
   * string. For update operations, host is specified as part of the request URL. The host name
   * cannot be updated after insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * The host name from which the user can connect. For insert operations, host defaults to an empty
   * string. For update operations, host is specified as part of the request URL. The host name
   * cannot be updated after insertion.
   * @param host host or {@code null} for none
   */
  public User setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * The name of the Cloud SQL instance. This does not include the project ID. Can be omitted for
   * update since it is already specified on the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * The name of the Cloud SQL instance. This does not include the project ID. Can be omitted for
   * update since it is already specified on the URL.
   * @param instance instance or {@code null} for none
   */
  public User setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * This is always sql#user.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always sql#user.
   * @param kind kind or {@code null} for none
   */
  public User setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the user in the Cloud SQL instance. Can be omitted for update since it is already
   * specified in the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the user in the Cloud SQL instance. Can be omitted for update since it is already
   * specified in the URL.
   * @param name name or {@code null} for none
   */
  public User setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The password for the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassword() {
    return password;
  }

  /**
   * The password for the user.
   * @param password password or {@code null} for none
   */
  public User setPassword(java.lang.String password) {
    this.password = password;
    return this;
  }

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable. Can be omitted for update since it is already specified on the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getProject() {
    return project;
  }

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable. Can be omitted for update since it is already specified on the URL.
   * @param project project or {@code null} for none
   */
  public User setProject(java.lang.String project) {
    this.project = project;
    return this;
  }

  @Override
  public User set(String fieldName, Object value) {
    return (User) super.set(fieldName, value);
  }

  @Override
  public User clone() {
    return (User) super.clone();
  }

}
