/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * An entry for an Access Control list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AclEntry extends com.google.api.client.json.GenericJson {

  /**
   * The time when this access control entry expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expirationTime;

  /**
   * This is always *sql#aclEntry*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Optional. A label to identify this entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The allowlisted value for the access control list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The time when this access control entry expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * @return value or {@code null} for none
   */
  public String getExpirationTime() {
    return expirationTime;
  }

  /**
   * The time when this access control entry expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public AclEntry setExpirationTime(String expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * This is always *sql#aclEntry*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#aclEntry*.
   * @param kind kind or {@code null} for none
   */
  public AclEntry setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Optional. A label to identify this entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Optional. A label to identify this entry.
   * @param name name or {@code null} for none
   */
  public AclEntry setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The allowlisted value for the access control list.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The allowlisted value for the access control list.
   * @param value value or {@code null} for none
   */
  public AclEntry setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public AclEntry set(String fieldName, Object value) {
    return (AclEntry) super.set(fieldName, value);
  }

  @Override
  public AclEntry clone() {
    return (AclEntry) super.clone();
  }

}
