/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * Represents a SQL database on the Cloud SQL instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Database extends com.google.api.client.json.GenericJson {

  /**
   * The Cloud SQL charset value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String charset;

  /**
   * The Cloud SQL collation value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String collation;

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The name of the Cloud SQL instance. This does not include the project ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * This is always *sql#database*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the database in the Cloud SQL instance. This does not include the project ID or
   * instance name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String project;

  /**
   * The URI of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SqlServerDatabaseDetails sqlserverDatabaseDetails;

  /**
   * The Cloud SQL charset value.
   * @return value or {@code null} for none
   */
  public java.lang.String getCharset() {
    return charset;
  }

  /**
   * The Cloud SQL charset value.
   * @param charset charset or {@code null} for none
   */
  public Database setCharset(java.lang.String charset) {
    this.charset = charset;
    return this;
  }

  /**
   * The Cloud SQL collation value.
   * @return value or {@code null} for none
   */
  public java.lang.String getCollation() {
    return collation;
  }

  /**
   * The Cloud SQL collation value.
   * @param collation collation or {@code null} for none
   */
  public Database setCollation(java.lang.String collation) {
    this.collation = collation;
    return this;
  }

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * This field is deprecated and will be removed from a future version of the API.
   * @param etag etag or {@code null} for none
   */
  public Database setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The name of the Cloud SQL instance. This does not include the project ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * The name of the Cloud SQL instance. This does not include the project ID.
   * @param instance instance or {@code null} for none
   */
  public Database setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * This is always *sql#database*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#database*.
   * @param kind kind or {@code null} for none
   */
  public Database setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the database in the Cloud SQL instance. This does not include the project ID or
   * instance name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the database in the Cloud SQL instance. This does not include the project ID or
   * instance name.
   * @param name name or {@code null} for none
   */
  public Database setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getProject() {
    return project;
  }

  /**
   * The project ID of the project containing the Cloud SQL database. The Google apps domain is
   * prefixed if applicable.
   * @param project project or {@code null} for none
   */
  public Database setProject(java.lang.String project) {
    this.project = project;
    return this;
  }

  /**
   * The URI of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The URI of this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Database setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public SqlServerDatabaseDetails getSqlserverDatabaseDetails() {
    return sqlserverDatabaseDetails;
  }

  /**
   * @param sqlserverDatabaseDetails sqlserverDatabaseDetails or {@code null} for none
   */
  public Database setSqlserverDatabaseDetails(SqlServerDatabaseDetails sqlserverDatabaseDetails) {
    this.sqlserverDatabaseDetails = sqlserverDatabaseDetails;
    return this;
  }

  @Override
  public Database set(String fieldName, Object value) {
    return (Database) super.set(fieldName, value);
  }

  @Override
  public Database clone() {
    return (Database) super.clone();
  }

}
