/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * Database instances list response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of database instance resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DatabaseInstance> items;

  static {
    // hack to force ProGuard to consider DatabaseInstance used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DatabaseInstance.class);
  }

  /**
   * This is always *sql#instancesList*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of warnings that occurred while handling the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApiWarning> warnings;

  static {
    // hack to force ProGuard to consider ApiWarning used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApiWarning.class);
  }

  /**
   * List of database instance resources.
   * @return value or {@code null} for none
   */
  public java.util.List<DatabaseInstance> getItems() {
    return items;
  }

  /**
   * List of database instance resources.
   * @param items items or {@code null} for none
   */
  public InstancesListResponse setItems(java.util.List<DatabaseInstance> items) {
    this.items = items;
    return this;
  }

  /**
   * This is always *sql#instancesList*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#instancesList*.
   * @param kind kind or {@code null} for none
   */
  public InstancesListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public InstancesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * List of warnings that occurred while handling the request.
   * @return value or {@code null} for none
   */
  public java.util.List<ApiWarning> getWarnings() {
    return warnings;
  }

  /**
   * List of warnings that occurred while handling the request.
   * @param warnings warnings or {@code null} for none
   */
  public InstancesListResponse setWarnings(java.util.List<ApiWarning> warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public InstancesListResponse set(String fieldName, Object value) {
    return (InstancesListResponse) super.set(fieldName, value);
  }

  @Override
  public InstancesListResponse clone() {
    return (InstancesListResponse) super.clone();
  }

}
