/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * Database instance list operations response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperationsListResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of operation resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Operation> items;

  static {
    // hack to force ProGuard to consider Operation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Operation.class);
  }

  /**
   * This is always *sql#operationsList*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of operation resources.
   * @return value or {@code null} for none
   */
  public java.util.List<Operation> getItems() {
    return items;
  }

  /**
   * List of operation resources.
   * @param items items or {@code null} for none
   */
  public OperationsListResponse setItems(java.util.List<Operation> items) {
    this.items = items;
    return this;
  }

  /**
   * This is always *sql#operationsList*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#operationsList*.
   * @param kind kind or {@code null} for none
   */
  public OperationsListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public OperationsListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public OperationsListResponse set(String fieldName, Object value) {
    return (OperationsListResponse) super.set(fieldName, value);
  }

  @Override
  public OperationsListResponse clone() {
    return (OperationsListResponse) super.clone();
  }

}
