/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sql.model;

/**
 * Database instance restore from backup context. Backup context contains source instance id and
 * project id.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RestoreBackupContext extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the backup run to restore from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long backupRunId;

  /**
   * The ID of the instance that the backup was taken from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceId;

  /**
   * This is always *sql#restoreBackupContext*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The full project ID of the source instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String project;

  /**
   * The ID of the backup run to restore from.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBackupRunId() {
    return backupRunId;
  }

  /**
   * The ID of the backup run to restore from.
   * @param backupRunId backupRunId or {@code null} for none
   */
  public RestoreBackupContext setBackupRunId(java.lang.Long backupRunId) {
    this.backupRunId = backupRunId;
    return this;
  }

  /**
   * The ID of the instance that the backup was taken from.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceId() {
    return instanceId;
  }

  /**
   * The ID of the instance that the backup was taken from.
   * @param instanceId instanceId or {@code null} for none
   */
  public RestoreBackupContext setInstanceId(java.lang.String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

  /**
   * This is always *sql#restoreBackupContext*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#restoreBackupContext*.
   * @param kind kind or {@code null} for none
   */
  public RestoreBackupContext setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The full project ID of the source instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getProject() {
    return project;
  }

  /**
   * The full project ID of the source instance.
   * @param project project or {@code null} for none
   */
  public RestoreBackupContext setProject(java.lang.String project) {
    this.project = project;
    return this;
  }

  @Override
  public RestoreBackupContext set(String fieldName, Object value) {
    return (RestoreBackupContext) super.set(fieldName, value);
  }

  @Override
  public RestoreBackupContext clone() {
    return (RestoreBackupContext) super.clone();
  }

}
