/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Instance start external sync request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SqlInstancesStartExternalSyncRequest extends com.google.api.client.json.GenericJson {

  /**
   * MySQL-specific settings for start external sync.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MySqlSyncConfig mysqlSyncConfig;

  /**
   * Whether to skip the verification step (VESS).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean skipVerification;

  /**
   * External sync mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String syncMode;

  /**
   * Optional. Parallel level for initial data sync. Currently only applicable for MySQL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String syncParallelLevel;

  /**
   * MySQL-specific settings for start external sync.
   * @return value or {@code null} for none
   */
  public MySqlSyncConfig getMysqlSyncConfig() {
    return mysqlSyncConfig;
  }

  /**
   * MySQL-specific settings for start external sync.
   * @param mysqlSyncConfig mysqlSyncConfig or {@code null} for none
   */
  public SqlInstancesStartExternalSyncRequest setMysqlSyncConfig(MySqlSyncConfig mysqlSyncConfig) {
    this.mysqlSyncConfig = mysqlSyncConfig;
    return this;
  }

  /**
   * Whether to skip the verification step (VESS).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSkipVerification() {
    return skipVerification;
  }

  /**
   * Whether to skip the verification step (VESS).
   * @param skipVerification skipVerification or {@code null} for none
   */
  public SqlInstancesStartExternalSyncRequest setSkipVerification(java.lang.Boolean skipVerification) {
    this.skipVerification = skipVerification;
    return this;
  }

  /**
   * External sync mode.
   * @return value or {@code null} for none
   */
  public java.lang.String getSyncMode() {
    return syncMode;
  }

  /**
   * External sync mode.
   * @param syncMode syncMode or {@code null} for none
   */
  public SqlInstancesStartExternalSyncRequest setSyncMode(java.lang.String syncMode) {
    this.syncMode = syncMode;
    return this;
  }

  /**
   * Optional. Parallel level for initial data sync. Currently only applicable for MySQL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSyncParallelLevel() {
    return syncParallelLevel;
  }

  /**
   * Optional. Parallel level for initial data sync. Currently only applicable for MySQL.
   * @param syncParallelLevel syncParallelLevel or {@code null} for none
   */
  public SqlInstancesStartExternalSyncRequest setSyncParallelLevel(java.lang.String syncParallelLevel) {
    this.syncParallelLevel = syncParallelLevel;
    return this;
  }

  @Override
  public SqlInstancesStartExternalSyncRequest set(String fieldName, Object value) {
    return (SqlInstancesStartExternalSyncRequest) super.set(fieldName, value);
  }

  @Override
  public SqlInstancesStartExternalSyncRequest clone() {
    return (SqlInstancesStartExternalSyncRequest) super.clone();
  }

}
