/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Acquire SSRS lease context.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AcquireSsrsLeaseContext extends com.google.api.client.json.GenericJson {

  /**
   * Lease duration needed for SSRS setup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String duration;

  /**
   * The report database to be used for SSRS setup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportDatabase;

  /**
   * The username to be used as the service login to connect to the report database for SSRS setup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceLogin;

  /**
   * The username to be used as the setup login to connect to the database server for SSRS setup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String setupLogin;

  /**
   * Lease duration needed for SSRS setup.
   * @return value or {@code null} for none
   */
  public String getDuration() {
    return duration;
  }

  /**
   * Lease duration needed for SSRS setup.
   * @param duration duration or {@code null} for none
   */
  public AcquireSsrsLeaseContext setDuration(String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * The report database to be used for SSRS setup.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportDatabase() {
    return reportDatabase;
  }

  /**
   * The report database to be used for SSRS setup.
   * @param reportDatabase reportDatabase or {@code null} for none
   */
  public AcquireSsrsLeaseContext setReportDatabase(java.lang.String reportDatabase) {
    this.reportDatabase = reportDatabase;
    return this;
  }

  /**
   * The username to be used as the service login to connect to the report database for SSRS setup.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceLogin() {
    return serviceLogin;
  }

  /**
   * The username to be used as the service login to connect to the report database for SSRS setup.
   * @param serviceLogin serviceLogin or {@code null} for none
   */
  public AcquireSsrsLeaseContext setServiceLogin(java.lang.String serviceLogin) {
    this.serviceLogin = serviceLogin;
    return this;
  }

  /**
   * The username to be used as the setup login to connect to the database server for SSRS setup.
   * @return value or {@code null} for none
   */
  public java.lang.String getSetupLogin() {
    return setupLogin;
  }

  /**
   * The username to be used as the setup login to connect to the database server for SSRS setup.
   * @param setupLogin setupLogin or {@code null} for none
   */
  public AcquireSsrsLeaseContext setSetupLogin(java.lang.String setupLogin) {
    this.setupLogin = setupLogin;
    return this;
  }

  @Override
  public AcquireSsrsLeaseContext set(String fieldName, Object value) {
    return (AcquireSsrsLeaseContext) super.set(fieldName, value);
  }

  @Override
  public AcquireSsrsLeaseContext clone() {
    return (AcquireSsrsLeaseContext) super.clone();
  }

}
