/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * This context is used to demote an existing standalone instance to be a Cloud SQL read replica for
 * an external database server.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DemoteContext extends com.google.api.client.json.GenericJson {

  /**
   * This is always `sql#demoteContext`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Required. The name of the instance which acts as the on-premises primary instance in the
   * replication setup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceRepresentativeInstanceName;

  /**
   * This is always `sql#demoteContext`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always `sql#demoteContext`.
   * @param kind kind or {@code null} for none
   */
  public DemoteContext setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Required. The name of the instance which acts as the on-premises primary instance in the
   * replication setup.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceRepresentativeInstanceName() {
    return sourceRepresentativeInstanceName;
  }

  /**
   * Required. The name of the instance which acts as the on-premises primary instance in the
   * replication setup.
   * @param sourceRepresentativeInstanceName sourceRepresentativeInstanceName or {@code null} for none
   */
  public DemoteContext setSourceRepresentativeInstanceName(java.lang.String sourceRepresentativeInstanceName) {
    this.sourceRepresentativeInstanceName = sourceRepresentativeInstanceName;
    return this;
  }

  @Override
  public DemoteContext set(String fieldName, Object value) {
    return (DemoteContext) super.set(fieldName, value);
  }

  @Override
  public DemoteContext clone() {
    return (DemoteContext) super.clone();
  }

}
