/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Read-only password status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PasswordStatus extends com.google.api.client.json.GenericJson {

  /**
   * If true, user does not have login privileges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean locked;

  /**
   * The expiration time of the current password.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String passwordExpirationTime;

  /**
   * If true, user does not have login privileges.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLocked() {
    return locked;
  }

  /**
   * If true, user does not have login privileges.
   * @param locked locked or {@code null} for none
   */
  public PasswordStatus setLocked(java.lang.Boolean locked) {
    this.locked = locked;
    return this;
  }

  /**
   * The expiration time of the current password.
   * @return value or {@code null} for none
   */
  public String getPasswordExpirationTime() {
    return passwordExpirationTime;
  }

  /**
   * The expiration time of the current password.
   * @param passwordExpirationTime passwordExpirationTime or {@code null} for none
   */
  public PasswordStatus setPasswordExpirationTime(String passwordExpirationTime) {
    this.passwordExpirationTime = passwordExpirationTime;
    return this;
  }

  @Override
  public PasswordStatus set(String fieldName, Object value) {
    return (PasswordStatus) super.set(fieldName, value);
  }

  @Override
  public PasswordStatus clone() {
    return (PasswordStatus) super.clone();
  }

}
