/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * PSC settings for a Cloud SQL instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PscConfig extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The list of consumer projects that are allow-listed for PSC connections to this
   * instance. This instance can be connected to with PSC from any network in these projects. Each
   * consumer project in this list may be represented by a project number (numeric) or by a project
   * id (alphanumeric).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedConsumerProjects;

  /**
   * Optional. The list of settings for requested Private Service Connect consumer endpoints that
   * can be used to connect to this Cloud SQL instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PscAutoConnectionConfig> pscAutoConnections;

  static {
    // hack to force ProGuard to consider PscAutoConnectionConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PscAutoConnectionConfig.class);
  }

  /**
   * Whether PSC connectivity is enabled for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pscEnabled;

  /**
   * Optional. The list of consumer projects that are allow-listed for PSC connections to this
   * instance. This instance can be connected to with PSC from any network in these projects. Each
   * consumer project in this list may be represented by a project number (numeric) or by a project
   * id (alphanumeric).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedConsumerProjects() {
    return allowedConsumerProjects;
  }

  /**
   * Optional. The list of consumer projects that are allow-listed for PSC connections to this
   * instance. This instance can be connected to with PSC from any network in these projects. Each
   * consumer project in this list may be represented by a project number (numeric) or by a project
   * id (alphanumeric).
   * @param allowedConsumerProjects allowedConsumerProjects or {@code null} for none
   */
  public PscConfig setAllowedConsumerProjects(java.util.List<java.lang.String> allowedConsumerProjects) {
    this.allowedConsumerProjects = allowedConsumerProjects;
    return this;
  }

  /**
   * Optional. The list of settings for requested Private Service Connect consumer endpoints that
   * can be used to connect to this Cloud SQL instance.
   * @return value or {@code null} for none
   */
  public java.util.List<PscAutoConnectionConfig> getPscAutoConnections() {
    return pscAutoConnections;
  }

  /**
   * Optional. The list of settings for requested Private Service Connect consumer endpoints that
   * can be used to connect to this Cloud SQL instance.
   * @param pscAutoConnections pscAutoConnections or {@code null} for none
   */
  public PscConfig setPscAutoConnections(java.util.List<PscAutoConnectionConfig> pscAutoConnections) {
    this.pscAutoConnections = pscAutoConnections;
    return this;
  }

  /**
   * Whether PSC connectivity is enabled for this instance.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPscEnabled() {
    return pscEnabled;
  }

  /**
   * Whether PSC connectivity is enabled for this instance.
   * @param pscEnabled pscEnabled or {@code null} for none
   */
  public PscConfig setPscEnabled(java.lang.Boolean pscEnabled) {
    this.pscEnabled = pscEnabled;
    return this;
  }

  @Override
  public PscConfig set(String fieldName, Object value) {
    return (PscConfig) super.set(fieldName, value);
  }

  @Override
  public PscConfig clone() {
    return (PscConfig) super.clone();
  }

}
