/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin;

/**
 * Service definition for SQLAdmin (v1beta4).
 *
 * <p>
 * Creates and manages Cloud SQL instances, which provide fully managed MySQL or PostgreSQL databases.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/sql/docs/reference/latest" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link SQLAdminRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class SQLAdmin extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.1 of the Cloud SQL Admin API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "sql/v1beta4/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/sqladmin/v1beta4";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public SQLAdmin(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  SQLAdmin(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the BackupRuns collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.BackupRuns.List request = sqladmin.backupRuns().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackupRuns backupRuns() {
    return new BackupRuns();
  }

  /**
   * The "backupRuns" collection of methods.
   */
  public class BackupRuns {

    /**
     * Deletes the backup taken by a backup run.
     *
     * Create a request for the method "backupRuns.delete".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param id The ID of the Backup Run to delete. To find a Backup Run ID, use the list method.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instance, java.lang.Long id) throws java.io.IOException {
      Delete result = new Delete(project, instance, id);
      initialize(result);
      return result;
    }

    public class Delete extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns/{id}";

      /**
       * Deletes the backup taken by a backup run.
       *
       * Create a request for the method "backupRuns.delete".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param id The ID of the Backup Run to delete. To find a Backup Run ID, use the list method.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instance, java.lang.Long id) {
        super(SQLAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Delete setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** The ID of the Backup Run to delete. To find a Backup Run ID, use the list method. */
      @com.google.api.client.util.Key
      private java.lang.Long id;

      /** The ID of the Backup Run to delete. To find a Backup Run ID, use the list method.
       */
      public java.lang.Long getId() {
        return id;
      }

      /** The ID of the Backup Run to delete. To find a Backup Run ID, use the list method. */
      public Delete setId(java.lang.Long id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a resource containing information about a backup run.
     *
     * Create a request for the method "backupRuns.get".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param id The ID of this Backup Run.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instance, java.lang.Long id) throws java.io.IOException {
      Get result = new Get(project, instance, id);
      initialize(result);
      return result;
    }

    public class Get extends SQLAdminRequest<com.google.api.services.sqladmin.model.BackupRun> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns/{id}";

      /**
       * Retrieves a resource containing information about a backup run.
       *
       * Create a request for the method "backupRuns.get".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param id The ID of this Backup Run.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instance, java.lang.Long id) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.BackupRun.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Get setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** The ID of this Backup Run. */
      @com.google.api.client.util.Key
      private java.lang.Long id;

      /** The ID of this Backup Run.
       */
      public java.lang.Long getId() {
        return id;
      }

      /** The ID of this Backup Run. */
      public Get setId(java.lang.Long id) {
        this.id = id;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new backup run on demand. This method is applicable only to Second Generation
     * instances.
     *
     * Create a request for the method "backupRuns.insert".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.BackupRun}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.BackupRun content) throws java.io.IOException {
      Insert result = new Insert(project, instance, content);
      initialize(result);
      return result;
    }

    public class Insert extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns";

      /**
       * Creates a new backup run on demand. This method is applicable only to Second Generation
       * instances.
       *
       * Create a request for the method "backupRuns.insert".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.BackupRun}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.BackupRun content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Insert setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all backup runs associated with a given instance and configuration in the reverse
     * chronological order of the backup initiation time.
     *
     * Create a request for the method "backupRuns.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      List result = new List(project, instance);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.BackupRunsListResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns";

      /**
       * Lists all backup runs associated with a given instance and configuration in the reverse
       * chronological order of the backup initiation time.
       *
       * Create a request for the method "backupRuns.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.BackupRunsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public List setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Maximum number of backup runs per response. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of backup runs per response.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of backup runs per response. */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Databases collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Databases.List request = sqladmin.databases().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Databases databases() {
    return new Databases();
  }

  /**
   * The "databases" collection of methods.
   */
  public class Databases {

    /**
     * Deletes a database from a Cloud SQL instance.
     *
     * Create a request for the method "databases.delete".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param database Name of the database to be deleted in the instance.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instance, java.lang.String database) throws java.io.IOException {
      Delete result = new Delete(project, instance, database);
      initialize(result);
      return result;
    }

    public class Delete extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";

      /**
       * Deletes a database from a Cloud SQL instance.
       *
       * Create a request for the method "databases.delete".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param database Name of the database to be deleted in the instance.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instance, java.lang.String database) {
        super(SQLAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.database = com.google.api.client.util.Preconditions.checkNotNull(database, "Required parameter database must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Delete setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Name of the database to be deleted in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String database;

      /** Name of the database to be deleted in the instance.
       */
      public java.lang.String getDatabase() {
        return database;
      }

      /** Name of the database to be deleted in the instance. */
      public Delete setDatabase(java.lang.String database) {
        this.database = database;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a resource containing information about a database inside a Cloud SQL instance.
     *
     * Create a request for the method "databases.get".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param database Name of the database in the instance.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instance, java.lang.String database) throws java.io.IOException {
      Get result = new Get(project, instance, database);
      initialize(result);
      return result;
    }

    public class Get extends SQLAdminRequest<com.google.api.services.sqladmin.model.Database> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";

      /**
       * Retrieves a resource containing information about a database inside a Cloud SQL instance.
       *
       * Create a request for the method "databases.get".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param database Name of the database in the instance.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instance, java.lang.String database) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.Database.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.database = com.google.api.client.util.Preconditions.checkNotNull(database, "Required parameter database must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Get setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Name of the database in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String database;

      /** Name of the database in the instance.
       */
      public java.lang.String getDatabase() {
        return database;
      }

      /** Name of the database in the instance. */
      public Get setDatabase(java.lang.String database) {
        this.database = database;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a resource containing information about a database inside a Cloud SQL instance.
     *
     * Create a request for the method "databases.insert".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.Database}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.Database content) throws java.io.IOException {
      Insert result = new Insert(project, instance, content);
      initialize(result);
      return result;
    }

    public class Insert extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases";

      /**
       * Inserts a resource containing information about a database inside a Cloud SQL instance.
       *
       * Create a request for the method "databases.insert".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.Database}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.Database content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Insert setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists databases in the specified Cloud SQL instance.
     *
     * Create a request for the method "databases.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      List result = new List(project, instance);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.DatabasesListResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases";

      /**
       * Lists databases in the specified Cloud SQL instance.
       *
       * Create a request for the method "databases.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.DatabasesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public List setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a resource containing information about a database inside a Cloud SQL instance. This
     * method supports patch semantics.
     *
     * Create a request for the method "databases.patch".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param database Name of the database to be updated in the instance.
     * @param content the {@link com.google.api.services.sqladmin.model.Database}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String instance, java.lang.String database, com.google.api.services.sqladmin.model.Database content) throws java.io.IOException {
      Patch result = new Patch(project, instance, database, content);
      initialize(result);
      return result;
    }

    public class Patch extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";

      /**
       * Updates a resource containing information about a database inside a Cloud SQL instance. This
       * method supports patch semantics.
       *
       * Create a request for the method "databases.patch".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param database Name of the database to be updated in the instance.
       * @param content the {@link com.google.api.services.sqladmin.model.Database}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String instance, java.lang.String database, com.google.api.services.sqladmin.model.Database content) {
        super(SQLAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.database = com.google.api.client.util.Preconditions.checkNotNull(database, "Required parameter database must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Patch setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Name of the database to be updated in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String database;

      /** Name of the database to be updated in the instance.
       */
      public java.lang.String getDatabase() {
        return database;
      }

      /** Name of the database to be updated in the instance. */
      public Patch setDatabase(java.lang.String database) {
        this.database = database;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a resource containing information about a database inside a Cloud SQL instance.
     *
     * Create a request for the method "databases.update".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param database Name of the database to be updated in the instance.
     * @param content the {@link com.google.api.services.sqladmin.model.Database}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String instance, java.lang.String database, com.google.api.services.sqladmin.model.Database content) throws java.io.IOException {
      Update result = new Update(project, instance, database, content);
      initialize(result);
      return result;
    }

    public class Update extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";

      /**
       * Updates a resource containing information about a database inside a Cloud SQL instance.
       *
       * Create a request for the method "databases.update".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param database Name of the database to be updated in the instance.
       * @param content the {@link com.google.api.services.sqladmin.model.Database}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String instance, java.lang.String database, com.google.api.services.sqladmin.model.Database content) {
        super(SQLAdmin.this, "PUT", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.database = com.google.api.client.util.Preconditions.checkNotNull(database, "Required parameter database must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Update setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Name of the database to be updated in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String database;

      /** Name of the database to be updated in the instance.
       */
      public java.lang.String getDatabase() {
        return database;
      }

      /** Name of the database to be updated in the instance. */
      public Update setDatabase(java.lang.String database) {
        this.database = database;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Flags collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Flags.List request = sqladmin.flags().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Flags flags() {
    return new Flags();
  }

  /**
   * The "flags" collection of methods.
   */
  public class Flags {

    /**
     * List all available database flags for Cloud SQL instances.
     *
     * Create a request for the method "flags.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.FlagsListResponse> {

      private static final String REST_PATH = "flags";

      /**
       * List all available database flags for Cloud SQL instances.
       *
       * Create a request for the method "flags.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.FlagsListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Database type and version you want to retrieve flags for. By default, this method returns
       * flags for all database types and versions.
       */
      @com.google.api.client.util.Key
      private java.lang.String databaseVersion;

      /** Database type and version you want to retrieve flags for. By default, this method returns flags for
     all database types and versions.
       */
      public java.lang.String getDatabaseVersion() {
        return databaseVersion;
      }

      /**
       * Database type and version you want to retrieve flags for. By default, this method returns
       * flags for all database types and versions.
       */
      public List setDatabaseVersion(java.lang.String databaseVersion) {
        this.databaseVersion = databaseVersion;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Instances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Instances.List request = sqladmin.instances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Instances instances() {
    return new Instances();
  }

  /**
   * The "instances" collection of methods.
   */
  public class Instances {

    /**
     * Add a new trusted Certificate Authority (CA) version for the specified instance. Required to
     * prepare for a certificate rotation. If a CA version was previously added but never used in a
     * certificate rotation, this operation replaces that version. There cannot be more than one CA
     * version waiting to be rotated in.
     *
     * Create a request for the method "instances.addServerCa".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link AddServerCa#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public AddServerCa addServerCa(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      AddServerCa result = new AddServerCa(project, instance);
      initialize(result);
      return result;
    }

    public class AddServerCa extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/addServerCa";

      /**
       * Add a new trusted Certificate Authority (CA) version for the specified instance. Required to
       * prepare for a certificate rotation. If a CA version was previously added but never used in a
       * certificate rotation, this operation replaces that version. There cannot be more than one CA
       * version waiting to be rotated in.
       *
       * Create a request for the method "instances.addServerCa".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link AddServerCa#execute()} method to invoke the remote
       * operation. <p> {@link
       * AddServerCa#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected AddServerCa(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public AddServerCa setAlt(java.lang.String alt) {
        return (AddServerCa) super.setAlt(alt);
      }

      @Override
      public AddServerCa setFields(java.lang.String fields) {
        return (AddServerCa) super.setFields(fields);
      }

      @Override
      public AddServerCa setKey(java.lang.String key) {
        return (AddServerCa) super.setKey(key);
      }

      @Override
      public AddServerCa setOauthToken(java.lang.String oauthToken) {
        return (AddServerCa) super.setOauthToken(oauthToken);
      }

      @Override
      public AddServerCa setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddServerCa) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddServerCa setQuotaUser(java.lang.String quotaUser) {
        return (AddServerCa) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddServerCa setUserIp(java.lang.String userIp) {
        return (AddServerCa) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public AddServerCa setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public AddServerCa setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public AddServerCa set(String parameterName, Object value) {
        return (AddServerCa) super.set(parameterName, value);
      }
    }
    /**
     * Creates a Cloud SQL instance as a clone of the source instance.
     *
     * Create a request for the method "instances.clone".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Clone#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the source as well as the clone Cloud SQL instance.
     * @param instance The ID of the Cloud SQL instance to be cloned (source). This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesCloneRequest}
     * @return the request
     */
    public Clone clone(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesCloneRequest content) throws java.io.IOException {
      Clone result = new Clone(project, instance, content);
      initialize(result);
      return result;
    }

    public class Clone extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/clone";

      /**
       * Creates a Cloud SQL instance as a clone of the source instance.
       *
       * Create a request for the method "instances.clone".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Clone#execute()} method to invoke the remote operation.
       * <p> {@link
       * Clone#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the source as well as the clone Cloud SQL instance.
       * @param instance The ID of the Cloud SQL instance to be cloned (source). This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesCloneRequest}
       * @since 1.13
       */
      protected Clone(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesCloneRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Clone setAlt(java.lang.String alt) {
        return (Clone) super.setAlt(alt);
      }

      @Override
      public Clone setFields(java.lang.String fields) {
        return (Clone) super.setFields(fields);
      }

      @Override
      public Clone setKey(java.lang.String key) {
        return (Clone) super.setKey(key);
      }

      @Override
      public Clone setOauthToken(java.lang.String oauthToken) {
        return (Clone) super.setOauthToken(oauthToken);
      }

      @Override
      public Clone setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Clone) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Clone setQuotaUser(java.lang.String quotaUser) {
        return (Clone) super.setQuotaUser(quotaUser);
      }

      @Override
      public Clone setUserIp(java.lang.String userIp) {
        return (Clone) super.setUserIp(userIp);
      }

      /** Project ID of the source as well as the clone Cloud SQL instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the source as well as the clone Cloud SQL instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the source as well as the clone Cloud SQL instance. */
      public Clone setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * The ID of the Cloud SQL instance to be cloned (source). This does not include the project
       * ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The ID of the Cloud SQL instance to be cloned (source). This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /**
       * The ID of the Cloud SQL instance to be cloned (source). This does not include the project
       * ID.
       */
      public Clone setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Clone set(String parameterName, Object value) {
        return (Clone) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a Cloud SQL instance.
     *
     * Create a request for the method "instances.delete".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance to be deleted.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      Delete result = new Delete(project, instance);
      initialize(result);
      return result;
    }

    public class Delete extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}";

      /**
       * Deletes a Cloud SQL instance.
       *
       * Create a request for the method "instances.delete".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance to be deleted.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance to be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance to be deleted.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance to be deleted. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Delete setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Demotes the stand-alone instance to be a Cloud SQL read replica for an external database server.
     *
     * Create a request for the method "instances.demoteMaster".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link DemoteMaster#execute()} method to invoke the remote operation.
     *
     * @param project ID of the project that contains the instance.
     * @param instance Cloud SQL instance name.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesDemoteMasterRequest}
     * @return the request
     */
    public DemoteMaster demoteMaster(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesDemoteMasterRequest content) throws java.io.IOException {
      DemoteMaster result = new DemoteMaster(project, instance, content);
      initialize(result);
      return result;
    }

    public class DemoteMaster extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/demoteMaster";

      /**
       * Demotes the stand-alone instance to be a Cloud SQL read replica for an external database
       * server.
       *
       * Create a request for the method "instances.demoteMaster".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link DemoteMaster#execute()} method to invoke the remote
       * operation. <p> {@link
       * DemoteMaster#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project ID of the project that contains the instance.
       * @param instance Cloud SQL instance name.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesDemoteMasterRequest}
       * @since 1.13
       */
      protected DemoteMaster(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesDemoteMasterRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public DemoteMaster setAlt(java.lang.String alt) {
        return (DemoteMaster) super.setAlt(alt);
      }

      @Override
      public DemoteMaster setFields(java.lang.String fields) {
        return (DemoteMaster) super.setFields(fields);
      }

      @Override
      public DemoteMaster setKey(java.lang.String key) {
        return (DemoteMaster) super.setKey(key);
      }

      @Override
      public DemoteMaster setOauthToken(java.lang.String oauthToken) {
        return (DemoteMaster) super.setOauthToken(oauthToken);
      }

      @Override
      public DemoteMaster setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DemoteMaster) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DemoteMaster setQuotaUser(java.lang.String quotaUser) {
        return (DemoteMaster) super.setQuotaUser(quotaUser);
      }

      @Override
      public DemoteMaster setUserIp(java.lang.String userIp) {
        return (DemoteMaster) super.setUserIp(userIp);
      }

      /** ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** ID of the project that contains the instance. */
      public DemoteMaster setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance name. */
      public DemoteMaster setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public DemoteMaster set(String parameterName, Object value) {
        return (DemoteMaster) super.set(parameterName, value);
      }
    }
    /**
     * Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL dump or CSV file.
     *
     * Create a request for the method "instances.export".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Export#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance to be exported.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesExportRequest}
     * @return the request
     */
    public Export export(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesExportRequest content) throws java.io.IOException {
      Export result = new Export(project, instance, content);
      initialize(result);
      return result;
    }

    public class Export extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/export";

      /**
       * Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL dump or CSV file.
       *
       * Create a request for the method "instances.export".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Export#execute()} method to invoke the remote operation.
       * <p> {@link
       * Export#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance to be exported.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesExportRequest}
       * @since 1.13
       */
      protected Export(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesExportRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Export setAlt(java.lang.String alt) {
        return (Export) super.setAlt(alt);
      }

      @Override
      public Export setFields(java.lang.String fields) {
        return (Export) super.setFields(fields);
      }

      @Override
      public Export setKey(java.lang.String key) {
        return (Export) super.setKey(key);
      }

      @Override
      public Export setOauthToken(java.lang.String oauthToken) {
        return (Export) super.setOauthToken(oauthToken);
      }

      @Override
      public Export setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Export) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Export setQuotaUser(java.lang.String quotaUser) {
        return (Export) super.setQuotaUser(quotaUser);
      }

      @Override
      public Export setUserIp(java.lang.String userIp) {
        return (Export) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance to be exported. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance to be exported.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance to be exported. */
      public Export setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Export setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Export set(String parameterName, Object value) {
        return (Export) super.set(parameterName, value);
      }
    }
    /**
     * Failover the instance to its failover replica instance.
     *
     * Create a request for the method "instances.failover".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Failover#execute()} method to invoke the remote operation.
     *
     * @param project ID of the project that contains the read replica.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesFailoverRequest}
     * @return the request
     */
    public Failover failover(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesFailoverRequest content) throws java.io.IOException {
      Failover result = new Failover(project, instance, content);
      initialize(result);
      return result;
    }

    public class Failover extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/failover";

      /**
       * Failover the instance to its failover replica instance.
       *
       * Create a request for the method "instances.failover".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Failover#execute()} method to invoke the remote operation.
       * <p> {@link
       * Failover#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project ID of the project that contains the read replica.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesFailoverRequest}
       * @since 1.13
       */
      protected Failover(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesFailoverRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Failover setAlt(java.lang.String alt) {
        return (Failover) super.setAlt(alt);
      }

      @Override
      public Failover setFields(java.lang.String fields) {
        return (Failover) super.setFields(fields);
      }

      @Override
      public Failover setKey(java.lang.String key) {
        return (Failover) super.setKey(key);
      }

      @Override
      public Failover setOauthToken(java.lang.String oauthToken) {
        return (Failover) super.setOauthToken(oauthToken);
      }

      @Override
      public Failover setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Failover) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Failover setQuotaUser(java.lang.String quotaUser) {
        return (Failover) super.setQuotaUser(quotaUser);
      }

      @Override
      public Failover setUserIp(java.lang.String userIp) {
        return (Failover) super.setUserIp(userIp);
      }

      /** ID of the project that contains the read replica. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** ID of the project that contains the read replica.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** ID of the project that contains the read replica. */
      public Failover setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Failover setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Failover set(String parameterName, Object value) {
        return (Failover) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a resource containing information about a Cloud SQL instance.
     *
     * Create a request for the method "instances.get".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      Get result = new Get(project, instance);
      initialize(result);
      return result;
    }

    public class Get extends SQLAdminRequest<com.google.api.services.sqladmin.model.DatabaseInstance> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}";

      /**
       * Retrieves a resource containing information about a Cloud SQL instance.
       *
       * Create a request for the method "instances.get".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.DatabaseInstance.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Get setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Imports data into a Cloud SQL instance from a SQL dump or CSV file in Cloud Storage.
     *
     * Create a request for the method "instances.import".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link SQLAdminImport#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesImportRequest}
     * @return the request
     */
    public SQLAdminImport sqladminImport(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesImportRequest content) throws java.io.IOException {
      SQLAdminImport result = new SQLAdminImport(project, instance, content);
      initialize(result);
      return result;
    }

    public class SQLAdminImport extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/import";

      /**
       * Imports data into a Cloud SQL instance from a SQL dump or CSV file in Cloud Storage.
       *
       * Create a request for the method "instances.import".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link SQLAdminImport#execute()} method to invoke the remote
       * operation. <p> {@link SQLAdminImport#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesImportRequest}
       * @since 1.13
       */
      protected SQLAdminImport(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesImportRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public SQLAdminImport setAlt(java.lang.String alt) {
        return (SQLAdminImport) super.setAlt(alt);
      }

      @Override
      public SQLAdminImport setFields(java.lang.String fields) {
        return (SQLAdminImport) super.setFields(fields);
      }

      @Override
      public SQLAdminImport setKey(java.lang.String key) {
        return (SQLAdminImport) super.setKey(key);
      }

      @Override
      public SQLAdminImport setOauthToken(java.lang.String oauthToken) {
        return (SQLAdminImport) super.setOauthToken(oauthToken);
      }

      @Override
      public SQLAdminImport setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SQLAdminImport) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SQLAdminImport setQuotaUser(java.lang.String quotaUser) {
        return (SQLAdminImport) super.setQuotaUser(quotaUser);
      }

      @Override
      public SQLAdminImport setUserIp(java.lang.String userIp) {
        return (SQLAdminImport) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public SQLAdminImport setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public SQLAdminImport setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public SQLAdminImport set(String parameterName, Object value) {
        return (SQLAdminImport) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new Cloud SQL instance.
     *
     * Create a request for the method "instances.insert".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project to which the newly created Cloud SQL instances should belong.
     * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.sqladmin.model.DatabaseInstance content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances";

      /**
       * Creates a new Cloud SQL instance.
       *
       * Create a request for the method "instances.insert".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project to which the newly created Cloud SQL instances should belong.
       * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.sqladmin.model.DatabaseInstance content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Project ID of the project to which the newly created Cloud SQL instances should belong.
       */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project to which the newly created Cloud SQL instances should belong.
       */
      public java.lang.String getProject() {
        return project;
      }

      /**
       * Project ID of the project to which the newly created Cloud SQL instances should belong.
       */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists instances under a given project in the alphabetical order of the instance name.
     *
     * Create a request for the method "instances.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project for which to list Cloud SQL instances.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.InstancesListResponse> {

      private static final String REST_PATH = "projects/{project}/instances";

      /**
       * Lists instances under a given project in the alphabetical order of the instance name.
       *
       * Create a request for the method "instances.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project for which to list Cloud SQL instances.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.InstancesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project for which to list Cloud SQL instances. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project for which to list Cloud SQL instances.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project for which to list Cloud SQL instances. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** An expression for filtering the results of the request, such as by name or label. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An expression for filtering the results of the request, such as by name or label.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** An expression for filtering the results of the request, such as by name or label. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The maximum number of results to return per response. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return per response.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** The maximum number of results to return per response. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the trusted Certificate Authorities (CAs) for the specified instance. There can be
     * up to three CAs listed: the CA that was used to sign the certificate that is currently in use, a
     * CA that has been added but not yet used to sign a certificate, and a CA used to sign a
     * certificate that has previously rotated out.
     *
     * Create a request for the method "instances.listServerCas".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link ListServerCas#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public ListServerCas listServerCas(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      ListServerCas result = new ListServerCas(project, instance);
      initialize(result);
      return result;
    }

    public class ListServerCas extends SQLAdminRequest<com.google.api.services.sqladmin.model.InstancesListServerCasResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/listServerCas";

      /**
       * Lists all of the trusted Certificate Authorities (CAs) for the specified instance. There can be
       * up to three CAs listed: the CA that was used to sign the certificate that is currently in use,
       * a CA that has been added but not yet used to sign a certificate, and a CA used to sign a
       * certificate that has previously rotated out.
       *
       * Create a request for the method "instances.listServerCas".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link ListServerCas#execute()} method to invoke the remote
       * operation. <p> {@link ListServerCas#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected ListServerCas(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.InstancesListServerCasResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListServerCas setAlt(java.lang.String alt) {
        return (ListServerCas) super.setAlt(alt);
      }

      @Override
      public ListServerCas setFields(java.lang.String fields) {
        return (ListServerCas) super.setFields(fields);
      }

      @Override
      public ListServerCas setKey(java.lang.String key) {
        return (ListServerCas) super.setKey(key);
      }

      @Override
      public ListServerCas setOauthToken(java.lang.String oauthToken) {
        return (ListServerCas) super.setOauthToken(oauthToken);
      }

      @Override
      public ListServerCas setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListServerCas) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListServerCas setQuotaUser(java.lang.String quotaUser) {
        return (ListServerCas) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListServerCas setUserIp(java.lang.String userIp) {
        return (ListServerCas) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public ListServerCas setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public ListServerCas setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public ListServerCas set(String parameterName, Object value) {
        return (ListServerCas) super.set(parameterName, value);
      }
    }
    /**
     * Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must
     * include values for all the settings that you want to retain. For partial updates, use patch..
     * This method supports patch semantics.
     *
     * Create a request for the method "instances.patch".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.DatabaseInstance content) throws java.io.IOException {
      Patch result = new Patch(project, instance, content);
      initialize(result);
      return result;
    }

    public class Patch extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}";

      /**
       * Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must
       * include values for all the settings that you want to retain. For partial updates, use patch..
       * This method supports patch semantics.
       *
       * Create a request for the method "instances.patch".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.DatabaseInstance content) {
        super(SQLAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Patch setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Patch setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Promotes the read replica instance to be a stand-alone Cloud SQL instance.
     *
     * Create a request for the method "instances.promoteReplica".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link PromoteReplica#execute()} method to invoke the remote operation.
     *
     * @param project ID of the project that contains the read replica.
     * @param instance Cloud SQL read replica instance name.
     * @return the request
     */
    public PromoteReplica promoteReplica(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      PromoteReplica result = new PromoteReplica(project, instance);
      initialize(result);
      return result;
    }

    public class PromoteReplica extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/promoteReplica";

      /**
       * Promotes the read replica instance to be a stand-alone Cloud SQL instance.
       *
       * Create a request for the method "instances.promoteReplica".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link PromoteReplica#execute()} method to invoke the remote
       * operation. <p> {@link PromoteReplica#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project ID of the project that contains the read replica.
       * @param instance Cloud SQL read replica instance name.
       * @since 1.13
       */
      protected PromoteReplica(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public PromoteReplica setAlt(java.lang.String alt) {
        return (PromoteReplica) super.setAlt(alt);
      }

      @Override
      public PromoteReplica setFields(java.lang.String fields) {
        return (PromoteReplica) super.setFields(fields);
      }

      @Override
      public PromoteReplica setKey(java.lang.String key) {
        return (PromoteReplica) super.setKey(key);
      }

      @Override
      public PromoteReplica setOauthToken(java.lang.String oauthToken) {
        return (PromoteReplica) super.setOauthToken(oauthToken);
      }

      @Override
      public PromoteReplica setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (PromoteReplica) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public PromoteReplica setQuotaUser(java.lang.String quotaUser) {
        return (PromoteReplica) super.setQuotaUser(quotaUser);
      }

      @Override
      public PromoteReplica setUserIp(java.lang.String userIp) {
        return (PromoteReplica) super.setUserIp(userIp);
      }

      /** ID of the project that contains the read replica. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** ID of the project that contains the read replica.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** ID of the project that contains the read replica. */
      public PromoteReplica setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL read replica instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL read replica instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL read replica instance name. */
      public PromoteReplica setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public PromoteReplica set(String parameterName, Object value) {
        return (PromoteReplica) super.set(parameterName, value);
      }
    }
    /**
     * Deletes all client certificates and generates a new server SSL certificate for the instance.
     *
     * Create a request for the method "instances.resetSslConfig".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link ResetSslConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public ResetSslConfig resetSslConfig(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      ResetSslConfig result = new ResetSslConfig(project, instance);
      initialize(result);
      return result;
    }

    public class ResetSslConfig extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/resetSslConfig";

      /**
       * Deletes all client certificates and generates a new server SSL certificate for the instance.
       *
       * Create a request for the method "instances.resetSslConfig".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link ResetSslConfig#execute()} method to invoke the remote
       * operation. <p> {@link ResetSslConfig#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected ResetSslConfig(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public ResetSslConfig setAlt(java.lang.String alt) {
        return (ResetSslConfig) super.setAlt(alt);
      }

      @Override
      public ResetSslConfig setFields(java.lang.String fields) {
        return (ResetSslConfig) super.setFields(fields);
      }

      @Override
      public ResetSslConfig setKey(java.lang.String key) {
        return (ResetSslConfig) super.setKey(key);
      }

      @Override
      public ResetSslConfig setOauthToken(java.lang.String oauthToken) {
        return (ResetSslConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetSslConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetSslConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetSslConfig setQuotaUser(java.lang.String quotaUser) {
        return (ResetSslConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetSslConfig setUserIp(java.lang.String userIp) {
        return (ResetSslConfig) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public ResetSslConfig setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public ResetSslConfig setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public ResetSslConfig set(String parameterName, Object value) {
        return (ResetSslConfig) super.set(parameterName, value);
      }
    }
    /**
     * Restarts a Cloud SQL instance.
     *
     * Create a request for the method "instances.restart".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Restart#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance to be restarted.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public Restart restart(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      Restart result = new Restart(project, instance);
      initialize(result);
      return result;
    }

    public class Restart extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/restart";

      /**
       * Restarts a Cloud SQL instance.
       *
       * Create a request for the method "instances.restart".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Restart#execute()} method to invoke the remote operation.
       * <p> {@link
       * Restart#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance to be restarted.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected Restart(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Restart setAlt(java.lang.String alt) {
        return (Restart) super.setAlt(alt);
      }

      @Override
      public Restart setFields(java.lang.String fields) {
        return (Restart) super.setFields(fields);
      }

      @Override
      public Restart setKey(java.lang.String key) {
        return (Restart) super.setKey(key);
      }

      @Override
      public Restart setOauthToken(java.lang.String oauthToken) {
        return (Restart) super.setOauthToken(oauthToken);
      }

      @Override
      public Restart setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Restart) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Restart setQuotaUser(java.lang.String quotaUser) {
        return (Restart) super.setQuotaUser(quotaUser);
      }

      @Override
      public Restart setUserIp(java.lang.String userIp) {
        return (Restart) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance to be restarted. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance to be restarted.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance to be restarted. */
      public Restart setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Restart setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Restart set(String parameterName, Object value) {
        return (Restart) super.set(parameterName, value);
      }
    }
    /**
     * Restores a backup of a Cloud SQL instance.
     *
     * Create a request for the method "instances.restoreBackup".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link RestoreBackup#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest}
     * @return the request
     */
    public RestoreBackup restoreBackup(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest content) throws java.io.IOException {
      RestoreBackup result = new RestoreBackup(project, instance, content);
      initialize(result);
      return result;
    }

    public class RestoreBackup extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/restoreBackup";

      /**
       * Restores a backup of a Cloud SQL instance.
       *
       * Create a request for the method "instances.restoreBackup".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link RestoreBackup#execute()} method to invoke the remote
       * operation. <p> {@link RestoreBackup#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest}
       * @since 1.13
       */
      protected RestoreBackup(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public RestoreBackup setAlt(java.lang.String alt) {
        return (RestoreBackup) super.setAlt(alt);
      }

      @Override
      public RestoreBackup setFields(java.lang.String fields) {
        return (RestoreBackup) super.setFields(fields);
      }

      @Override
      public RestoreBackup setKey(java.lang.String key) {
        return (RestoreBackup) super.setKey(key);
      }

      @Override
      public RestoreBackup setOauthToken(java.lang.String oauthToken) {
        return (RestoreBackup) super.setOauthToken(oauthToken);
      }

      @Override
      public RestoreBackup setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RestoreBackup) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RestoreBackup setQuotaUser(java.lang.String quotaUser) {
        return (RestoreBackup) super.setQuotaUser(quotaUser);
      }

      @Override
      public RestoreBackup setUserIp(java.lang.String userIp) {
        return (RestoreBackup) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public RestoreBackup setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public RestoreBackup setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public RestoreBackup set(String parameterName, Object value) {
        return (RestoreBackup) super.set(parameterName, value);
      }
    }
    /**
     * Rotates the server certificate to one signed by the Certificate Authority (CA) version previously
     * added with the addServerCA method.
     *
     * Create a request for the method "instances.rotateServerCa".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link RotateServerCa#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesRotateServerCaRequest}
     * @return the request
     */
    public RotateServerCa rotateServerCa(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesRotateServerCaRequest content) throws java.io.IOException {
      RotateServerCa result = new RotateServerCa(project, instance, content);
      initialize(result);
      return result;
    }

    public class RotateServerCa extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/rotateServerCa";

      /**
       * Rotates the server certificate to one signed by the Certificate Authority (CA) version
       * previously added with the addServerCA method.
       *
       * Create a request for the method "instances.rotateServerCa".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link RotateServerCa#execute()} method to invoke the remote
       * operation. <p> {@link RotateServerCa#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesRotateServerCaRequest}
       * @since 1.13
       */
      protected RotateServerCa(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesRotateServerCaRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public RotateServerCa setAlt(java.lang.String alt) {
        return (RotateServerCa) super.setAlt(alt);
      }

      @Override
      public RotateServerCa setFields(java.lang.String fields) {
        return (RotateServerCa) super.setFields(fields);
      }

      @Override
      public RotateServerCa setKey(java.lang.String key) {
        return (RotateServerCa) super.setKey(key);
      }

      @Override
      public RotateServerCa setOauthToken(java.lang.String oauthToken) {
        return (RotateServerCa) super.setOauthToken(oauthToken);
      }

      @Override
      public RotateServerCa setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RotateServerCa) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RotateServerCa setQuotaUser(java.lang.String quotaUser) {
        return (RotateServerCa) super.setQuotaUser(quotaUser);
      }

      @Override
      public RotateServerCa setUserIp(java.lang.String userIp) {
        return (RotateServerCa) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public RotateServerCa setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public RotateServerCa setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public RotateServerCa set(String parameterName, Object value) {
        return (RotateServerCa) super.set(parameterName, value);
      }
    }
    /**
     * Starts the replication in the read replica instance.
     *
     * Create a request for the method "instances.startReplica".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link StartReplica#execute()} method to invoke the remote operation.
     *
     * @param project ID of the project that contains the read replica.
     * @param instance Cloud SQL read replica instance name.
     * @return the request
     */
    public StartReplica startReplica(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      StartReplica result = new StartReplica(project, instance);
      initialize(result);
      return result;
    }

    public class StartReplica extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/startReplica";

      /**
       * Starts the replication in the read replica instance.
       *
       * Create a request for the method "instances.startReplica".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link StartReplica#execute()} method to invoke the remote
       * operation. <p> {@link
       * StartReplica#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project ID of the project that contains the read replica.
       * @param instance Cloud SQL read replica instance name.
       * @since 1.13
       */
      protected StartReplica(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public StartReplica setAlt(java.lang.String alt) {
        return (StartReplica) super.setAlt(alt);
      }

      @Override
      public StartReplica setFields(java.lang.String fields) {
        return (StartReplica) super.setFields(fields);
      }

      @Override
      public StartReplica setKey(java.lang.String key) {
        return (StartReplica) super.setKey(key);
      }

      @Override
      public StartReplica setOauthToken(java.lang.String oauthToken) {
        return (StartReplica) super.setOauthToken(oauthToken);
      }

      @Override
      public StartReplica setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (StartReplica) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public StartReplica setQuotaUser(java.lang.String quotaUser) {
        return (StartReplica) super.setQuotaUser(quotaUser);
      }

      @Override
      public StartReplica setUserIp(java.lang.String userIp) {
        return (StartReplica) super.setUserIp(userIp);
      }

      /** ID of the project that contains the read replica. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** ID of the project that contains the read replica.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** ID of the project that contains the read replica. */
      public StartReplica setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL read replica instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL read replica instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL read replica instance name. */
      public StartReplica setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public StartReplica set(String parameterName, Object value) {
        return (StartReplica) super.set(parameterName, value);
      }
    }
    /**
     * Stops the replication in the read replica instance.
     *
     * Create a request for the method "instances.stopReplica".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link StopReplica#execute()} method to invoke the remote operation.
     *
     * @param project ID of the project that contains the read replica.
     * @param instance Cloud SQL read replica instance name.
     * @return the request
     */
    public StopReplica stopReplica(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      StopReplica result = new StopReplica(project, instance);
      initialize(result);
      return result;
    }

    public class StopReplica extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/stopReplica";

      /**
       * Stops the replication in the read replica instance.
       *
       * Create a request for the method "instances.stopReplica".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link StopReplica#execute()} method to invoke the remote
       * operation. <p> {@link
       * StopReplica#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project ID of the project that contains the read replica.
       * @param instance Cloud SQL read replica instance name.
       * @since 1.13
       */
      protected StopReplica(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "POST", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public StopReplica setAlt(java.lang.String alt) {
        return (StopReplica) super.setAlt(alt);
      }

      @Override
      public StopReplica setFields(java.lang.String fields) {
        return (StopReplica) super.setFields(fields);
      }

      @Override
      public StopReplica setKey(java.lang.String key) {
        return (StopReplica) super.setKey(key);
      }

      @Override
      public StopReplica setOauthToken(java.lang.String oauthToken) {
        return (StopReplica) super.setOauthToken(oauthToken);
      }

      @Override
      public StopReplica setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (StopReplica) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public StopReplica setQuotaUser(java.lang.String quotaUser) {
        return (StopReplica) super.setQuotaUser(quotaUser);
      }

      @Override
      public StopReplica setUserIp(java.lang.String userIp) {
        return (StopReplica) super.setUserIp(userIp);
      }

      /** ID of the project that contains the read replica. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** ID of the project that contains the read replica.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** ID of the project that contains the read replica. */
      public StopReplica setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL read replica instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL read replica instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL read replica instance name. */
      public StopReplica setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public StopReplica set(String parameterName, Object value) {
        return (StopReplica) super.set(parameterName, value);
      }
    }
    /**
     * Truncate MySQL general and slow query log tables
     *
     * Create a request for the method "instances.truncateLog".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link TruncateLog#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the Cloud SQL project.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.InstancesTruncateLogRequest}
     * @return the request
     */
    public TruncateLog truncateLog(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesTruncateLogRequest content) throws java.io.IOException {
      TruncateLog result = new TruncateLog(project, instance, content);
      initialize(result);
      return result;
    }

    public class TruncateLog extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/truncateLog";

      /**
       * Truncate MySQL general and slow query log tables
       *
       * Create a request for the method "instances.truncateLog".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link TruncateLog#execute()} method to invoke the remote
       * operation. <p> {@link
       * TruncateLog#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the Cloud SQL project.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.InstancesTruncateLogRequest}
       * @since 1.13
       */
      protected TruncateLog(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.InstancesTruncateLogRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public TruncateLog setAlt(java.lang.String alt) {
        return (TruncateLog) super.setAlt(alt);
      }

      @Override
      public TruncateLog setFields(java.lang.String fields) {
        return (TruncateLog) super.setFields(fields);
      }

      @Override
      public TruncateLog setKey(java.lang.String key) {
        return (TruncateLog) super.setKey(key);
      }

      @Override
      public TruncateLog setOauthToken(java.lang.String oauthToken) {
        return (TruncateLog) super.setOauthToken(oauthToken);
      }

      @Override
      public TruncateLog setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TruncateLog) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TruncateLog setQuotaUser(java.lang.String quotaUser) {
        return (TruncateLog) super.setQuotaUser(quotaUser);
      }

      @Override
      public TruncateLog setUserIp(java.lang.String userIp) {
        return (TruncateLog) super.setUserIp(userIp);
      }

      /** Project ID of the Cloud SQL project. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the Cloud SQL project.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the Cloud SQL project. */
      public TruncateLog setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public TruncateLog setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public TruncateLog set(String parameterName, Object value) {
        return (TruncateLog) super.set(parameterName, value);
      }
    }
    /**
     * Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must
     * include values for all the settings that you want to retain. For partial updates, use patch.
     *
     * Create a request for the method "instances.update".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.DatabaseInstance content) throws java.io.IOException {
      Update result = new Update(project, instance, content);
      initialize(result);
      return result;
    }

    public class Update extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}";

      /**
       * Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must
       * include values for all the settings that you want to retain. For partial updates, use patch.
       *
       * Create a request for the method "instances.update".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.DatabaseInstance}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.DatabaseInstance content) {
        super(SQLAdmin.this, "PUT", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Update setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Operations.List request = sqladmin.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Retrieves an instance operation that has been performed on an instance.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param operation Instance operation ID.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/operations/{operation}";

      /**
       * Retrieves an instance operation that has been performed on an instance.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param operation Instance operation ID.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String operation) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Instance operation ID. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Instance operation ID.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Instance operation ID. */
      public Get setOperation(java.lang.String operation) {
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all instance operations that have been performed on the given Cloud SQL instance in the
     * reverse chronological order of the start time.
     *
     * Create a request for the method "operations.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      List result = new List(project, instance);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.OperationsListResponse> {

      private static final String REST_PATH = "projects/{project}/operations";

      /**
       * Lists all instance operations that have been performed on the given Cloud SQL instance in the
       * reverse chronological order of the start time.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.OperationsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public List setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Maximum number of operations per response. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of operations per response.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of operations per response. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the SslCerts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.SslCerts.List request = sqladmin.sslCerts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public SslCerts sslCerts() {
    return new SslCerts();
  }

  /**
   * The "sslCerts" collection of methods.
   */
  public class SslCerts {

    /**
     * Generates a short-lived X509 certificate containing the provided public key and signed by a
     * private key specific to the target instance. Users may use the certificate to authenticate as
     * themselves when connecting to the database.
     *
     * Create a request for the method "sslCerts.createEphemeral".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link CreateEphemeral#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the Cloud SQL project.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest}
     * @return the request
     */
    public CreateEphemeral createEphemeral(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest content) throws java.io.IOException {
      CreateEphemeral result = new CreateEphemeral(project, instance, content);
      initialize(result);
      return result;
    }

    public class CreateEphemeral extends SQLAdminRequest<com.google.api.services.sqladmin.model.SslCert> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/createEphemeral";

      /**
       * Generates a short-lived X509 certificate containing the provided public key and signed by a
       * private key specific to the target instance. Users may use the certificate to authenticate as
       * themselves when connecting to the database.
       *
       * Create a request for the method "sslCerts.createEphemeral".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link CreateEphemeral#execute()} method to invoke the remote
       * operation. <p> {@link CreateEphemeral#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param project Project ID of the Cloud SQL project.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest}
       * @since 1.13
       */
      protected CreateEphemeral(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.SslCert.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public CreateEphemeral setAlt(java.lang.String alt) {
        return (CreateEphemeral) super.setAlt(alt);
      }

      @Override
      public CreateEphemeral setFields(java.lang.String fields) {
        return (CreateEphemeral) super.setFields(fields);
      }

      @Override
      public CreateEphemeral setKey(java.lang.String key) {
        return (CreateEphemeral) super.setKey(key);
      }

      @Override
      public CreateEphemeral setOauthToken(java.lang.String oauthToken) {
        return (CreateEphemeral) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateEphemeral setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateEphemeral) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateEphemeral setQuotaUser(java.lang.String quotaUser) {
        return (CreateEphemeral) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateEphemeral setUserIp(java.lang.String userIp) {
        return (CreateEphemeral) super.setUserIp(userIp);
      }

      /** Project ID of the Cloud SQL project. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the Cloud SQL project.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the Cloud SQL project. */
      public CreateEphemeral setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public CreateEphemeral setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public CreateEphemeral set(String parameterName, Object value) {
        return (CreateEphemeral) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the SSL certificate. For First Generation instances, the certificate remains valid until
     * the instance is restarted.
     *
     * Create a request for the method "sslCerts.delete".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param sha1Fingerprint Sha1 FingerPrint.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instance, java.lang.String sha1Fingerprint) throws java.io.IOException {
      Delete result = new Delete(project, instance, sha1Fingerprint);
      initialize(result);
      return result;
    }

    public class Delete extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";

      /**
       * Deletes the SSL certificate. For First Generation instances, the certificate remains valid
       * until the instance is restarted.
       *
       * Create a request for the method "sslCerts.delete".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param sha1Fingerprint Sha1 FingerPrint.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instance, java.lang.String sha1Fingerprint) {
        super(SQLAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.sha1Fingerprint = com.google.api.client.util.Preconditions.checkNotNull(sha1Fingerprint, "Required parameter sha1Fingerprint must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Delete setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Sha1 FingerPrint. */
      @com.google.api.client.util.Key
      private java.lang.String sha1Fingerprint;

      /** Sha1 FingerPrint.
       */
      public java.lang.String getSha1Fingerprint() {
        return sha1Fingerprint;
      }

      /** Sha1 FingerPrint. */
      public Delete setSha1Fingerprint(java.lang.String sha1Fingerprint) {
        this.sha1Fingerprint = sha1Fingerprint;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a particular SSL certificate. Does not include the private key (required for usage).
     * The private key must be saved from the response to initial creation.
     *
     * Create a request for the method "sslCerts.get".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param sha1Fingerprint Sha1 FingerPrint.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instance, java.lang.String sha1Fingerprint) throws java.io.IOException {
      Get result = new Get(project, instance, sha1Fingerprint);
      initialize(result);
      return result;
    }

    public class Get extends SQLAdminRequest<com.google.api.services.sqladmin.model.SslCert> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";

      /**
       * Retrieves a particular SSL certificate. Does not include the private key (required for usage).
       * The private key must be saved from the response to initial creation.
       *
       * Create a request for the method "sslCerts.get".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param sha1Fingerprint Sha1 FingerPrint.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instance, java.lang.String sha1Fingerprint) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.SslCert.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.sha1Fingerprint = com.google.api.client.util.Preconditions.checkNotNull(sha1Fingerprint, "Required parameter sha1Fingerprint must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Get setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Sha1 FingerPrint. */
      @com.google.api.client.util.Key
      private java.lang.String sha1Fingerprint;

      /** Sha1 FingerPrint.
       */
      public java.lang.String getSha1Fingerprint() {
        return sha1Fingerprint;
      }

      /** Sha1 FingerPrint. */
      public Get setSha1Fingerprint(java.lang.String sha1Fingerprint) {
        this.sha1Fingerprint = sha1Fingerprint;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an SSL certificate and returns it along with the private key and server certificate
     * authority. The new certificate will not be usable until the instance is restarted.
     *
     * Create a request for the method "sslCerts.insert".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.SslCertsInsertRequest}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.SslCertsInsertRequest content) throws java.io.IOException {
      Insert result = new Insert(project, instance, content);
      initialize(result);
      return result;
    }

    public class Insert extends SQLAdminRequest<com.google.api.services.sqladmin.model.SslCertsInsertResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts";

      /**
       * Creates an SSL certificate and returns it along with the private key and server certificate
       * authority. The new certificate will not be usable until the instance is restarted.
       *
       * Create a request for the method "sslCerts.insert".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.SslCertsInsertRequest}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.SslCertsInsertRequest content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.SslCertsInsertResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public Insert setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the current SSL certificates for the instance.
     *
     * Create a request for the method "sslCerts.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Cloud SQL instance ID. This does not include the project ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      List result = new List(project, instance);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.SslCertsListResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts";

      /**
       * Lists all of the current SSL certificates for the instance.
       *
       * Create a request for the method "sslCerts.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Cloud SQL instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.SslCertsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Cloud SQL instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Cloud SQL instance ID. This does not include the project ID. */
      public List setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tiers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Tiers.List request = sqladmin.tiers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tiers tiers() {
    return new Tiers();
  }

  /**
   * The "tiers" collection of methods.
   */
  public class Tiers {

    /**
     * Lists all available machine types (tiers) for Cloud SQL, for example, db-n1-standard-1. For
     * related information, see Pricing.
     *
     * Create a request for the method "tiers.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project for which to list tiers.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.TiersListResponse> {

      private static final String REST_PATH = "projects/{project}/tiers";

      /**
       * Lists all available machine types (tiers) for Cloud SQL, for example, db-n1-standard-1. For
       * related information, see Pricing.
       *
       * Create a request for the method "tiers.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project for which to list tiers.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.TiersListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project for which to list tiers. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project for which to list tiers.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project for which to list tiers. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Users collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code SQLAdmin sqladmin = new SQLAdmin(...);}
   *   {@code SQLAdmin.Users.List request = sqladmin.users().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Users users() {
    return new Users();
  }

  /**
   * The "users" collection of methods.
   */
  public class Users {

    /**
     * Deletes a user from a Cloud SQL instance.
     *
     * Create a request for the method "users.delete".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param host Host of the user in the instance.
     * @param name Name of the user in the instance.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instance, java.lang.String host, java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(project, instance, host, name);
      initialize(result);
      return result;
    }

    public class Delete extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/users";

      /**
       * Deletes a user from a Cloud SQL instance.
       *
       * Create a request for the method "users.delete".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param host Host of the user in the instance.
       * @param name Name of the user in the instance.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instance, java.lang.String host, java.lang.String name) {
        super(SQLAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.host = com.google.api.client.util.Preconditions.checkNotNull(host, "Required parameter host must be specified.");
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Delete setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Host of the user in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String host;

      /** Host of the user in the instance.
       */
      public java.lang.String getHost() {
        return host;
      }

      /** Host of the user in the instance. */
      public Delete setHost(java.lang.String host) {
        this.host = host;
        return this;
      }

      /** Name of the user in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the user in the instance.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Name of the user in the instance. */
      public Delete setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new user in a Cloud SQL instance.
     *
     * Create a request for the method "users.insert".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param content the {@link com.google.api.services.sqladmin.model.User}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.User content) throws java.io.IOException {
      Insert result = new Insert(project, instance, content);
      initialize(result);
      return result;
    }

    public class Insert extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/users";

      /**
       * Creates a new user in a Cloud SQL instance.
       *
       * Create a request for the method "users.insert".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param content the {@link com.google.api.services.sqladmin.model.User}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String instance, com.google.api.services.sqladmin.model.User content) {
        super(SQLAdmin.this, "POST", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Insert setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists users in the specified Cloud SQL instance.
     *
     * Create a request for the method "users.list".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String instance) throws java.io.IOException {
      List result = new List(project, instance);
      initialize(result);
      return result;
    }

    public class List extends SQLAdminRequest<com.google.api.services.sqladmin.model.UsersListResponse> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/users";

      /**
       * Lists users in the specified Cloud SQL instance.
       *
       * Create a request for the method "users.list".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String instance) {
        super(SQLAdmin.this, "GET", REST_PATH, null, com.google.api.services.sqladmin.model.UsersListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public List setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing user in a Cloud SQL instance.
     *
     * Create a request for the method "users.update".
     *
     * This request holds the parameters needed by the sqladmin server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID of the project that contains the instance.
     * @param instance Database instance ID. This does not include the project ID.
     * @param name Name of the user in the instance.
     * @param content the {@link com.google.api.services.sqladmin.model.User}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String instance, java.lang.String name, com.google.api.services.sqladmin.model.User content) throws java.io.IOException {
      Update result = new Update(project, instance, name, content);
      initialize(result);
      return result;
    }

    public class Update extends SQLAdminRequest<com.google.api.services.sqladmin.model.Operation> {

      private static final String REST_PATH = "projects/{project}/instances/{instance}/users";

      /**
       * Updates an existing user in a Cloud SQL instance.
       *
       * Create a request for the method "users.update".
       *
       * This request holds the parameters needed by the the sqladmin server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID of the project that contains the instance.
       * @param instance Database instance ID. This does not include the project ID.
       * @param name Name of the user in the instance.
       * @param content the {@link com.google.api.services.sqladmin.model.User}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String instance, java.lang.String name, com.google.api.services.sqladmin.model.User content) {
        super(SQLAdmin.this, "PUT", REST_PATH, content, com.google.api.services.sqladmin.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the project that contains the instance. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID of the project that contains the instance.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID of the project that contains the instance. */
      public Update setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Database instance ID. This does not include the project ID. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Database instance ID. This does not include the project ID.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Database instance ID. This does not include the project ID. */
      public Update setInstance(java.lang.String instance) {
        this.instance = instance;
        return this;
      }

      /** Name of the user in the instance. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the user in the instance.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Name of the user in the instance. */
      public Update setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * Host of the user in the instance. For a MySQL instance, it's required; For a PostgreSQL
       * instance, it's optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String host;

      /** Host of the user in the instance. For a MySQL instance, it's required; For a PostgreSQL instance,
     it's optional.
       */
      public java.lang.String getHost() {
        return host;
      }

      /**
       * Host of the user in the instance. For a MySQL instance, it's required; For a PostgreSQL
       * instance, it's optional.
       */
      public Update setHost(java.lang.String host) {
        this.host = host;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link SQLAdmin}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link SQLAdmin}. */
    @Override
    public SQLAdmin build() {
      return new SQLAdmin(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link SQLAdminRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setSQLAdminRequestInitializer(
        SQLAdminRequestInitializer sqladminRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(sqladminRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
