/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Database instance IP Mapping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IpMapping extends com.google.api.client.json.GenericJson {

  /**
   * The IP address assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * The due time for this IP to be retired in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*. This field is only available when the IP is scheduled to be
   * retired.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timeToRetire;

  /**
   * The type of this IP address. A *PRIMARY* address is a public address that can accept incoming
   * connections. A *PRIVATE* address is a private address that can accept incoming connections. An
   * *OUTGOING* address is the source address of connections originating from the instance, if
   * supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The IP address assigned.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * The IP address assigned.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public IpMapping setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * The due time for this IP to be retired in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*. This field is only available when the IP is scheduled to be
   * retired.
   * @return value or {@code null} for none
   */
  public String getTimeToRetire() {
    return timeToRetire;
  }

  /**
   * The due time for this IP to be retired in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*. This field is only available when the IP is scheduled to be
   * retired.
   * @param timeToRetire timeToRetire or {@code null} for none
   */
  public IpMapping setTimeToRetire(String timeToRetire) {
    this.timeToRetire = timeToRetire;
    return this;
  }

  /**
   * The type of this IP address. A *PRIMARY* address is a public address that can accept incoming
   * connections. A *PRIVATE* address is a private address that can accept incoming connections. An
   * *OUTGOING* address is the source address of connections originating from the instance, if
   * supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of this IP address. A *PRIMARY* address is a public address that can accept incoming
   * connections. A *PRIVATE* address is a private address that can accept incoming connections. An
   * *OUTGOING* address is the source address of connections originating from the instance, if
   * supported.
   * @param type type or {@code null} for none
   */
  public IpMapping setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public IpMapping set(String fieldName, Object value) {
    return (IpMapping) super.set(fieldName, value);
  }

  @Override
  public IpMapping clone() {
    return (IpMapping) super.clone();
  }

}
