/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * SslCerts Resource
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SslCert extends com.google.api.client.json.GenericJson {

  /**
   * PEM representation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cert;

  /**
   * Serial number, as extracted from the certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String certSerialNumber;

  /**
   * User supplied name. Constrained to [a-zA-Z.-_ ]+.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commonName;

  /**
   * The time when the certificate was created in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The time when the certificate expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expirationTime;

  /**
   * Name of the database instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * This is always *sql#sslCert*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The URI of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Sha1 Fingerprint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha1Fingerprint;

  /**
   * PEM representation.
   * @return value or {@code null} for none
   */
  public java.lang.String getCert() {
    return cert;
  }

  /**
   * PEM representation.
   * @param cert cert or {@code null} for none
   */
  public SslCert setCert(java.lang.String cert) {
    this.cert = cert;
    return this;
  }

  /**
   * Serial number, as extracted from the certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getCertSerialNumber() {
    return certSerialNumber;
  }

  /**
   * Serial number, as extracted from the certificate.
   * @param certSerialNumber certSerialNumber or {@code null} for none
   */
  public SslCert setCertSerialNumber(java.lang.String certSerialNumber) {
    this.certSerialNumber = certSerialNumber;
    return this;
  }

  /**
   * User supplied name. Constrained to [a-zA-Z.-_ ]+.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommonName() {
    return commonName;
  }

  /**
   * User supplied name. Constrained to [a-zA-Z.-_ ]+.
   * @param commonName commonName or {@code null} for none
   */
  public SslCert setCommonName(java.lang.String commonName) {
    this.commonName = commonName;
    return this;
  }

  /**
   * The time when the certificate was created in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The time when the certificate was created in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*
   * @param createTime createTime or {@code null} for none
   */
  public SslCert setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The time when the certificate expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * @return value or {@code null} for none
   */
  public String getExpirationTime() {
    return expirationTime;
  }

  /**
   * The time when the certificate expires in RFC 3339 format, for example
   * *2012-11-15T16:19:00.094Z*.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public SslCert setExpirationTime(String expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * Name of the database instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * Name of the database instance.
   * @param instance instance or {@code null} for none
   */
  public SslCert setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * This is always *sql#sslCert*.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always *sql#sslCert*.
   * @param kind kind or {@code null} for none
   */
  public SslCert setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The URI of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The URI of this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public SslCert setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Sha1 Fingerprint.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha1Fingerprint() {
    return sha1Fingerprint;
  }

  /**
   * Sha1 Fingerprint.
   * @param sha1Fingerprint sha1Fingerprint or {@code null} for none
   */
  public SslCert setSha1Fingerprint(java.lang.String sha1Fingerprint) {
    this.sha1Fingerprint = sha1Fingerprint;
    return this;
  }

  @Override
  public SslCert set(String fieldName, Object value) {
    return (SslCert) super.set(fieldName, value);
  }

  @Override
  public SslCert clone() {
    return (SslCert) super.clone();
  }

}
