/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Ephemeral certificate creation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenerateEphemeralCertRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Access token to include in the signed certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("access_token")
  private java.lang.String accessToken;

  /**
   * PEM encoded public key to include in the signed certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("public_key")
  private java.lang.String publicKey;

  /**
   * Optional. Optional snapshot read timestamp to trade freshness for performance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String readTime;

  /**
   * Optional. If set, it will contain the cert valid duration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String validDuration;

  /**
   * Optional. Access token to include in the signed certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessToken() {
    return accessToken;
  }

  /**
   * Optional. Access token to include in the signed certificate.
   * @param accessToken accessToken or {@code null} for none
   */
  public GenerateEphemeralCertRequest setAccessToken(java.lang.String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

  /**
   * PEM encoded public key to include in the signed certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicKey() {
    return publicKey;
  }

  /**
   * PEM encoded public key to include in the signed certificate.
   * @param publicKey publicKey or {@code null} for none
   */
  public GenerateEphemeralCertRequest setPublicKey(java.lang.String publicKey) {
    this.publicKey = publicKey;
    return this;
  }

  /**
   * Optional. Optional snapshot read timestamp to trade freshness for performance.
   * @return value or {@code null} for none
   */
  public String getReadTime() {
    return readTime;
  }

  /**
   * Optional. Optional snapshot read timestamp to trade freshness for performance.
   * @param readTime readTime or {@code null} for none
   */
  public GenerateEphemeralCertRequest setReadTime(String readTime) {
    this.readTime = readTime;
    return this;
  }

  /**
   * Optional. If set, it will contain the cert valid duration.
   * @return value or {@code null} for none
   */
  public String getValidDuration() {
    return validDuration;
  }

  /**
   * Optional. If set, it will contain the cert valid duration.
   * @param validDuration validDuration or {@code null} for none
   */
  public GenerateEphemeralCertRequest setValidDuration(String validDuration) {
    this.validDuration = validDuration;
    return this;
  }

  @Override
  public GenerateEphemeralCertRequest set(String fieldName, Object value) {
    return (GenerateEphemeralCertRequest) super.set(fieldName, value);
  }

  @Override
  public GenerateEphemeralCertRequest clone() {
    return (GenerateEphemeralCertRequest) super.clone();
  }

}
