/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Represents a Sql Server database on the Cloud SQL instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SqlServerDatabaseDetails extends com.google.api.client.json.GenericJson {

  /**
   * The version of SQL Server with which the database is to be made compatible
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer compatibilityLevel;

  /**
   * The recovery model of a SQL Server database
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recoveryModel;

  /**
   * The version of SQL Server with which the database is to be made compatible
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCompatibilityLevel() {
    return compatibilityLevel;
  }

  /**
   * The version of SQL Server with which the database is to be made compatible
   * @param compatibilityLevel compatibilityLevel or {@code null} for none
   */
  public SqlServerDatabaseDetails setCompatibilityLevel(java.lang.Integer compatibilityLevel) {
    this.compatibilityLevel = compatibilityLevel;
    return this;
  }

  /**
   * The recovery model of a SQL Server database
   * @return value or {@code null} for none
   */
  public java.lang.String getRecoveryModel() {
    return recoveryModel;
  }

  /**
   * The recovery model of a SQL Server database
   * @param recoveryModel recoveryModel or {@code null} for none
   */
  public SqlServerDatabaseDetails setRecoveryModel(java.lang.String recoveryModel) {
    this.recoveryModel = recoveryModel;
    return this;
  }

  @Override
  public SqlServerDatabaseDetails set(String fieldName, Object value) {
    return (SqlServerDatabaseDetails) super.set(fieldName, value);
  }

  @Override
  public SqlServerDatabaseDetails clone() {
    return (SqlServerDatabaseDetails) super.clone();
  }

}
