/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Gemini configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeminiInstanceConfig extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Whether active query is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean activeQueryEnabled;

  /**
   * Output only. Whether Gemini is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean entitled;

  /**
   * Output only. Whether flag recommender is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean flagRecommenderEnabled;

  /**
   * Output only. Whether vacuum management is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean googleVacuumMgmtEnabled;

  /**
   * Output only. Whether index advisor is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean indexAdvisorEnabled;

  /**
   * Output only. Whether oom session cancel is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean oomSessionCancelEnabled;

  /**
   * Output only. Whether active query is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActiveQueryEnabled() {
    return activeQueryEnabled;
  }

  /**
   * Output only. Whether active query is enabled.
   * @param activeQueryEnabled activeQueryEnabled or {@code null} for none
   */
  public GeminiInstanceConfig setActiveQueryEnabled(java.lang.Boolean activeQueryEnabled) {
    this.activeQueryEnabled = activeQueryEnabled;
    return this;
  }

  /**
   * Output only. Whether Gemini is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEntitled() {
    return entitled;
  }

  /**
   * Output only. Whether Gemini is enabled.
   * @param entitled entitled or {@code null} for none
   */
  public GeminiInstanceConfig setEntitled(java.lang.Boolean entitled) {
    this.entitled = entitled;
    return this;
  }

  /**
   * Output only. Whether flag recommender is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFlagRecommenderEnabled() {
    return flagRecommenderEnabled;
  }

  /**
   * Output only. Whether flag recommender is enabled.
   * @param flagRecommenderEnabled flagRecommenderEnabled or {@code null} for none
   */
  public GeminiInstanceConfig setFlagRecommenderEnabled(java.lang.Boolean flagRecommenderEnabled) {
    this.flagRecommenderEnabled = flagRecommenderEnabled;
    return this;
  }

  /**
   * Output only. Whether vacuum management is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGoogleVacuumMgmtEnabled() {
    return googleVacuumMgmtEnabled;
  }

  /**
   * Output only. Whether vacuum management is enabled.
   * @param googleVacuumMgmtEnabled googleVacuumMgmtEnabled or {@code null} for none
   */
  public GeminiInstanceConfig setGoogleVacuumMgmtEnabled(java.lang.Boolean googleVacuumMgmtEnabled) {
    this.googleVacuumMgmtEnabled = googleVacuumMgmtEnabled;
    return this;
  }

  /**
   * Output only. Whether index advisor is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIndexAdvisorEnabled() {
    return indexAdvisorEnabled;
  }

  /**
   * Output only. Whether index advisor is enabled.
   * @param indexAdvisorEnabled indexAdvisorEnabled or {@code null} for none
   */
  public GeminiInstanceConfig setIndexAdvisorEnabled(java.lang.Boolean indexAdvisorEnabled) {
    this.indexAdvisorEnabled = indexAdvisorEnabled;
    return this;
  }

  /**
   * Output only. Whether oom session cancel is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOomSessionCancelEnabled() {
    return oomSessionCancelEnabled;
  }

  /**
   * Output only. Whether oom session cancel is enabled.
   * @param oomSessionCancelEnabled oomSessionCancelEnabled or {@code null} for none
   */
  public GeminiInstanceConfig setOomSessionCancelEnabled(java.lang.Boolean oomSessionCancelEnabled) {
    this.oomSessionCancelEnabled = oomSessionCancelEnabled;
    return this;
  }

  @Override
  public GeminiInstanceConfig set(String fieldName, Object value) {
    return (GeminiInstanceConfig) super.set(fieldName, value);
  }

  @Override
  public GeminiInstanceConfig clone() {
    return (GeminiInstanceConfig) super.clone();
  }

}
