/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Primary-DR replica pair
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplicationCluster extends com.google.api.client.json.GenericJson {

  /**
   * Output only. read-only field that indicates if the replica is a dr_replica; not set for a
   * primary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean drReplica;

  /**
   * Optional. If the instance is a primary instance, then this field identifies the disaster
   * recovery (DR) replica. A DR replica is an optional configuration for Enterprise Plus edition
   * instances. If the instance is a read replica, then the field is not set. Users can set this
   * field to set a designated DR replica for a primary. Removing this field removes the DR replica.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String failoverDrReplicaName;

  /**
   * Output only. read-only field that indicates if the replica is a dr_replica; not set for a
   * primary.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDrReplica() {
    return drReplica;
  }

  /**
   * Output only. read-only field that indicates if the replica is a dr_replica; not set for a
   * primary.
   * @param drReplica drReplica or {@code null} for none
   */
  public ReplicationCluster setDrReplica(java.lang.Boolean drReplica) {
    this.drReplica = drReplica;
    return this;
  }

  /**
   * Optional. If the instance is a primary instance, then this field identifies the disaster
   * recovery (DR) replica. A DR replica is an optional configuration for Enterprise Plus edition
   * instances. If the instance is a read replica, then the field is not set. Users can set this
   * field to set a designated DR replica for a primary. Removing this field removes the DR replica.
   * @return value or {@code null} for none
   */
  public java.lang.String getFailoverDrReplicaName() {
    return failoverDrReplicaName;
  }

  /**
   * Optional. If the instance is a primary instance, then this field identifies the disaster
   * recovery (DR) replica. A DR replica is an optional configuration for Enterprise Plus edition
   * instances. If the instance is a read replica, then the field is not set. Users can set this
   * field to set a designated DR replica for a primary. Removing this field removes the DR replica.
   * @param failoverDrReplicaName failoverDrReplicaName or {@code null} for none
   */
  public ReplicationCluster setFailoverDrReplicaName(java.lang.String failoverDrReplicaName) {
    this.failoverDrReplicaName = failoverDrReplicaName;
    return this;
  }

  @Override
  public ReplicationCluster set(String fieldName, Object value) {
    return (ReplicationCluster) super.set(fieldName, value);
  }

  @Override
  public ReplicationCluster clone() {
    return (ReplicationCluster) super.clone();
  }

}
