/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * An available database version. It can be a major or a minor version.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AvailableDatabaseVersion extends com.google.api.client.json.GenericJson {

  /**
   * The database version's display name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The version's major version name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String majorVersion;

  /**
   * The database version name. For MySQL 8.0, this string provides the database major and minor
   * version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The database version's display name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The database version's display name.
   * @param displayName displayName or {@code null} for none
   */
  public AvailableDatabaseVersion setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The version's major version name.
   * @return value or {@code null} for none
   */
  public java.lang.String getMajorVersion() {
    return majorVersion;
  }

  /**
   * The version's major version name.
   * @param majorVersion majorVersion or {@code null} for none
   */
  public AvailableDatabaseVersion setMajorVersion(java.lang.String majorVersion) {
    this.majorVersion = majorVersion;
    return this;
  }

  /**
   * The database version name. For MySQL 8.0, this string provides the database major and minor
   * version.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The database version name. For MySQL 8.0, this string provides the database major and minor
   * version.
   * @param name name or {@code null} for none
   */
  public AvailableDatabaseVersion setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public AvailableDatabaseVersion set(String fieldName, Object value) {
    return (AvailableDatabaseVersion) super.set(fieldName, value);
  }

  @Override
  public AvailableDatabaseVersion clone() {
    return (AvailableDatabaseVersion) super.clone();
  }

}
