/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * IP Management configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IpConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * The name of the allocated ip range for the private ip Cloud SQL instance. For example: "google-
   * managed-services-default". If set, the instance ip will be created in the allocated range. The
   * range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the
   * name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?.`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allocatedIpRange;

  /**
   * The list of external networks that are allowed to connect to the instance using the IP. In
   * 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AclEntry> authorizedNetworks;

  static {
    // hack to force ProGuard to consider AclEntry used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AclEntry.class);
  }

  /**
   * Controls connectivity to private IP instances from Google services, such as BigQuery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enablePrivatePathForGoogleCloudServices;

  /**
   * Whether the instance is assigned a public IP address or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ipv4Enabled;

  /**
   * The resource link for the VPC network from which the Cloud SQL instance is accessible for
   * private IP. For example, `/projects/myProject/global/networks/default`. This setting can be
   * updated, but it cannot be removed after it is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateNetwork;

  /**
   * PSC settings for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PscConfig pscConfig;

  /**
   * Use `ssl_mode` instead. Whether SSL/TLS connections over IP are enforced. If set to false, then
   * allow both non-SSL/non-TLS and SSL/TLS connections. For SSL/TLS connections, the client
   * certificate won't be verified. If set to true, then only allow connections encrypted with
   * SSL/TLS and with valid client certificates. If you want to enforce SSL/TLS without enforcing
   * the requirement for valid client certificates, then use the `ssl_mode` flag instead of the
   * legacy `require_ssl` flag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean requireSsl;

  /**
   * Specify what type of CA is used for the server certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serverCaMode;

  /**
   * Specify how SSL/TLS is enforced in database connections. If you must use the `require_ssl` flag
   * for backward compatibility, then only the following value pairs are valid: For PostgreSQL and
   * MySQL: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
   * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
   * `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true` For SQL Server: *
   * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY`
   * and `require_ssl=true` The value of `ssl_mode` has priority over the value of `require_ssl`.
   * For example, for the pair `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`,
   * `ssl_mode=ENCRYPTED_ONLY` means accept only SSL connections, while `require_ssl=false` means
   * accept both non-SSL and SSL connections. In this case, MySQL and PostgreSQL databases respect
   * `ssl_mode` and accepts only SSL connections.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sslMode;

  /**
   * The name of the allocated ip range for the private ip Cloud SQL instance. For example: "google-
   * managed-services-default". If set, the instance ip will be created in the allocated range. The
   * range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the
   * name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?.`
   * @return value or {@code null} for none
   */
  public java.lang.String getAllocatedIpRange() {
    return allocatedIpRange;
  }

  /**
   * The name of the allocated ip range for the private ip Cloud SQL instance. For example: "google-
   * managed-services-default". If set, the instance ip will be created in the allocated range. The
   * range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the
   * name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?.`
   * @param allocatedIpRange allocatedIpRange or {@code null} for none
   */
  public IpConfiguration setAllocatedIpRange(java.lang.String allocatedIpRange) {
    this.allocatedIpRange = allocatedIpRange;
    return this;
  }

  /**
   * The list of external networks that are allowed to connect to the instance using the IP. In
   * 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).
   * @return value or {@code null} for none
   */
  public java.util.List<AclEntry> getAuthorizedNetworks() {
    return authorizedNetworks;
  }

  /**
   * The list of external networks that are allowed to connect to the instance using the IP. In
   * 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).
   * @param authorizedNetworks authorizedNetworks or {@code null} for none
   */
  public IpConfiguration setAuthorizedNetworks(java.util.List<AclEntry> authorizedNetworks) {
    this.authorizedNetworks = authorizedNetworks;
    return this;
  }

  /**
   * Controls connectivity to private IP instances from Google services, such as BigQuery.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnablePrivatePathForGoogleCloudServices() {
    return enablePrivatePathForGoogleCloudServices;
  }

  /**
   * Controls connectivity to private IP instances from Google services, such as BigQuery.
   * @param enablePrivatePathForGoogleCloudServices enablePrivatePathForGoogleCloudServices or {@code null} for none
   */
  public IpConfiguration setEnablePrivatePathForGoogleCloudServices(java.lang.Boolean enablePrivatePathForGoogleCloudServices) {
    this.enablePrivatePathForGoogleCloudServices = enablePrivatePathForGoogleCloudServices;
    return this;
  }

  /**
   * Whether the instance is assigned a public IP address or not.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIpv4Enabled() {
    return ipv4Enabled;
  }

  /**
   * Whether the instance is assigned a public IP address or not.
   * @param ipv4Enabled ipv4Enabled or {@code null} for none
   */
  public IpConfiguration setIpv4Enabled(java.lang.Boolean ipv4Enabled) {
    this.ipv4Enabled = ipv4Enabled;
    return this;
  }

  /**
   * The resource link for the VPC network from which the Cloud SQL instance is accessible for
   * private IP. For example, `/projects/myProject/global/networks/default`. This setting can be
   * updated, but it cannot be removed after it is set.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateNetwork() {
    return privateNetwork;
  }

  /**
   * The resource link for the VPC network from which the Cloud SQL instance is accessible for
   * private IP. For example, `/projects/myProject/global/networks/default`. This setting can be
   * updated, but it cannot be removed after it is set.
   * @param privateNetwork privateNetwork or {@code null} for none
   */
  public IpConfiguration setPrivateNetwork(java.lang.String privateNetwork) {
    this.privateNetwork = privateNetwork;
    return this;
  }

  /**
   * PSC settings for this instance.
   * @return value or {@code null} for none
   */
  public PscConfig getPscConfig() {
    return pscConfig;
  }

  /**
   * PSC settings for this instance.
   * @param pscConfig pscConfig or {@code null} for none
   */
  public IpConfiguration setPscConfig(PscConfig pscConfig) {
    this.pscConfig = pscConfig;
    return this;
  }

  /**
   * Use `ssl_mode` instead. Whether SSL/TLS connections over IP are enforced. If set to false, then
   * allow both non-SSL/non-TLS and SSL/TLS connections. For SSL/TLS connections, the client
   * certificate won't be verified. If set to true, then only allow connections encrypted with
   * SSL/TLS and with valid client certificates. If you want to enforce SSL/TLS without enforcing
   * the requirement for valid client certificates, then use the `ssl_mode` flag instead of the
   * legacy `require_ssl` flag.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRequireSsl() {
    return requireSsl;
  }

  /**
   * Use `ssl_mode` instead. Whether SSL/TLS connections over IP are enforced. If set to false, then
   * allow both non-SSL/non-TLS and SSL/TLS connections. For SSL/TLS connections, the client
   * certificate won't be verified. If set to true, then only allow connections encrypted with
   * SSL/TLS and with valid client certificates. If you want to enforce SSL/TLS without enforcing
   * the requirement for valid client certificates, then use the `ssl_mode` flag instead of the
   * legacy `require_ssl` flag.
   * @param requireSsl requireSsl or {@code null} for none
   */
  public IpConfiguration setRequireSsl(java.lang.Boolean requireSsl) {
    this.requireSsl = requireSsl;
    return this;
  }

  /**
   * Specify what type of CA is used for the server certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getServerCaMode() {
    return serverCaMode;
  }

  /**
   * Specify what type of CA is used for the server certificate.
   * @param serverCaMode serverCaMode or {@code null} for none
   */
  public IpConfiguration setServerCaMode(java.lang.String serverCaMode) {
    this.serverCaMode = serverCaMode;
    return this;
  }

  /**
   * Specify how SSL/TLS is enforced in database connections. If you must use the `require_ssl` flag
   * for backward compatibility, then only the following value pairs are valid: For PostgreSQL and
   * MySQL: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
   * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
   * `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true` For SQL Server: *
   * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY`
   * and `require_ssl=true` The value of `ssl_mode` has priority over the value of `require_ssl`.
   * For example, for the pair `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`,
   * `ssl_mode=ENCRYPTED_ONLY` means accept only SSL connections, while `require_ssl=false` means
   * accept both non-SSL and SSL connections. In this case, MySQL and PostgreSQL databases respect
   * `ssl_mode` and accepts only SSL connections.
   * @return value or {@code null} for none
   */
  public java.lang.String getSslMode() {
    return sslMode;
  }

  /**
   * Specify how SSL/TLS is enforced in database connections. If you must use the `require_ssl` flag
   * for backward compatibility, then only the following value pairs are valid: For PostgreSQL and
   * MySQL: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
   * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
   * `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true` For SQL Server: *
   * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY`
   * and `require_ssl=true` The value of `ssl_mode` has priority over the value of `require_ssl`.
   * For example, for the pair `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`,
   * `ssl_mode=ENCRYPTED_ONLY` means accept only SSL connections, while `require_ssl=false` means
   * accept both non-SSL and SSL connections. In this case, MySQL and PostgreSQL databases respect
   * `ssl_mode` and accepts only SSL connections.
   * @param sslMode sslMode or {@code null} for none
   */
  public IpConfiguration setSslMode(java.lang.String sslMode) {
    this.sslMode = sslMode;
    return this;
  }

  @Override
  public IpConfiguration set(String fieldName, Object value) {
    return (IpConfiguration) super.set(fieldName, value);
  }

  @Override
  public IpConfiguration clone() {
    return (IpConfiguration) super.clone();
  }

}
