/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * The response payload containing a list of the backups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListBackupsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A list of backups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Backup> backups;

  static {
    // hack to force ProGuard to consider Backup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Backup.class);
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * then there aren't subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * If a region isn't unavailable or if an unknown error occurs, then a warning message is
   * returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApiWarning> warnings;

  static {
    // hack to force ProGuard to consider ApiWarning used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApiWarning.class);
  }

  /**
   * A list of backups.
   * @return value or {@code null} for none
   */
  public java.util.List<Backup> getBackups() {
    return backups;
  }

  /**
   * A list of backups.
   * @param backups backups or {@code null} for none
   */
  public ListBackupsResponse setBackups(java.util.List<Backup> backups) {
    this.backups = backups;
    return this;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * then there aren't subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * then there aren't subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListBackupsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * If a region isn't unavailable or if an unknown error occurs, then a warning message is
   * returned.
   * @return value or {@code null} for none
   */
  public java.util.List<ApiWarning> getWarnings() {
    return warnings;
  }

  /**
   * If a region isn't unavailable or if an unknown error occurs, then a warning message is
   * returned.
   * @param warnings warnings or {@code null} for none
   */
  public ListBackupsResponse setWarnings(java.util.List<ApiWarning> warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public ListBackupsResponse set(String fieldName, Object value) {
    return (ListBackupsResponse) super.set(fieldName, value);
  }

  @Override
  public ListBackupsResponse clone() {
    return (ListBackupsResponse) super.clone();
  }

}
