/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Details of a single read pool node of a read pool.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PoolNodeConfig extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The DNS name of the read pool node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dnsName;

  /**
   * Output only. The list of DNS names used by this read pool node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DnsNameMapping> dnsNames;

  static {
    // hack to force ProGuard to consider DnsNameMapping used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DnsNameMapping.class);
  }

  /**
   * Output only. The zone of the read pool node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gceZone;

  /**
   * Output only. Mappings containing IP addresses that can be used to connect to the read pool
   * node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IpMapping> ipAddresses;

  static {
    // hack to force ProGuard to consider IpMapping used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IpMapping.class);
  }

  /**
   * Output only. The name of the read pool node, to be used for retrieving metrics and logs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The current state of the read pool node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. The DNS name of the read pool node.
   * @return value or {@code null} for none
   */
  public java.lang.String getDnsName() {
    return dnsName;
  }

  /**
   * Output only. The DNS name of the read pool node.
   * @param dnsName dnsName or {@code null} for none
   */
  public PoolNodeConfig setDnsName(java.lang.String dnsName) {
    this.dnsName = dnsName;
    return this;
  }

  /**
   * Output only. The list of DNS names used by this read pool node.
   * @return value or {@code null} for none
   */
  public java.util.List<DnsNameMapping> getDnsNames() {
    return dnsNames;
  }

  /**
   * Output only. The list of DNS names used by this read pool node.
   * @param dnsNames dnsNames or {@code null} for none
   */
  public PoolNodeConfig setDnsNames(java.util.List<DnsNameMapping> dnsNames) {
    this.dnsNames = dnsNames;
    return this;
  }

  /**
   * Output only. The zone of the read pool node.
   * @return value or {@code null} for none
   */
  public java.lang.String getGceZone() {
    return gceZone;
  }

  /**
   * Output only. The zone of the read pool node.
   * @param gceZone gceZone or {@code null} for none
   */
  public PoolNodeConfig setGceZone(java.lang.String gceZone) {
    this.gceZone = gceZone;
    return this;
  }

  /**
   * Output only. Mappings containing IP addresses that can be used to connect to the read pool
   * node.
   * @return value or {@code null} for none
   */
  public java.util.List<IpMapping> getIpAddresses() {
    return ipAddresses;
  }

  /**
   * Output only. Mappings containing IP addresses that can be used to connect to the read pool
   * node.
   * @param ipAddresses ipAddresses or {@code null} for none
   */
  public PoolNodeConfig setIpAddresses(java.util.List<IpMapping> ipAddresses) {
    this.ipAddresses = ipAddresses;
    return this;
  }

  /**
   * Output only. The name of the read pool node, to be used for retrieving metrics and logs.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The name of the read pool node, to be used for retrieving metrics and logs.
   * @param name name or {@code null} for none
   */
  public PoolNodeConfig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The current state of the read pool node.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The current state of the read pool node.
   * @param state state or {@code null} for none
   */
  public PoolNodeConfig setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public PoolNodeConfig set(String fieldName, Object value) {
    return (PoolNodeConfig) super.set(fieldName, value);
  }

  @Override
  public PoolNodeConfig clone() {
    return (PoolNodeConfig) super.clone();
  }

}
