/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Settings for an automatically-setup Private Service Connect consumer endpoint that is used to
 * connect to a Cloud SQL instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PscAutoConnectionConfig extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The consumer network of this consumer endpoint. This must be a resource path that
   * includes both the host project and the network name. For example,
   * `projects/project1/global/networks/network1`. The consumer host project of this network might
   * be different from the consumer service project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumerNetwork;

  /**
   * The connection policy status of the consumer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumerNetworkStatus;

  /**
   * Optional. This is the project ID of consumer service project of this consumer endpoint.
   * Optional. This is only applicable if consumer_network is a shared vpc network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumerProject;

  /**
   * The IP address of the consumer endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * The connection status of the consumer endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Optional. The consumer network of this consumer endpoint. This must be a resource path that
   * includes both the host project and the network name. For example,
   * `projects/project1/global/networks/network1`. The consumer host project of this network might
   * be different from the consumer service project.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumerNetwork() {
    return consumerNetwork;
  }

  /**
   * Optional. The consumer network of this consumer endpoint. This must be a resource path that
   * includes both the host project and the network name. For example,
   * `projects/project1/global/networks/network1`. The consumer host project of this network might
   * be different from the consumer service project.
   * @param consumerNetwork consumerNetwork or {@code null} for none
   */
  public PscAutoConnectionConfig setConsumerNetwork(java.lang.String consumerNetwork) {
    this.consumerNetwork = consumerNetwork;
    return this;
  }

  /**
   * The connection policy status of the consumer network.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumerNetworkStatus() {
    return consumerNetworkStatus;
  }

  /**
   * The connection policy status of the consumer network.
   * @param consumerNetworkStatus consumerNetworkStatus or {@code null} for none
   */
  public PscAutoConnectionConfig setConsumerNetworkStatus(java.lang.String consumerNetworkStatus) {
    this.consumerNetworkStatus = consumerNetworkStatus;
    return this;
  }

  /**
   * Optional. This is the project ID of consumer service project of this consumer endpoint.
   * Optional. This is only applicable if consumer_network is a shared vpc network.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumerProject() {
    return consumerProject;
  }

  /**
   * Optional. This is the project ID of consumer service project of this consumer endpoint.
   * Optional. This is only applicable if consumer_network is a shared vpc network.
   * @param consumerProject consumerProject or {@code null} for none
   */
  public PscAutoConnectionConfig setConsumerProject(java.lang.String consumerProject) {
    this.consumerProject = consumerProject;
    return this;
  }

  /**
   * The IP address of the consumer endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * The IP address of the consumer endpoint.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public PscAutoConnectionConfig setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * The connection status of the consumer endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The connection status of the consumer endpoint.
   * @param status status or {@code null} for none
   */
  public PscAutoConnectionConfig setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public PscAutoConnectionConfig set(String fieldName, Object value) {
    return (PscAutoConnectionConfig) super.set(fieldName, value);
  }

  @Override
  public PscAutoConnectionConfig clone() {
    return (PscAutoConnectionConfig) super.clone();
  }

}
