/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Instance rotate server certificate context.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RotateServerCertificateContext extends com.google.api.client.json.GenericJson {

  /**
   * Optional. This is always `sql#rotateServerCertificateContext`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Optional. The fingerprint of the next version to be rotated to. If left unspecified, will be
   * rotated to the most recently added server certificate version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextVersion;

  /**
   * Optional. This is always `sql#rotateServerCertificateContext`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Optional. This is always `sql#rotateServerCertificateContext`.
   * @param kind kind or {@code null} for none
   */
  public RotateServerCertificateContext setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Optional. The fingerprint of the next version to be rotated to. If left unspecified, will be
   * rotated to the most recently added server certificate version.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextVersion() {
    return nextVersion;
  }

  /**
   * Optional. The fingerprint of the next version to be rotated to. If left unspecified, will be
   * rotated to the most recently added server certificate version.
   * @param nextVersion nextVersion or {@code null} for none
   */
  public RotateServerCertificateContext setNextVersion(java.lang.String nextVersion) {
    this.nextVersion = nextVersion;
    return this;
  }

  @Override
  public RotateServerCertificateContext set(String fieldName, Object value) {
    return (RotateServerCertificateContext) super.set(fieldName, value);
  }

  @Override
  public RotateServerCertificateContext clone() {
    return (RotateServerCertificateContext) super.clone();
  }

}
