/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * SQL Server specific audit configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SqlServerAuditConfig extends com.google.api.client.json.GenericJson {

  /**
   * The name of the destination bucket (e.g., gs://mybucket).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * This is always sql#sqlServerAuditConfig
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * How long to keep generated audit files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String retentionInterval;

  /**
   * How often to upload generated audit files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String uploadInterval;

  /**
   * The name of the destination bucket (e.g., gs://mybucket).
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the destination bucket (e.g., gs://mybucket).
   * @param bucket bucket or {@code null} for none
   */
  public SqlServerAuditConfig setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * This is always sql#sqlServerAuditConfig
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always sql#sqlServerAuditConfig
   * @param kind kind or {@code null} for none
   */
  public SqlServerAuditConfig setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * How long to keep generated audit files.
   * @return value or {@code null} for none
   */
  public String getRetentionInterval() {
    return retentionInterval;
  }

  /**
   * How long to keep generated audit files.
   * @param retentionInterval retentionInterval or {@code null} for none
   */
  public SqlServerAuditConfig setRetentionInterval(String retentionInterval) {
    this.retentionInterval = retentionInterval;
    return this;
  }

  /**
   * How often to upload generated audit files.
   * @return value or {@code null} for none
   */
  public String getUploadInterval() {
    return uploadInterval;
  }

  /**
   * How often to upload generated audit files.
   * @param uploadInterval uploadInterval or {@code null} for none
   */
  public SqlServerAuditConfig setUploadInterval(String uploadInterval) {
    this.uploadInterval = uploadInterval;
    return this;
  }

  @Override
  public SqlServerAuditConfig set(String fieldName, Object value) {
    return (SqlServerAuditConfig) super.set(fieldName, value);
  }

  @Override
  public SqlServerAuditConfig clone() {
    return (SqlServerAuditConfig) super.clone();
  }

}
