/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * A backup resource. Next ID: 30
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Backup extends com.google.api.client.json.GenericJson {

  /**
   * Output only. This output contains the following values: start_time: All database writes up to
   * this time are available. end_time: Any database writes after this time aren't available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Interval backupInterval;

  /**
   * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupKind;

  /**
   * Output only. The mapping to backup run resource used for IAM validations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupRun;

  /**
   * Output only. The database version of the instance of at the time this backup was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String databaseVersion;

  /**
   * The description of this backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. Information about why the backup operation fails (for example, when the backup
   * state fails).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OperationError error;

  /**
   * Backup expiration time. A UTC timestamp of when this resource expired.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expiryTime;

  /**
   * The name of the database instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * Optional. Output only. Timestamp in UTC of when the instance associated with this backup is
   * deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String instanceDeletionTime;

  /**
   * Optional. Output only. Instance setting of the source instance that's associated with this
   * backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatabaseInstance instanceSettings;

  /**
   * Output only. This is always `sql#backup`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Output only. This output contains the encryption configuration for a backup and the resource
   * name of the KMS key for disk encryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmsKey;

  /**
   * Output only. This output contains the encryption status for a backup and the version of the KMS
   * key that's used to encrypt the Cloud SQL instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmsKeyVersion;

  /**
   * The storage location of the backups. The location can be multi-regional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxChargeableBytes;

  /**
   * Output only. The resource name of the backup. Format: projects/{project}/backups/{backup}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. This status indicates whether the backup satisfies PZI. The status is reserved for
   * future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean satisfiesPzi;

  /**
   * Output only. This status indicates whether the backup satisfies PZS. The status is reserved for
   * future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean satisfiesPzs;

  /**
   * Output only. The URI of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Output only. The state of this backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. This output contains a backup time zone. If a Cloud SQL for SQL Server instance
   * has a different time zone from the backup's time zone, then the restore to the instance doesn't
   * happen.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Input only. The time-to-live (TTL) interval for this resource (in days). For example:
   * ttlDays:7, means 7 days from the current time. The expiration time can't exceed 365 days from
   * the time that the backup is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long ttlDays;

  /**
   * Output only. The type of this backup. The type can be "AUTOMATED", "ON_DEMAND", or “FINAL”.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. This output contains the following values: start_time: All database writes up to
   * this time are available. end_time: Any database writes after this time aren't available.
   * @return value or {@code null} for none
   */
  public Interval getBackupInterval() {
    return backupInterval;
  }

  /**
   * Output only. This output contains the following values: start_time: All database writes up to
   * this time are available. end_time: Any database writes after this time aren't available.
   * @param backupInterval backupInterval or {@code null} for none
   */
  public Backup setBackupInterval(Interval backupInterval) {
    this.backupInterval = backupInterval;
    return this;
  }

  /**
   * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupKind() {
    return backupKind;
  }

  /**
   * Output only. Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * @param backupKind backupKind or {@code null} for none
   */
  public Backup setBackupKind(java.lang.String backupKind) {
    this.backupKind = backupKind;
    return this;
  }

  /**
   * Output only. The mapping to backup run resource used for IAM validations.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupRun() {
    return backupRun;
  }

  /**
   * Output only. The mapping to backup run resource used for IAM validations.
   * @param backupRun backupRun or {@code null} for none
   */
  public Backup setBackupRun(java.lang.String backupRun) {
    this.backupRun = backupRun;
    return this;
  }

  /**
   * Output only. The database version of the instance of at the time this backup was made.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatabaseVersion() {
    return databaseVersion;
  }

  /**
   * Output only. The database version of the instance of at the time this backup was made.
   * @param databaseVersion databaseVersion or {@code null} for none
   */
  public Backup setDatabaseVersion(java.lang.String databaseVersion) {
    this.databaseVersion = databaseVersion;
    return this;
  }

  /**
   * The description of this backup.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this backup.
   * @param description description or {@code null} for none
   */
  public Backup setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. Information about why the backup operation fails (for example, when the backup
   * state fails).
   * @return value or {@code null} for none
   */
  public OperationError getError() {
    return error;
  }

  /**
   * Output only. Information about why the backup operation fails (for example, when the backup
   * state fails).
   * @param error error or {@code null} for none
   */
  public Backup setError(OperationError error) {
    this.error = error;
    return this;
  }

  /**
   * Backup expiration time. A UTC timestamp of when this resource expired.
   * @return value or {@code null} for none
   */
  public String getExpiryTime() {
    return expiryTime;
  }

  /**
   * Backup expiration time. A UTC timestamp of when this resource expired.
   * @param expiryTime expiryTime or {@code null} for none
   */
  public Backup setExpiryTime(String expiryTime) {
    this.expiryTime = expiryTime;
    return this;
  }

  /**
   * The name of the database instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * The name of the database instance.
   * @param instance instance or {@code null} for none
   */
  public Backup setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * Optional. Output only. Timestamp in UTC of when the instance associated with this backup is
   * deleted.
   * @return value or {@code null} for none
   */
  public String getInstanceDeletionTime() {
    return instanceDeletionTime;
  }

  /**
   * Optional. Output only. Timestamp in UTC of when the instance associated with this backup is
   * deleted.
   * @param instanceDeletionTime instanceDeletionTime or {@code null} for none
   */
  public Backup setInstanceDeletionTime(String instanceDeletionTime) {
    this.instanceDeletionTime = instanceDeletionTime;
    return this;
  }

  /**
   * Optional. Output only. Instance setting of the source instance that's associated with this
   * backup.
   * @return value or {@code null} for none
   */
  public DatabaseInstance getInstanceSettings() {
    return instanceSettings;
  }

  /**
   * Optional. Output only. Instance setting of the source instance that's associated with this
   * backup.
   * @param instanceSettings instanceSettings or {@code null} for none
   */
  public Backup setInstanceSettings(DatabaseInstance instanceSettings) {
    this.instanceSettings = instanceSettings;
    return this;
  }

  /**
   * Output only. This is always `sql#backup`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. This is always `sql#backup`.
   * @param kind kind or {@code null} for none
   */
  public Backup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Output only. This output contains the encryption configuration for a backup and the resource
   * name of the KMS key for disk encryption.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmsKey() {
    return kmsKey;
  }

  /**
   * Output only. This output contains the encryption configuration for a backup and the resource
   * name of the KMS key for disk encryption.
   * @param kmsKey kmsKey or {@code null} for none
   */
  public Backup setKmsKey(java.lang.String kmsKey) {
    this.kmsKey = kmsKey;
    return this;
  }

  /**
   * Output only. This output contains the encryption status for a backup and the version of the KMS
   * key that's used to encrypt the Cloud SQL instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmsKeyVersion() {
    return kmsKeyVersion;
  }

  /**
   * Output only. This output contains the encryption status for a backup and the version of the KMS
   * key that's used to encrypt the Cloud SQL instance.
   * @param kmsKeyVersion kmsKeyVersion or {@code null} for none
   */
  public Backup setKmsKeyVersion(java.lang.String kmsKeyVersion) {
    this.kmsKeyVersion = kmsKeyVersion;
    return this;
  }

  /**
   * The storage location of the backups. The location can be multi-regional.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The storage location of the backups. The location can be multi-regional.
   * @param location location or {@code null} for none
   */
  public Backup setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxChargeableBytes() {
    return maxChargeableBytes;
  }

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * @param maxChargeableBytes maxChargeableBytes or {@code null} for none
   */
  public Backup setMaxChargeableBytes(java.lang.Long maxChargeableBytes) {
    this.maxChargeableBytes = maxChargeableBytes;
    return this;
  }

  /**
   * Output only. The resource name of the backup. Format: projects/{project}/backups/{backup}.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the backup. Format: projects/{project}/backups/{backup}.
   * @param name name or {@code null} for none
   */
  public Backup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. This status indicates whether the backup satisfies PZI. The status is reserved for
   * future use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSatisfiesPzi() {
    return satisfiesPzi;
  }

  /**
   * Output only. This status indicates whether the backup satisfies PZI. The status is reserved for
   * future use.
   * @param satisfiesPzi satisfiesPzi or {@code null} for none
   */
  public Backup setSatisfiesPzi(java.lang.Boolean satisfiesPzi) {
    this.satisfiesPzi = satisfiesPzi;
    return this;
  }

  /**
   * Output only. This status indicates whether the backup satisfies PZS. The status is reserved for
   * future use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSatisfiesPzs() {
    return satisfiesPzs;
  }

  /**
   * Output only. This status indicates whether the backup satisfies PZS. The status is reserved for
   * future use.
   * @param satisfiesPzs satisfiesPzs or {@code null} for none
   */
  public Backup setSatisfiesPzs(java.lang.Boolean satisfiesPzs) {
    this.satisfiesPzs = satisfiesPzs;
    return this;
  }

  /**
   * Output only. The URI of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. The URI of this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Backup setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Output only. The state of this backup.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of this backup.
   * @param state state or {@code null} for none
   */
  public Backup setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. This output contains a backup time zone. If a Cloud SQL for SQL Server instance
   * has a different time zone from the backup's time zone, then the restore to the instance doesn't
   * happen.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Output only. This output contains a backup time zone. If a Cloud SQL for SQL Server instance
   * has a different time zone from the backup's time zone, then the restore to the instance doesn't
   * happen.
   * @param timeZone timeZone or {@code null} for none
   */
  public Backup setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Input only. The time-to-live (TTL) interval for this resource (in days). For example:
   * ttlDays:7, means 7 days from the current time. The expiration time can't exceed 365 days from
   * the time that the backup is created.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTtlDays() {
    return ttlDays;
  }

  /**
   * Input only. The time-to-live (TTL) interval for this resource (in days). For example:
   * ttlDays:7, means 7 days from the current time. The expiration time can't exceed 365 days from
   * the time that the backup is created.
   * @param ttlDays ttlDays or {@code null} for none
   */
  public Backup setTtlDays(java.lang.Long ttlDays) {
    this.ttlDays = ttlDays;
    return this;
  }

  /**
   * Output only. The type of this backup. The type can be "AUTOMATED", "ON_DEMAND", or “FINAL”.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. The type of this backup. The type can be "AUTOMATED", "ON_DEMAND", or “FINAL”.
   * @param type type or {@code null} for none
   */
  public Backup setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Backup set(String fieldName, Object value) {
    return (Backup) super.set(fieldName, value);
  }

  @Override
  public Backup clone() {
    return (Backup) super.clone();
  }

}
