/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * A BackupRun resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackupRun extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupKind;

  /**
   * Output only. The instance database version at the time this backup was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String databaseVersion;

  /**
   * The description of this run, only applicable to on-demand backups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Encryption configuration specific to a backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiskEncryptionConfiguration diskEncryptionConfiguration;

  /**
   * Encryption status specific to a backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiskEncryptionStatus diskEncryptionStatus;

  /**
   * The time the backup operation completed in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * The time the run was enqueued in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String enqueuedTime;

  /**
   * Information about why the backup operation failed. This is only present if the run has the
   * FAILED status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OperationError error;

  /**
   * The identifier for this backup run. Unique only for a specific Cloud SQL instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Name of the database instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * This is always `sql#backupRun`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Location of the backups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxChargeableBytes;

  /**
   * The URI of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The time the backup operation actually started in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The status of this run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Backup time zone to prevent restores to an instance with a different time zone. Now relevant
   * only for SQL Server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or "FINAL". This field defaults
   * to "ON_DEMAND" and is ignored, when specified for insert requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The start time of the backup window during which this the backup was attempted in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String windowStartTime;

  /**
   * Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupKind() {
    return backupKind;
  }

  /**
   * Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
   * @param backupKind backupKind or {@code null} for none
   */
  public BackupRun setBackupKind(java.lang.String backupKind) {
    this.backupKind = backupKind;
    return this;
  }

  /**
   * Output only. The instance database version at the time this backup was made.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatabaseVersion() {
    return databaseVersion;
  }

  /**
   * Output only. The instance database version at the time this backup was made.
   * @param databaseVersion databaseVersion or {@code null} for none
   */
  public BackupRun setDatabaseVersion(java.lang.String databaseVersion) {
    this.databaseVersion = databaseVersion;
    return this;
  }

  /**
   * The description of this run, only applicable to on-demand backups.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this run, only applicable to on-demand backups.
   * @param description description or {@code null} for none
   */
  public BackupRun setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Encryption configuration specific to a backup.
   * @return value or {@code null} for none
   */
  public DiskEncryptionConfiguration getDiskEncryptionConfiguration() {
    return diskEncryptionConfiguration;
  }

  /**
   * Encryption configuration specific to a backup.
   * @param diskEncryptionConfiguration diskEncryptionConfiguration or {@code null} for none
   */
  public BackupRun setDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
    this.diskEncryptionConfiguration = diskEncryptionConfiguration;
    return this;
  }

  /**
   * Encryption status specific to a backup.
   * @return value or {@code null} for none
   */
  public DiskEncryptionStatus getDiskEncryptionStatus() {
    return diskEncryptionStatus;
  }

  /**
   * Encryption status specific to a backup.
   * @param diskEncryptionStatus diskEncryptionStatus or {@code null} for none
   */
  public BackupRun setDiskEncryptionStatus(DiskEncryptionStatus diskEncryptionStatus) {
    this.diskEncryptionStatus = diskEncryptionStatus;
    return this;
  }

  /**
   * The time the backup operation completed in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * The time the backup operation completed in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @param endTime endTime or {@code null} for none
   */
  public BackupRun setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The time the run was enqueued in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @return value or {@code null} for none
   */
  public String getEnqueuedTime() {
    return enqueuedTime;
  }

  /**
   * The time the run was enqueued in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @param enqueuedTime enqueuedTime or {@code null} for none
   */
  public BackupRun setEnqueuedTime(String enqueuedTime) {
    this.enqueuedTime = enqueuedTime;
    return this;
  }

  /**
   * Information about why the backup operation failed. This is only present if the run has the
   * FAILED status.
   * @return value or {@code null} for none
   */
  public OperationError getError() {
    return error;
  }

  /**
   * Information about why the backup operation failed. This is only present if the run has the
   * FAILED status.
   * @param error error or {@code null} for none
   */
  public BackupRun setError(OperationError error) {
    this.error = error;
    return this;
  }

  /**
   * The identifier for this backup run. Unique only for a specific Cloud SQL instance.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * The identifier for this backup run. Unique only for a specific Cloud SQL instance.
   * @param id id or {@code null} for none
   */
  public BackupRun setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Name of the database instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * Name of the database instance.
   * @param instance instance or {@code null} for none
   */
  public BackupRun setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * This is always `sql#backupRun`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always `sql#backupRun`.
   * @param kind kind or {@code null} for none
   */
  public BackupRun setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Location of the backups.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Location of the backups.
   * @param location location or {@code null} for none
   */
  public BackupRun setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxChargeableBytes() {
    return maxChargeableBytes;
  }

  /**
   * Output only. The maximum chargeable bytes for the backup.
   * @param maxChargeableBytes maxChargeableBytes or {@code null} for none
   */
  public BackupRun setMaxChargeableBytes(java.lang.Long maxChargeableBytes) {
    this.maxChargeableBytes = maxChargeableBytes;
    return this;
  }

  /**
   * The URI of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The URI of this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public BackupRun setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The time the backup operation actually started in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The time the backup operation actually started in UTC timezone in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @param startTime startTime or {@code null} for none
   */
  public BackupRun setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The status of this run.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of this run.
   * @param status status or {@code null} for none
   */
  public BackupRun setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Backup time zone to prevent restores to an instance with a different time zone. Now relevant
   * only for SQL Server.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Backup time zone to prevent restores to an instance with a different time zone. Now relevant
   * only for SQL Server.
   * @param timeZone timeZone or {@code null} for none
   */
  public BackupRun setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or "FINAL". This field defaults
   * to "ON_DEMAND" and is ignored, when specified for insert requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or "FINAL". This field defaults
   * to "ON_DEMAND" and is ignored, when specified for insert requests.
   * @param type type or {@code null} for none
   */
  public BackupRun setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The start time of the backup window during which this the backup was attempted in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @return value or {@code null} for none
   */
  public String getWindowStartTime() {
    return windowStartTime;
  }

  /**
   * The start time of the backup window during which this the backup was attempted in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
   * @param windowStartTime windowStartTime or {@code null} for none
   */
  public BackupRun setWindowStartTime(String windowStartTime) {
    this.windowStartTime = windowStartTime;
    return this;
  }

  @Override
  public BackupRun set(String fieldName, Object value) {
    return (BackupRun) super.set(fieldName, value);
  }

  @Override
  public BackupRun clone() {
    return (BackupRun) super.clone();
  }

}
