/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * DNS metadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DnsNameMapping extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The connection type of the DNS name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectionType;

  /**
   * Output only. The scope that the DNS name applies to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dnsScope;

  /**
   * The DNS name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The connection type of the DNS name.
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectionType() {
    return connectionType;
  }

  /**
   * Output only. The connection type of the DNS name.
   * @param connectionType connectionType or {@code null} for none
   */
  public DnsNameMapping setConnectionType(java.lang.String connectionType) {
    this.connectionType = connectionType;
    return this;
  }

  /**
   * Output only. The scope that the DNS name applies to.
   * @return value or {@code null} for none
   */
  public java.lang.String getDnsScope() {
    return dnsScope;
  }

  /**
   * Output only. The scope that the DNS name applies to.
   * @param dnsScope dnsScope or {@code null} for none
   */
  public DnsNameMapping setDnsScope(java.lang.String dnsScope) {
    this.dnsScope = dnsScope;
    return this;
  }

  /**
   * The DNS name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The DNS name.
   * @param name name or {@code null} for none
   */
  public DnsNameMapping setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public DnsNameMapping set(String fieldName, Object value) {
    return (DnsNameMapping) super.set(fieldName, value);
  }

  @Override
  public DnsNameMapping clone() {
    return (DnsNameMapping) super.clone();
  }

}
