/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Instances ListServerCertificatess response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesListServerCertificatesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The `sha1_fingerprint` of the active certificate from `server_certs`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activeVersion;

  /**
   * List of server CA certificates for the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SslCert> caCerts;

  /**
   * This is always `sql#instancesListServerCertificates`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * List of server certificates for the instance, signed by the corresponding CA from the
   * `ca_certs` list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SslCert> serverCerts;

  /**
   * The `sha1_fingerprint` of the active certificate from `server_certs`.
   * @return value or {@code null} for none
   */
  public java.lang.String getActiveVersion() {
    return activeVersion;
  }

  /**
   * The `sha1_fingerprint` of the active certificate from `server_certs`.
   * @param activeVersion activeVersion or {@code null} for none
   */
  public InstancesListServerCertificatesResponse setActiveVersion(java.lang.String activeVersion) {
    this.activeVersion = activeVersion;
    return this;
  }

  /**
   * List of server CA certificates for the instance.
   * @return value or {@code null} for none
   */
  public java.util.List<SslCert> getCaCerts() {
    return caCerts;
  }

  /**
   * List of server CA certificates for the instance.
   * @param caCerts caCerts or {@code null} for none
   */
  public InstancesListServerCertificatesResponse setCaCerts(java.util.List<SslCert> caCerts) {
    this.caCerts = caCerts;
    return this;
  }

  /**
   * This is always `sql#instancesListServerCertificates`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always `sql#instancesListServerCertificates`.
   * @param kind kind or {@code null} for none
   */
  public InstancesListServerCertificatesResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * List of server certificates for the instance, signed by the corresponding CA from the
   * `ca_certs` list.
   * @return value or {@code null} for none
   */
  public java.util.List<SslCert> getServerCerts() {
    return serverCerts;
  }

  /**
   * List of server certificates for the instance, signed by the corresponding CA from the
   * `ca_certs` list.
   * @param serverCerts serverCerts or {@code null} for none
   */
  public InstancesListServerCertificatesResponse setServerCerts(java.util.List<SslCert> serverCerts) {
    this.serverCerts = serverCerts;
    return this;
  }

  @Override
  public InstancesListServerCertificatesResponse set(String fieldName, Object value) {
    return (InstancesListServerCertificatesResponse) super.set(fieldName, value);
  }

  @Override
  public InstancesListServerCertificatesResponse clone() {
    return (InstancesListServerCertificatesResponse) super.clone();
  }

}
