/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Context to perform a point-in-time restore of an instance managed by Google Cloud Backup and
 * Disaster Recovery.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PointInTimeRestoreContext extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The name of the allocated IP range for the internal IP Cloud SQL instance. For
   * example: "google-managed-services-default". If you set this, then Cloud SQL creates the IP
   * address for the cloned instance in the allocated range. This range must comply with [RFC
   * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the name must be 1-63
   * characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for
   * future use. http://go/speckle-subnet-picker-clone
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allocatedIpRange;

  /**
   * The Google Cloud Backup and Disaster Recovery Datasource URI. Format:
   * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasource;

  /**
   * Required. The date and time to which you want to restore the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String pointInTime;

  /**
   * Optional. Point-in-time recovery of a regional instance in the specified zones. If not
   * specified, clone to the same secondary zone as the source instance. This value cannot be the
   * same as the preferred_zone field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String preferredSecondaryZone;

  /**
   * Optional. Point-in-time recovery of an instance to the specified zone. If no zone is specified,
   * then clone to the same primary zone as the source instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String preferredZone;

  /**
   * Optional. The resource link for the VPC network from which the Cloud SQL instance is accessible
   * for private IP. For example, `/projects/myProject/global/networks/default`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateNetwork;

  /**
   * Target instance name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetInstance;

  /**
   * Optional. The name of the allocated IP range for the internal IP Cloud SQL instance. For
   * example: "google-managed-services-default". If you set this, then Cloud SQL creates the IP
   * address for the cloned instance in the allocated range. This range must comply with [RFC
   * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the name must be 1-63
   * characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for
   * future use. http://go/speckle-subnet-picker-clone
   * @return value or {@code null} for none
   */
  public java.lang.String getAllocatedIpRange() {
    return allocatedIpRange;
  }

  /**
   * Optional. The name of the allocated IP range for the internal IP Cloud SQL instance. For
   * example: "google-managed-services-default". If you set this, then Cloud SQL creates the IP
   * address for the cloned instance in the allocated range. This range must comply with [RFC
   * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the name must be 1-63
   * characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for
   * future use. http://go/speckle-subnet-picker-clone
   * @param allocatedIpRange allocatedIpRange or {@code null} for none
   */
  public PointInTimeRestoreContext setAllocatedIpRange(java.lang.String allocatedIpRange) {
    this.allocatedIpRange = allocatedIpRange;
    return this;
  }

  /**
   * The Google Cloud Backup and Disaster Recovery Datasource URI. Format:
   * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasource() {
    return datasource;
  }

  /**
   * The Google Cloud Backup and Disaster Recovery Datasource URI. Format:
   * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
   * @param datasource datasource or {@code null} for none
   */
  public PointInTimeRestoreContext setDatasource(java.lang.String datasource) {
    this.datasource = datasource;
    return this;
  }

  /**
   * Required. The date and time to which you want to restore the instance.
   * @return value or {@code null} for none
   */
  public String getPointInTime() {
    return pointInTime;
  }

  /**
   * Required. The date and time to which you want to restore the instance.
   * @param pointInTime pointInTime or {@code null} for none
   */
  public PointInTimeRestoreContext setPointInTime(String pointInTime) {
    this.pointInTime = pointInTime;
    return this;
  }

  /**
   * Optional. Point-in-time recovery of a regional instance in the specified zones. If not
   * specified, clone to the same secondary zone as the source instance. This value cannot be the
   * same as the preferred_zone field.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreferredSecondaryZone() {
    return preferredSecondaryZone;
  }

  /**
   * Optional. Point-in-time recovery of a regional instance in the specified zones. If not
   * specified, clone to the same secondary zone as the source instance. This value cannot be the
   * same as the preferred_zone field.
   * @param preferredSecondaryZone preferredSecondaryZone or {@code null} for none
   */
  public PointInTimeRestoreContext setPreferredSecondaryZone(java.lang.String preferredSecondaryZone) {
    this.preferredSecondaryZone = preferredSecondaryZone;
    return this;
  }

  /**
   * Optional. Point-in-time recovery of an instance to the specified zone. If no zone is specified,
   * then clone to the same primary zone as the source instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreferredZone() {
    return preferredZone;
  }

  /**
   * Optional. Point-in-time recovery of an instance to the specified zone. If no zone is specified,
   * then clone to the same primary zone as the source instance.
   * @param preferredZone preferredZone or {@code null} for none
   */
  public PointInTimeRestoreContext setPreferredZone(java.lang.String preferredZone) {
    this.preferredZone = preferredZone;
    return this;
  }

  /**
   * Optional. The resource link for the VPC network from which the Cloud SQL instance is accessible
   * for private IP. For example, `/projects/myProject/global/networks/default`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateNetwork() {
    return privateNetwork;
  }

  /**
   * Optional. The resource link for the VPC network from which the Cloud SQL instance is accessible
   * for private IP. For example, `/projects/myProject/global/networks/default`.
   * @param privateNetwork privateNetwork or {@code null} for none
   */
  public PointInTimeRestoreContext setPrivateNetwork(java.lang.String privateNetwork) {
    this.privateNetwork = privateNetwork;
    return this;
  }

  /**
   * Target instance name.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetInstance() {
    return targetInstance;
  }

  /**
   * Target instance name.
   * @param targetInstance targetInstance or {@code null} for none
   */
  public PointInTimeRestoreContext setTargetInstance(java.lang.String targetInstance) {
    this.targetInstance = targetInstance;
    return this;
  }

  @Override
  public PointInTimeRestoreContext set(String fieldName, Object value) {
    return (PointInTimeRestoreContext) super.set(fieldName, value);
  }

  @Override
  public PointInTimeRestoreContext clone() {
    return (PointInTimeRestoreContext) super.clone();
  }

}
