/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.sqladmin;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.sqladmin.SQLAdminRequest;
import com.google.api.services.sqladmin.SQLAdminRequestInitializer;
import com.google.api.services.sqladmin.model.BackupRun;
import com.google.api.services.sqladmin.model.BackupRunsListResponse;
import com.google.api.services.sqladmin.model.Database;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.DatabasesListResponse;
import com.google.api.services.sqladmin.model.FlagsListResponse;
import com.google.api.services.sqladmin.model.InstancesCloneRequest;
import com.google.api.services.sqladmin.model.InstancesExportRequest;
import com.google.api.services.sqladmin.model.InstancesFailoverRequest;
import com.google.api.services.sqladmin.model.InstancesImportRequest;
import com.google.api.services.sqladmin.model.InstancesListResponse;
import com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest;
import com.google.api.services.sqladmin.model.Operation;
import com.google.api.services.sqladmin.model.OperationsListResponse;
import com.google.api.services.sqladmin.model.SslCert;
import com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest;
import com.google.api.services.sqladmin.model.SslCertsInsertRequest;
import com.google.api.services.sqladmin.model.SslCertsInsertResponse;
import com.google.api.services.sqladmin.model.SslCertsListResponse;
import com.google.api.services.sqladmin.model.TiersListResponse;
import com.google.api.services.sqladmin.model.User;
import com.google.api.services.sqladmin.model.UsersListResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLAdmin
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "sql/v1beta4/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/sql/v1beta4/";

    public SQLAdmin(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    SQLAdmin(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BackupRuns backupRuns() {
        return new BackupRuns();
    }

    public Databases databases() {
        return new Databases();
    }

    public Flags flags() {
        return new Flags();
    }

    public Instances instances() {
        return new Instances();
    }

    public Operations operations() {
        return new Operations();
    }

    public SslCerts sslCerts() {
        return new SslCerts();
    }

    public Tiers tiers() {
        return new Tiers();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Cloud SQL Administration API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, SQLAdmin.DEFAULT_ROOT_URL, SQLAdmin.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public SQLAdmin build() {
            return new SQLAdmin(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setSQLAdminRequestInitializer(SQLAdminRequestInitializer sQLAdminRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)sQLAdminRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public Delete delete(String string, String string2, String string3, String string4) throws IOException {
            Delete delete = new Delete(string, string2, string3, string4);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, String string2, User user) throws IOException {
            Insert insert = new Insert(string, string2, user);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, String string2, String string3, String string4, User user) throws IOException {
            Update update = new Update(string, string2, string3, string4, user);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String host;
            @Key
            private String name;

            protected Update(String string, String string2, String string3, String string4, User user) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)user, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.host = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter host must be specified.");
                this.name = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter name must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getHost() {
                return this.host;
            }

            public Update setHost(String string) {
                this.host = string;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Update setName(String string) {
                this.name = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<UsersListResponse> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, UsersListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String string, String string2, User user) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)user, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/users";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String host;
            @Key
            private String name;

            protected Delete(String string, String string2, String string3, String string4) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.host = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter host must be specified.");
                this.name = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter name must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getHost() {
                return this.host;
            }

            public Delete setHost(String string) {
                this.host = string;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String string) {
                this.name = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Tiers {
        public List list(String string) throws IOException {
            List list = new List(string);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<TiersListResponse> {
            private static final String REST_PATH = "projects/{project}/tiers";
            @Key
            private String project;

            protected List(String string) {
                super(SQLAdmin.this, "GET", REST_PATH, null, TiersListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class SslCerts {
        public CreateEphemeral createEphemeral(String string, String string2, SslCertsCreateEphemeralRequest sslCertsCreateEphemeralRequest) throws IOException {
            CreateEphemeral createEphemeral = new CreateEphemeral(string, string2, sslCertsCreateEphemeralRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)createEphemeral);
            return createEphemeral;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, SslCertsInsertRequest sslCertsInsertRequest) throws IOException {
            Insert insert = new Insert(string, string2, sslCertsInsertRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<SslCertsListResponse> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, SslCertsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends SQLAdminRequest<SslCertsInsertResponse> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String string, String string2, SslCertsInsertRequest sslCertsInsertRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)sslCertsInsertRequest, SslCertsInsertResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SQLAdminRequest<SslCert> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String sha1Fingerprint;

            protected Get(String string, String string2, String string3) {
                super(SQLAdmin.this, "GET", REST_PATH, null, SslCert.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.sha1Fingerprint = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sha1Fingerprint must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getSha1Fingerprint() {
                return this.sha1Fingerprint;
            }

            public Get setSha1Fingerprint(String string) {
                this.sha1Fingerprint = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String sha1Fingerprint;

            protected Delete(String string, String string2, String string3) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.sha1Fingerprint = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sha1Fingerprint must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getSha1Fingerprint() {
                return this.sha1Fingerprint;
            }

            public Delete setSha1Fingerprint(String string) {
                this.sha1Fingerprint = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateEphemeral
        extends SQLAdminRequest<SslCert> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/createEphemeral";
            @Key
            private String project;
            @Key
            private String instance;

            protected CreateEphemeral(String string, String string2, SslCertsCreateEphemeralRequest sslCertsCreateEphemeralRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)sslCertsCreateEphemeralRequest, SslCert.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public CreateEphemeral setAlt(String string) {
                return (CreateEphemeral)super.setAlt(string);
            }

            public CreateEphemeral setFields(String string) {
                return (CreateEphemeral)super.setFields(string);
            }

            public CreateEphemeral setKey(String string) {
                return (CreateEphemeral)super.setKey(string);
            }

            public CreateEphemeral setOauthToken(String string) {
                return (CreateEphemeral)super.setOauthToken(string);
            }

            public CreateEphemeral setPrettyPrint(Boolean bl) {
                return (CreateEphemeral)super.setPrettyPrint(bl);
            }

            public CreateEphemeral setQuotaUser(String string) {
                return (CreateEphemeral)super.setQuotaUser(string);
            }

            public CreateEphemeral setUserIp(String string) {
                return (CreateEphemeral)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public CreateEphemeral setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public CreateEphemeral setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public CreateEphemeral set(String string, Object object) {
                return (CreateEphemeral)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<OperationsListResponse> {
            private static final String REST_PATH = "projects/{project}/operations";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, OperationsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String string) {
                this.instance = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/operations/{operation}";
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Instances {
        public Clone clone(String string, String string2, InstancesCloneRequest instancesCloneRequest) throws IOException {
            Clone clone = new Clone(string, string2, instancesCloneRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)clone);
            return clone;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Export export(String string, String string2, InstancesExportRequest instancesExportRequest) throws IOException {
            Export export = new Export(string, string2, instancesExportRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)export);
            return export;
        }

        public Failover failover(String string, String string2, InstancesFailoverRequest instancesFailoverRequest) throws IOException {
            Failover failover = new Failover(string, string2, instancesFailoverRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)failover);
            return failover;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public SQLAdminImport sqladminImport(String string, String string2, InstancesImportRequest instancesImportRequest) throws IOException {
            SQLAdminImport sQLAdminImport = new SQLAdminImport(string, string2, instancesImportRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)sQLAdminImport);
            return sQLAdminImport;
        }

        public Insert insert(String string, DatabaseInstance databaseInstance) throws IOException {
            Insert insert = new Insert(string, databaseInstance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, DatabaseInstance databaseInstance) throws IOException {
            Patch patch = new Patch(string, string2, databaseInstance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public PromoteReplica promoteReplica(String string, String string2) throws IOException {
            PromoteReplica promoteReplica = new PromoteReplica(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)promoteReplica);
            return promoteReplica;
        }

        public ResetSslConfig resetSslConfig(String string, String string2) throws IOException {
            ResetSslConfig resetSslConfig = new ResetSslConfig(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)resetSslConfig);
            return resetSslConfig;
        }

        public Restart restart(String string, String string2) throws IOException {
            Restart restart = new Restart(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)restart);
            return restart;
        }

        public RestoreBackup restoreBackup(String string, String string2, InstancesRestoreBackupRequest instancesRestoreBackupRequest) throws IOException {
            RestoreBackup restoreBackup = new RestoreBackup(string, string2, instancesRestoreBackupRequest);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)restoreBackup);
            return restoreBackup;
        }

        public StartReplica startReplica(String string, String string2) throws IOException {
            StartReplica startReplica = new StartReplica(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)startReplica);
            return startReplica;
        }

        public StopReplica stopReplica(String string, String string2) throws IOException {
            StopReplica stopReplica = new StopReplica(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)stopReplica);
            return stopReplica;
        }

        public Update update(String string, String string2, DatabaseInstance databaseInstance) throws IOException {
            Update update = new Update(string, string2, databaseInstance);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Update(String string, String string2, DatabaseInstance databaseInstance) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)databaseInstance, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class StopReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/stopReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected StopReplica(String string, String string2) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public StopReplica setAlt(String string) {
                return (StopReplica)super.setAlt(string);
            }

            public StopReplica setFields(String string) {
                return (StopReplica)super.setFields(string);
            }

            public StopReplica setKey(String string) {
                return (StopReplica)super.setKey(string);
            }

            public StopReplica setOauthToken(String string) {
                return (StopReplica)super.setOauthToken(string);
            }

            public StopReplica setPrettyPrint(Boolean bl) {
                return (StopReplica)super.setPrettyPrint(bl);
            }

            public StopReplica setQuotaUser(String string) {
                return (StopReplica)super.setQuotaUser(string);
            }

            public StopReplica setUserIp(String string) {
                return (StopReplica)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public StopReplica setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public StopReplica setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public StopReplica set(String string, Object object) {
                return (StopReplica)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class StartReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/startReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected StartReplica(String string, String string2) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public StartReplica setAlt(String string) {
                return (StartReplica)super.setAlt(string);
            }

            public StartReplica setFields(String string) {
                return (StartReplica)super.setFields(string);
            }

            public StartReplica setKey(String string) {
                return (StartReplica)super.setKey(string);
            }

            public StartReplica setOauthToken(String string) {
                return (StartReplica)super.setOauthToken(string);
            }

            public StartReplica setPrettyPrint(Boolean bl) {
                return (StartReplica)super.setPrettyPrint(bl);
            }

            public StartReplica setQuotaUser(String string) {
                return (StartReplica)super.setQuotaUser(string);
            }

            public StartReplica setUserIp(String string) {
                return (StartReplica)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public StartReplica setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public StartReplica setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public StartReplica set(String string, Object object) {
                return (StartReplica)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RestoreBackup
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/restoreBackup";
            @Key
            private String project;
            @Key
            private String instance;

            protected RestoreBackup(String string, String string2, InstancesRestoreBackupRequest instancesRestoreBackupRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)instancesRestoreBackupRequest, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public RestoreBackup setAlt(String string) {
                return (RestoreBackup)super.setAlt(string);
            }

            public RestoreBackup setFields(String string) {
                return (RestoreBackup)super.setFields(string);
            }

            public RestoreBackup setKey(String string) {
                return (RestoreBackup)super.setKey(string);
            }

            public RestoreBackup setOauthToken(String string) {
                return (RestoreBackup)super.setOauthToken(string);
            }

            public RestoreBackup setPrettyPrint(Boolean bl) {
                return (RestoreBackup)super.setPrettyPrint(bl);
            }

            public RestoreBackup setQuotaUser(String string) {
                return (RestoreBackup)super.setQuotaUser(string);
            }

            public RestoreBackup setUserIp(String string) {
                return (RestoreBackup)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RestoreBackup setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public RestoreBackup setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public RestoreBackup set(String string, Object object) {
                return (RestoreBackup)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Restart
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/restart";
            @Key
            private String project;
            @Key
            private String instance;

            protected Restart(String string, String string2) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Restart setAlt(String string) {
                return (Restart)super.setAlt(string);
            }

            public Restart setFields(String string) {
                return (Restart)super.setFields(string);
            }

            public Restart setKey(String string) {
                return (Restart)super.setKey(string);
            }

            public Restart setOauthToken(String string) {
                return (Restart)super.setOauthToken(string);
            }

            public Restart setPrettyPrint(Boolean bl) {
                return (Restart)super.setPrettyPrint(bl);
            }

            public Restart setQuotaUser(String string) {
                return (Restart)super.setQuotaUser(string);
            }

            public Restart setUserIp(String string) {
                return (Restart)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Restart setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Restart setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Restart set(String string, Object object) {
                return (Restart)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetSslConfig
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/resetSslConfig";
            @Key
            private String project;
            @Key
            private String instance;

            protected ResetSslConfig(String string, String string2) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public ResetSslConfig setAlt(String string) {
                return (ResetSslConfig)super.setAlt(string);
            }

            public ResetSslConfig setFields(String string) {
                return (ResetSslConfig)super.setFields(string);
            }

            public ResetSslConfig setKey(String string) {
                return (ResetSslConfig)super.setKey(string);
            }

            public ResetSslConfig setOauthToken(String string) {
                return (ResetSslConfig)super.setOauthToken(string);
            }

            public ResetSslConfig setPrettyPrint(Boolean bl) {
                return (ResetSslConfig)super.setPrettyPrint(bl);
            }

            public ResetSslConfig setQuotaUser(String string) {
                return (ResetSslConfig)super.setQuotaUser(string);
            }

            public ResetSslConfig setUserIp(String string) {
                return (ResetSslConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public ResetSslConfig setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public ResetSslConfig setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public ResetSslConfig set(String string, Object object) {
                return (ResetSslConfig)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PromoteReplica
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/promoteReplica";
            @Key
            private String project;
            @Key
            private String instance;

            protected PromoteReplica(String string, String string2) {
                super(SQLAdmin.this, "POST", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public PromoteReplica setAlt(String string) {
                return (PromoteReplica)super.setAlt(string);
            }

            public PromoteReplica setFields(String string) {
                return (PromoteReplica)super.setFields(string);
            }

            public PromoteReplica setKey(String string) {
                return (PromoteReplica)super.setKey(string);
            }

            public PromoteReplica setOauthToken(String string) {
                return (PromoteReplica)super.setOauthToken(string);
            }

            public PromoteReplica setPrettyPrint(Boolean bl) {
                return (PromoteReplica)super.setPrettyPrint(bl);
            }

            public PromoteReplica setQuotaUser(String string) {
                return (PromoteReplica)super.setQuotaUser(string);
            }

            public PromoteReplica setUserIp(String string) {
                return (PromoteReplica)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public PromoteReplica setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public PromoteReplica setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public PromoteReplica set(String string, Object object) {
                return (PromoteReplica)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Patch(String string, String string2, DatabaseInstance databaseInstance) {
                super(SQLAdmin.this, "PATCH", REST_PATH, (Object)databaseInstance, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Patch setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<InstancesListResponse> {
            private static final String REST_PATH = "projects/{project}/instances";
            @Key
            private String project;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(SQLAdmin.this, "GET", REST_PATH, null, InstancesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances";
            @Key
            private String project;

            protected Insert(String string, DatabaseInstance databaseInstance) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)databaseInstance, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SQLAdminImport
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/import";
            @Key
            private String project;
            @Key
            private String instance;

            protected SQLAdminImport(String string, String string2, InstancesImportRequest instancesImportRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)instancesImportRequest, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public SQLAdminImport setAlt(String string) {
                return (SQLAdminImport)super.setAlt(string);
            }

            public SQLAdminImport setFields(String string) {
                return (SQLAdminImport)super.setFields(string);
            }

            public SQLAdminImport setKey(String string) {
                return (SQLAdminImport)super.setKey(string);
            }

            public SQLAdminImport setOauthToken(String string) {
                return (SQLAdminImport)super.setOauthToken(string);
            }

            public SQLAdminImport setPrettyPrint(Boolean bl) {
                return (SQLAdminImport)super.setPrettyPrint(bl);
            }

            public SQLAdminImport setQuotaUser(String string) {
                return (SQLAdminImport)super.setQuotaUser(string);
            }

            public SQLAdminImport setUserIp(String string) {
                return (SQLAdminImport)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SQLAdminImport setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SQLAdminImport setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public SQLAdminImport set(String string, Object object) {
                return (SQLAdminImport)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SQLAdminRequest<DatabaseInstance> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Get(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, DatabaseInstance.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Failover
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/failover";
            @Key
            private String project;
            @Key
            private String instance;

            protected Failover(String string, String string2, InstancesFailoverRequest instancesFailoverRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)instancesFailoverRequest, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Failover setAlt(String string) {
                return (Failover)super.setAlt(string);
            }

            public Failover setFields(String string) {
                return (Failover)super.setFields(string);
            }

            public Failover setKey(String string) {
                return (Failover)super.setKey(string);
            }

            public Failover setOauthToken(String string) {
                return (Failover)super.setOauthToken(string);
            }

            public Failover setPrettyPrint(Boolean bl) {
                return (Failover)super.setPrettyPrint(bl);
            }

            public Failover setQuotaUser(String string) {
                return (Failover)super.setQuotaUser(string);
            }

            public Failover setUserIp(String string) {
                return (Failover)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Failover setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Failover setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Failover set(String string, Object object) {
                return (Failover)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Export
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/export";
            @Key
            private String project;
            @Key
            private String instance;

            protected Export(String string, String string2, InstancesExportRequest instancesExportRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)instancesExportRequest, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Export setAlt(String string) {
                return (Export)super.setAlt(string);
            }

            public Export setFields(String string) {
                return (Export)super.setFields(string);
            }

            public Export setKey(String string) {
                return (Export)super.setKey(string);
            }

            public Export setOauthToken(String string) {
                return (Export)super.setOauthToken(string);
            }

            public Export setPrettyPrint(Boolean bl) {
                return (Export)super.setPrettyPrint(bl);
            }

            public Export setQuotaUser(String string) {
                return (Export)super.setQuotaUser(string);
            }

            public Export setUserIp(String string) {
                return (Export)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Export setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Export setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Export set(String string, Object object) {
                return (Export)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}";
            @Key
            private String project;
            @Key
            private String instance;

            protected Delete(String string, String string2) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Clone
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/clone";
            @Key
            private String project;
            @Key
            private String instance;

            protected Clone(String string, String string2, InstancesCloneRequest instancesCloneRequest) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)instancesCloneRequest, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Clone setAlt(String string) {
                return (Clone)super.setAlt(string);
            }

            public Clone setFields(String string) {
                return (Clone)super.setFields(string);
            }

            public Clone setKey(String string) {
                return (Clone)super.setKey(string);
            }

            public Clone setOauthToken(String string) {
                return (Clone)super.setOauthToken(string);
            }

            public Clone setPrettyPrint(Boolean bl) {
                return (Clone)super.setPrettyPrint(bl);
            }

            public Clone setQuotaUser(String string) {
                return (Clone)super.setQuotaUser(string);
            }

            public Clone setUserIp(String string) {
                return (Clone)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Clone setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Clone setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Clone set(String string, Object object) {
                return (Clone)super.set(string, object);
            }
        }
    }

    public class Flags {
        public List list() throws IOException {
            List list = new List();
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<FlagsListResponse> {
            private static final String REST_PATH = "flags";

            protected List() {
                super(SQLAdmin.this, "GET", REST_PATH, null, FlagsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Databases {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Database database) throws IOException {
            Insert insert = new Insert(string, string2, database);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Database database) throws IOException {
            Patch patch = new Patch(string, string2, string3, database);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, Database database) throws IOException {
            Update update = new Update(string, string2, string3, database);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Update(String string, String string2, String string3, Database database) {
                super(SQLAdmin.this, "PUT", REST_PATH, (Object)database, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter database must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Update setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Update setDatabase(String string) {
                this.database = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Patch(String string, String string2, String string3, Database database) {
                super(SQLAdmin.this, "PATCH", REST_PATH, (Object)database, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter database must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Patch setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Patch setDatabase(String string) {
                this.database = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<DatabasesListResponse> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases";
            @Key
            private String project;
            @Key
            private String instance;

            protected List(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, DatabasesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String string, String string2, Database database) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)database, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SQLAdminRequest<Database> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Get(String string, String string2, String string3) {
                super(SQLAdmin.this, "GET", REST_PATH, null, Database.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter database must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Get setDatabase(String string) {
                this.database = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/databases/{database}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private String database;

            protected Delete(String string, String string2, String string3) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.database = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter database must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                this.instance = string;
                return this;
            }

            public String getDatabase() {
                return this.database;
            }

            public Delete setDatabase(String string) {
                this.database = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class BackupRuns {
        public Delete delete(String string, String string2, Long l) throws IOException {
            Delete delete = new Delete(string, string2, l);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, Long l) throws IOException {
            Get get = new Get(string, string2, l);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, BackupRun backupRun) throws IOException {
            Insert insert = new Insert(string, string2, backupRun);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            SQLAdmin.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SQLAdminRequest<BackupRunsListResponse> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(SQLAdmin.this, "GET", REST_PATH, null, BackupRunsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public List setInstance(String string) {
                this.instance = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns";
            @Key
            private String project;
            @Key
            private String instance;

            protected Insert(String string, String string2, BackupRun backupRun) {
                super(SQLAdmin.this, "POST", REST_PATH, (Object)backupRun, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Insert setInstance(String string) {
                this.instance = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SQLAdminRequest<BackupRun> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns/{id}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long id;

            protected Get(String string, String string2, Long l) {
                super(SQLAdmin.this, "GET", REST_PATH, null, BackupRun.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.id = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                this.instance = string;
                return this;
            }

            public Long getId() {
                return this.id;
            }

            public Get setId(Long l) {
                this.id = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends SQLAdminRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/instances/{instance}/backupRuns/{id}";
            @Key
            private String project;
            @Key
            private String instance;
            @Key
            private Long id;

            protected Delete(String string, String string2, Long l) {
                super(SQLAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                this.id = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                this.instance = string;
                return this;
            }

            public Long getId() {
                return this.id;
            }

            public Delete setId(Long l) {
                this.id = l;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

