/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-27 at 21:44:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A storage.(buckets|objects).testIamPermissions response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TestIamPermissionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The kind of item this is.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The permissions held by the caller. Permissions are always of the format
   * storage.resource.capability, where resource is one of buckets or objects. The supported
   * permissions are as follows: - storage.buckets.delete — Delete bucket.   - storage.buckets.get —
   * Read bucket metadata.   - storage.buckets.getIamPolicy — Read bucket IAM policy.   -
   * storage.buckets.create — Create bucket.   - storage.buckets.list — List buckets.   -
   * storage.buckets.setIamPolicy — Update bucket IAM policy.   - storage.buckets.update — Update
   * bucket metadata.   - storage.objects.delete — Delete object.   - storage.objects.get — Read
   * object data and metadata.   - storage.objects.getIamPolicy — Read object IAM policy.   -
   * storage.objects.create — Create object.   - storage.objects.list — List objects.   -
   * storage.objects.setIamPolicy — Update object IAM policy.   - storage.objects.update — Update
   * object metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> permissions;

  /**
   * The kind of item this is.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is.
   * @param kind kind or {@code null} for none
   */
  public TestIamPermissionsResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The permissions held by the caller. Permissions are always of the format
   * storage.resource.capability, where resource is one of buckets or objects. The supported
   * permissions are as follows: - storage.buckets.delete — Delete bucket.   - storage.buckets.get —
   * Read bucket metadata.   - storage.buckets.getIamPolicy — Read bucket IAM policy.   -
   * storage.buckets.create — Create bucket.   - storage.buckets.list — List buckets.   -
   * storage.buckets.setIamPolicy — Update bucket IAM policy.   - storage.buckets.update — Update
   * bucket metadata.   - storage.objects.delete — Delete object.   - storage.objects.get — Read
   * object data and metadata.   - storage.objects.getIamPolicy — Read object IAM policy.   -
   * storage.objects.create — Create object.   - storage.objects.list — List objects.   -
   * storage.objects.setIamPolicy — Update object IAM policy.   - storage.objects.update — Update
   * object metadata.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPermissions() {
    return permissions;
  }

  /**
   * The permissions held by the caller. Permissions are always of the format
   * storage.resource.capability, where resource is one of buckets or objects. The supported
   * permissions are as follows: - storage.buckets.delete — Delete bucket.   - storage.buckets.get —
   * Read bucket metadata.   - storage.buckets.getIamPolicy — Read bucket IAM policy.   -
   * storage.buckets.create — Create bucket.   - storage.buckets.list — List buckets.   -
   * storage.buckets.setIamPolicy — Update bucket IAM policy.   - storage.buckets.update — Update
   * bucket metadata.   - storage.objects.delete — Delete object.   - storage.objects.get — Read
   * object data and metadata.   - storage.objects.getIamPolicy — Read object IAM policy.   -
   * storage.objects.create — Create object.   - storage.objects.list — List objects.   -
   * storage.objects.setIamPolicy — Update object IAM policy.   - storage.objects.update — Update
   * object metadata.
   * @param permissions permissions or {@code null} for none
   */
  public TestIamPermissionsResponse setPermissions(java.util.List<java.lang.String> permissions) {
    this.permissions = permissions;
    return this;
  }

  @Override
  public TestIamPermissionsResponse set(String fieldName, Object value) {
    return (TestIamPermissionsResponse) super.set(fieldName, value);
  }

  @Override
  public TestIamPermissionsResponse clone() {
    return (TestIamPermissionsResponse) super.clone();
  }

}
