/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A bucket.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Bucket extends com.google.api.client.json.GenericJson {

  /**
   * Access controls on the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BucketAccessControl> acl;

  /**
   * The bucket's billing configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Billing billing;

  /**
   * The bucket's Cross-Origin Resource Sharing (CORS) configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Cors> cors;

  static {
    // hack to force ProGuard to consider Cors used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Cors.class);
  }

  /**
   * The default value for event-based hold on newly created objects in this bucket. Event-based
   * hold is a way to retain objects indefinitely until an event occurs, signified by the hold's
   * release. After being released, such objects will be subject to bucket-level retention (if any).
   * One sample use case of this flag is for banks to hold loan documents for at least 3 years after
   * loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid
   * in full. In this example, these objects will be held intact for any number of years until the
   * event has occurred (event-based hold on the object is released) and then 3 more years after
   * that. That means retention duration of the objects begins from the moment event-based hold
   * transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten
   * or archived until the hold is removed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean defaultEventBasedHold;

  /**
   * Default access controls to apply to new objects when no ACL is provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ObjectAccessControl> defaultObjectAcl;

  /**
   * Encryption configuration for a bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Encryption encryption;

  /**
   * HTTP 1.1 Entity tag for the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The bucket's IAM configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IamConfiguration iamConfiguration;

  /**
   * The ID of the bucket. For buckets, the id and name properties are the same.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For buckets, this is always storage#bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * User-provided labels, in key/value pairs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The bucket's lifecycle configuration. See lifecycle management for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Lifecycle lifecycle;

  /**
   * The location of the bucket. Object data for objects in the bucket resides in physical storage
   * within this region. Defaults to US. See the developer's guide for the authoritative list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The type of the bucket location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationType;

  /**
   * The bucket's logging configuration, which defines the destination bucket and optional name
   * prefix for the current bucket's logs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Logging logging;

  /**
   * The metadata generation of this bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long metageneration;

  /**
   * The name of the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The owner of the bucket. This is always the project team's owner group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Owner owner;

  /**
   * The project number of the project the bucket belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger projectNumber;

  /**
   * The bucket's retention policy. The retention policy enforces a minimum retention time for all
   * objects contained in the bucket, based on their creation time. Any attempt to overwrite or
   * delete objects younger than the retention period will result in a PERMISSION_DENIED error. An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be removed or shortened in
   * duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked
   * retention policy will result in a PERMISSION_DENIED error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RetentionPolicy retentionPolicy;

  /**
   * The URI of this bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The bucket's default storage class, used whenever no storageClass is specified for a newly-
   * created object. This defines how objects in the bucket are stored and determines the SLA and
   * the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, and
   * DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it
   * will default to STANDARD. For more information, see storage classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageClass;

  /**
   * The creation time of the bucket in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeCreated;

  /**
   * The modification time of the bucket in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * The bucket's versioning configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Versioning versioning;

  /**
   * The bucket's website configuration, controlling how the service behaves when accessing bucket
   * contents as a web site. See the Static Website Examples for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Website website;

  /**
   * Access controls on the bucket.
   * @return value or {@code null} for none
   */
  public java.util.List<BucketAccessControl> getAcl() {
    return acl;
  }

  /**
   * Access controls on the bucket.
   * @param acl acl or {@code null} for none
   */
  public Bucket setAcl(java.util.List<BucketAccessControl> acl) {
    this.acl = acl;
    return this;
  }

  /**
   * The bucket's billing configuration.
   * @return value or {@code null} for none
   */
  public Billing getBilling() {
    return billing;
  }

  /**
   * The bucket's billing configuration.
   * @param billing billing or {@code null} for none
   */
  public Bucket setBilling(Billing billing) {
    this.billing = billing;
    return this;
  }

  /**
   * The bucket's Cross-Origin Resource Sharing (CORS) configuration.
   * @return value or {@code null} for none
   */
  public java.util.List<Cors> getCors() {
    return cors;
  }

  /**
   * The bucket's Cross-Origin Resource Sharing (CORS) configuration.
   * @param cors cors or {@code null} for none
   */
  public Bucket setCors(java.util.List<Cors> cors) {
    this.cors = cors;
    return this;
  }

  /**
   * The default value for event-based hold on newly created objects in this bucket. Event-based
   * hold is a way to retain objects indefinitely until an event occurs, signified by the hold's
   * release. After being released, such objects will be subject to bucket-level retention (if any).
   * One sample use case of this flag is for banks to hold loan documents for at least 3 years after
   * loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid
   * in full. In this example, these objects will be held intact for any number of years until the
   * event has occurred (event-based hold on the object is released) and then 3 more years after
   * that. That means retention duration of the objects begins from the moment event-based hold
   * transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten
   * or archived until the hold is removed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDefaultEventBasedHold() {
    return defaultEventBasedHold;
  }

  /**
   * The default value for event-based hold on newly created objects in this bucket. Event-based
   * hold is a way to retain objects indefinitely until an event occurs, signified by the hold's
   * release. After being released, such objects will be subject to bucket-level retention (if any).
   * One sample use case of this flag is for banks to hold loan documents for at least 3 years after
   * loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid
   * in full. In this example, these objects will be held intact for any number of years until the
   * event has occurred (event-based hold on the object is released) and then 3 more years after
   * that. That means retention duration of the objects begins from the moment event-based hold
   * transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten
   * or archived until the hold is removed.
   * @param defaultEventBasedHold defaultEventBasedHold or {@code null} for none
   */
  public Bucket setDefaultEventBasedHold(java.lang.Boolean defaultEventBasedHold) {
    this.defaultEventBasedHold = defaultEventBasedHold;
    return this;
  }

  /**
   * Default access controls to apply to new objects when no ACL is provided.
   * @return value or {@code null} for none
   */
  public java.util.List<ObjectAccessControl> getDefaultObjectAcl() {
    return defaultObjectAcl;
  }

  /**
   * Default access controls to apply to new objects when no ACL is provided.
   * @param defaultObjectAcl defaultObjectAcl or {@code null} for none
   */
  public Bucket setDefaultObjectAcl(java.util.List<ObjectAccessControl> defaultObjectAcl) {
    this.defaultObjectAcl = defaultObjectAcl;
    return this;
  }

  /**
   * Encryption configuration for a bucket.
   * @return value or {@code null} for none
   */
  public Encryption getEncryption() {
    return encryption;
  }

  /**
   * Encryption configuration for a bucket.
   * @param encryption encryption or {@code null} for none
   */
  public Bucket setEncryption(Encryption encryption) {
    this.encryption = encryption;
    return this;
  }

  /**
   * HTTP 1.1 Entity tag for the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * HTTP 1.1 Entity tag for the bucket.
   * @param etag etag or {@code null} for none
   */
  public Bucket setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The bucket's IAM configuration.
   * @return value or {@code null} for none
   */
  public IamConfiguration getIamConfiguration() {
    return iamConfiguration;
  }

  /**
   * The bucket's IAM configuration.
   * @param iamConfiguration iamConfiguration or {@code null} for none
   */
  public Bucket setIamConfiguration(IamConfiguration iamConfiguration) {
    this.iamConfiguration = iamConfiguration;
    return this;
  }

  /**
   * The ID of the bucket. For buckets, the id and name properties are the same.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the bucket. For buckets, the id and name properties are the same.
   * @param id id or {@code null} for none
   */
  public Bucket setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For buckets, this is always storage#bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For buckets, this is always storage#bucket.
   * @param kind kind or {@code null} for none
   */
  public Bucket setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * User-provided labels, in key/value pairs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * User-provided labels, in key/value pairs.
   * @param labels labels or {@code null} for none
   */
  public Bucket setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The bucket's lifecycle configuration. See lifecycle management for more information.
   * @return value or {@code null} for none
   */
  public Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The bucket's lifecycle configuration. See lifecycle management for more information.
   * @param lifecycle lifecycle or {@code null} for none
   */
  public Bucket setLifecycle(Lifecycle lifecycle) {
    this.lifecycle = lifecycle;
    return this;
  }

  /**
   * The location of the bucket. Object data for objects in the bucket resides in physical storage
   * within this region. Defaults to US. See the developer's guide for the authoritative list.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The location of the bucket. Object data for objects in the bucket resides in physical storage
   * within this region. Defaults to US. See the developer's guide for the authoritative list.
   * @param location location or {@code null} for none
   */
  public Bucket setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The type of the bucket location.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationType() {
    return locationType;
  }

  /**
   * The type of the bucket location.
   * @param locationType locationType or {@code null} for none
   */
  public Bucket setLocationType(java.lang.String locationType) {
    this.locationType = locationType;
    return this;
  }

  /**
   * The bucket's logging configuration, which defines the destination bucket and optional name
   * prefix for the current bucket's logs.
   * @return value or {@code null} for none
   */
  public Logging getLogging() {
    return logging;
  }

  /**
   * The bucket's logging configuration, which defines the destination bucket and optional name
   * prefix for the current bucket's logs.
   * @param logging logging or {@code null} for none
   */
  public Bucket setLogging(Logging logging) {
    this.logging = logging;
    return this;
  }

  /**
   * The metadata generation of this bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMetageneration() {
    return metageneration;
  }

  /**
   * The metadata generation of this bucket.
   * @param metageneration metageneration or {@code null} for none
   */
  public Bucket setMetageneration(java.lang.Long metageneration) {
    this.metageneration = metageneration;
    return this;
  }

  /**
   * The name of the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the bucket.
   * @param name name or {@code null} for none
   */
  public Bucket setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The owner of the bucket. This is always the project team's owner group.
   * @return value or {@code null} for none
   */
  public Owner getOwner() {
    return owner;
  }

  /**
   * The owner of the bucket. This is always the project team's owner group.
   * @param owner owner or {@code null} for none
   */
  public Bucket setOwner(Owner owner) {
    this.owner = owner;
    return this;
  }

  /**
   * The project number of the project the bucket belongs to.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getProjectNumber() {
    return projectNumber;
  }

  /**
   * The project number of the project the bucket belongs to.
   * @param projectNumber projectNumber or {@code null} for none
   */
  public Bucket setProjectNumber(java.math.BigInteger projectNumber) {
    this.projectNumber = projectNumber;
    return this;
  }

  /**
   * The bucket's retention policy. The retention policy enforces a minimum retention time for all
   * objects contained in the bucket, based on their creation time. Any attempt to overwrite or
   * delete objects younger than the retention period will result in a PERMISSION_DENIED error. An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be removed or shortened in
   * duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked
   * retention policy will result in a PERMISSION_DENIED error.
   * @return value or {@code null} for none
   */
  public RetentionPolicy getRetentionPolicy() {
    return retentionPolicy;
  }

  /**
   * The bucket's retention policy. The retention policy enforces a minimum retention time for all
   * objects contained in the bucket, based on their creation time. Any attempt to overwrite or
   * delete objects younger than the retention period will result in a PERMISSION_DENIED error. An
   * unlocked retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be removed or shortened in
   * duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked
   * retention policy will result in a PERMISSION_DENIED error.
   * @param retentionPolicy retentionPolicy or {@code null} for none
   */
  public Bucket setRetentionPolicy(RetentionPolicy retentionPolicy) {
    this.retentionPolicy = retentionPolicy;
    return this;
  }

  /**
   * The URI of this bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The URI of this bucket.
   * @param selfLink selfLink or {@code null} for none
   */
  public Bucket setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The bucket's default storage class, used whenever no storageClass is specified for a newly-
   * created object. This defines how objects in the bucket are stored and determines the SLA and
   * the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, and
   * DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it
   * will default to STANDARD. For more information, see storage classes.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageClass() {
    return storageClass;
  }

  /**
   * The bucket's default storage class, used whenever no storageClass is specified for a newly-
   * created object. This defines how objects in the bucket are stored and determines the SLA and
   * the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, and
   * DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it
   * will default to STANDARD. For more information, see storage classes.
   * @param storageClass storageClass or {@code null} for none
   */
  public Bucket setStorageClass(java.lang.String storageClass) {
    this.storageClass = storageClass;
    return this;
  }

  /**
   * The creation time of the bucket in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeCreated() {
    return timeCreated;
  }

  /**
   * The creation time of the bucket in RFC 3339 format.
   * @param timeCreated timeCreated or {@code null} for none
   */
  public Bucket setTimeCreated(com.google.api.client.util.DateTime timeCreated) {
    this.timeCreated = timeCreated;
    return this;
  }

  /**
   * The modification time of the bucket in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * The modification time of the bucket in RFC 3339 format.
   * @param updated updated or {@code null} for none
   */
  public Bucket setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * The bucket's versioning configuration.
   * @return value or {@code null} for none
   */
  public Versioning getVersioning() {
    return versioning;
  }

  /**
   * The bucket's versioning configuration.
   * @param versioning versioning or {@code null} for none
   */
  public Bucket setVersioning(Versioning versioning) {
    this.versioning = versioning;
    return this;
  }

  /**
   * The bucket's website configuration, controlling how the service behaves when accessing bucket
   * contents as a web site. See the Static Website Examples for more information.
   * @return value or {@code null} for none
   */
  public Website getWebsite() {
    return website;
  }

  /**
   * The bucket's website configuration, controlling how the service behaves when accessing bucket
   * contents as a web site. See the Static Website Examples for more information.
   * @param website website or {@code null} for none
   */
  public Bucket setWebsite(Website website) {
    this.website = website;
    return this;
  }

  @Override
  public Bucket set(String fieldName, Object value) {
    return (Bucket) super.set(fieldName, value);
  }

  @Override
  public Bucket clone() {
    return (Bucket) super.clone();
  }

  /**
   * The bucket's billing configuration.
   */
  public static final class Billing extends com.google.api.client.json.GenericJson {

    /**
     * When set to true, Requester Pays is enabled for this bucket.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean requesterPays;

    /**
     * When set to true, Requester Pays is enabled for this bucket.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getRequesterPays() {
      return requesterPays;
    }

    /**
     * When set to true, Requester Pays is enabled for this bucket.
     * @param requesterPays requesterPays or {@code null} for none
     */
    public Billing setRequesterPays(java.lang.Boolean requesterPays) {
      this.requesterPays = requesterPays;
      return this;
    }

    @Override
    public Billing set(String fieldName, Object value) {
      return (Billing) super.set(fieldName, value);
    }

    @Override
    public Billing clone() {
      return (Billing) super.clone();
    }

  }

  /**
   * Model definition for BucketCors.
   */
  public static final class Cors extends com.google.api.client.json.GenericJson {

    /**
     * The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight
     * responses.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer maxAgeSeconds;

    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc)
     * Note: "*" is permitted in the list of methods, and means "any method".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> method;

    /**
     * The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the
     * list of origins, and means "any Origin".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> origin;

    /**
     * The list of HTTP headers other than the simple response headers to give permission for the
     * user-agent to share across domains.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> responseHeader;

    /**
     * The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight
     * responses.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMaxAgeSeconds() {
      return maxAgeSeconds;
    }

    /**
     * The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight
     * responses.
     * @param maxAgeSeconds maxAgeSeconds or {@code null} for none
     */
    public Cors setMaxAgeSeconds(java.lang.Integer maxAgeSeconds) {
      this.maxAgeSeconds = maxAgeSeconds;
      return this;
    }

    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc)
     * Note: "*" is permitted in the list of methods, and means "any method".
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMethod() {
      return method;
    }

    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc)
     * Note: "*" is permitted in the list of methods, and means "any method".
     * @param method method or {@code null} for none
     */
    public Cors setMethod(java.util.List<java.lang.String> method) {
      this.method = method;
      return this;
    }

    /**
     * The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the
     * list of origins, and means "any Origin".
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getOrigin() {
      return origin;
    }

    /**
     * The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the
     * list of origins, and means "any Origin".
     * @param origin origin or {@code null} for none
     */
    public Cors setOrigin(java.util.List<java.lang.String> origin) {
      this.origin = origin;
      return this;
    }

    /**
     * The list of HTTP headers other than the simple response headers to give permission for the
     * user-agent to share across domains.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getResponseHeader() {
      return responseHeader;
    }

    /**
     * The list of HTTP headers other than the simple response headers to give permission for the
     * user-agent to share across domains.
     * @param responseHeader responseHeader or {@code null} for none
     */
    public Cors setResponseHeader(java.util.List<java.lang.String> responseHeader) {
      this.responseHeader = responseHeader;
      return this;
    }

    @Override
    public Cors set(String fieldName, Object value) {
      return (Cors) super.set(fieldName, value);
    }

    @Override
    public Cors clone() {
      return (Cors) super.clone();
    }

  }

  /**
   * Encryption configuration for a bucket.
   */
  public static final class Encryption extends com.google.api.client.json.GenericJson {

    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no
     * encryption method is specified.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String defaultKmsKeyName;

    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no
     * encryption method is specified.
     * @return value or {@code null} for none
     */
    public java.lang.String getDefaultKmsKeyName() {
      return defaultKmsKeyName;
    }

    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no
     * encryption method is specified.
     * @param defaultKmsKeyName defaultKmsKeyName or {@code null} for none
     */
    public Encryption setDefaultKmsKeyName(java.lang.String defaultKmsKeyName) {
      this.defaultKmsKeyName = defaultKmsKeyName;
      return this;
    }

    @Override
    public Encryption set(String fieldName, Object value) {
      return (Encryption) super.set(fieldName, value);
    }

    @Override
    public Encryption clone() {
      return (Encryption) super.clone();
    }

  }

  /**
   * The bucket's IAM configuration.
   */
  public static final class IamConfiguration extends com.google.api.client.json.GenericJson {

    /**
     * The bucket's Bucket Policy Only configuration.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private BucketPolicyOnly bucketPolicyOnly;

    /**
     * The bucket's Bucket Policy Only configuration.
     * @return value or {@code null} for none
     */
    public BucketPolicyOnly getBucketPolicyOnly() {
      return bucketPolicyOnly;
    }

    /**
     * The bucket's Bucket Policy Only configuration.
     * @param bucketPolicyOnly bucketPolicyOnly or {@code null} for none
     */
    public IamConfiguration setBucketPolicyOnly(BucketPolicyOnly bucketPolicyOnly) {
      this.bucketPolicyOnly = bucketPolicyOnly;
      return this;
    }

    @Override
    public IamConfiguration set(String fieldName, Object value) {
      return (IamConfiguration) super.set(fieldName, value);
    }

    @Override
    public IamConfiguration clone() {
      return (IamConfiguration) super.clone();
    }

    /**
     * The bucket's Bucket Policy Only configuration.
     */
    public static final class BucketPolicyOnly extends com.google.api.client.json.GenericJson {

      /**
       * If set, access checks only use bucket-level IAM policies or above.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean enabled;

      /**
       * The deadline time for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in
       * RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false
       * until the locked time, after which the field is immutable.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime lockedTime;

      /**
       * If set, access checks only use bucket-level IAM policies or above.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getEnabled() {
        return enabled;
      }

      /**
       * If set, access checks only use bucket-level IAM policies or above.
       * @param enabled enabled or {@code null} for none
       */
      public BucketPolicyOnly setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
        return this;
      }

      /**
       * The deadline time for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in
       * RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false
       * until the locked time, after which the field is immutable.
       * @return value or {@code null} for none
       */
      public com.google.api.client.util.DateTime getLockedTime() {
        return lockedTime;
      }

      /**
       * The deadline time for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in
       * RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false
       * until the locked time, after which the field is immutable.
       * @param lockedTime lockedTime or {@code null} for none
       */
      public BucketPolicyOnly setLockedTime(com.google.api.client.util.DateTime lockedTime) {
        this.lockedTime = lockedTime;
        return this;
      }

      @Override
      public BucketPolicyOnly set(String fieldName, Object value) {
        return (BucketPolicyOnly) super.set(fieldName, value);
      }

      @Override
      public BucketPolicyOnly clone() {
        return (BucketPolicyOnly) super.clone();
      }

    }
  }

  /**
   * The bucket's lifecycle configuration. See lifecycle management for more information.
   */
  public static final class Lifecycle extends com.google.api.client.json.GenericJson {

    /**
     * A lifecycle management rule, which is made of an action to take and the condition(s) under
     * which the action will be taken.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Rule> rule;

    static {
      // hack to force ProGuard to consider Rule used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Rule.class);
    }

    /**
     * A lifecycle management rule, which is made of an action to take and the condition(s) under
     * which the action will be taken.
     * @return value or {@code null} for none
     */
    public java.util.List<Rule> getRule() {
      return rule;
    }

    /**
     * A lifecycle management rule, which is made of an action to take and the condition(s) under
     * which the action will be taken.
     * @param rule rule or {@code null} for none
     */
    public Lifecycle setRule(java.util.List<Rule> rule) {
      this.rule = rule;
      return this;
    }

    @Override
    public Lifecycle set(String fieldName, Object value) {
      return (Lifecycle) super.set(fieldName, value);
    }

    @Override
    public Lifecycle clone() {
      return (Lifecycle) super.clone();
    }

    /**
     * Model definition for BucketLifecycleRule.
     */
    public static final class Rule extends com.google.api.client.json.GenericJson {

      /**
       * The action to take.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Action action;

      /**
       * The condition(s) under which the action will be taken.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Condition condition;

      /**
       * The action to take.
       * @return value or {@code null} for none
       */
      public Action getAction() {
        return action;
      }

      /**
       * The action to take.
       * @param action action or {@code null} for none
       */
      public Rule setAction(Action action) {
        this.action = action;
        return this;
      }

      /**
       * The condition(s) under which the action will be taken.
       * @return value or {@code null} for none
       */
      public Condition getCondition() {
        return condition;
      }

      /**
       * The condition(s) under which the action will be taken.
       * @param condition condition or {@code null} for none
       */
      public Rule setCondition(Condition condition) {
        this.condition = condition;
        return this;
      }

      @Override
      public Rule set(String fieldName, Object value) {
        return (Rule) super.set(fieldName, value);
      }

      @Override
      public Rule clone() {
        return (Rule) super.clone();
      }

      /**
       * The action to take.
       */
      public static final class Action extends com.google.api.client.json.GenericJson {

        /**
         * Target storage class. Required iff the type of the action is SetStorageClass.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.String storageClass;

        /**
         * Type of the action. Currently, only Delete and SetStorageClass are supported.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.String type;

        /**
         * Target storage class. Required iff the type of the action is SetStorageClass.
         * @return value or {@code null} for none
         */
        public java.lang.String getStorageClass() {
          return storageClass;
        }

        /**
         * Target storage class. Required iff the type of the action is SetStorageClass.
         * @param storageClass storageClass or {@code null} for none
         */
        public Action setStorageClass(java.lang.String storageClass) {
          this.storageClass = storageClass;
          return this;
        }

        /**
         * Type of the action. Currently, only Delete and SetStorageClass are supported.
         * @return value or {@code null} for none
         */
        public java.lang.String getType() {
          return type;
        }

        /**
         * Type of the action. Currently, only Delete and SetStorageClass are supported.
         * @param type type or {@code null} for none
         */
        public Action setType(java.lang.String type) {
          this.type = type;
          return this;
        }

        @Override
        public Action set(String fieldName, Object value) {
          return (Action) super.set(fieldName, value);
        }

        @Override
        public Action clone() {
          return (Action) super.clone();
        }

      }
      /**
       * The condition(s) under which the action will be taken.
       */
      public static final class Condition extends com.google.api.client.json.GenericJson {

        /**
         * Age of an object (in days). This condition is satisfied when an object reaches the specified
         * age.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer age;

        /**
         * A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition
         * is satisfied when an object is created before midnight of the specified date in UTC.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private com.google.api.client.util.DateTime createdBefore;

        /**
         * Relevant only for versioned objects. If the value is true, this condition matches live objects;
         * if the value is false, it matches archived objects.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean isLive;

        /**
         * A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name
         * of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access"
         * launch stage and is only available to a whitelisted set of users; that means that this feature
         * may be changed in backward-incompatible ways and that it is not guaranteed to be released.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.String matchesPattern;

        /**
         * Objects having any of the storage classes specified by this condition will be matched. Values
         * include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, STANDARD, and
         * DURABLE_REDUCED_AVAILABILITY.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> matchesStorageClass;

        /**
         * Relevant only for versioned objects. If the value is N, this condition is satisfied when there
         * are at least N versions (including the live version) newer than this version of the object.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer numNewerVersions;

        /**
         * Age of an object (in days). This condition is satisfied when an object reaches the specified
         * age.
         * @return value or {@code null} for none
         */
        public java.lang.Integer getAge() {
          return age;
        }

        /**
         * Age of an object (in days). This condition is satisfied when an object reaches the specified
         * age.
         * @param age age or {@code null} for none
         */
        public Condition setAge(java.lang.Integer age) {
          this.age = age;
          return this;
        }

        /**
         * A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition
         * is satisfied when an object is created before midnight of the specified date in UTC.
         * @return value or {@code null} for none
         */
        public com.google.api.client.util.DateTime getCreatedBefore() {
          return createdBefore;
        }

        /**
         * A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition
         * is satisfied when an object is created before midnight of the specified date in UTC.
         * @param createdBefore createdBefore or {@code null} for none
         */
        public Condition setCreatedBefore(com.google.api.client.util.DateTime createdBefore) {
          this.createdBefore = createdBefore;
          return this;
        }

        /**
         * Relevant only for versioned objects. If the value is true, this condition matches live objects;
         * if the value is false, it matches archived objects.
         * @return value or {@code null} for none
         */
        public java.lang.Boolean getIsLive() {
          return isLive;
        }

        /**
         * Relevant only for versioned objects. If the value is true, this condition matches live objects;
         * if the value is false, it matches archived objects.
         * @param isLive isLive or {@code null} for none
         */
        public Condition setIsLive(java.lang.Boolean isLive) {
          this.isLive = isLive;
          return this;
        }

        /**
         * A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name
         * of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access"
         * launch stage and is only available to a whitelisted set of users; that means that this feature
         * may be changed in backward-incompatible ways and that it is not guaranteed to be released.
         * @return value or {@code null} for none
         */
        public java.lang.String getMatchesPattern() {
          return matchesPattern;
        }

        /**
         * A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name
         * of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access"
         * launch stage and is only available to a whitelisted set of users; that means that this feature
         * may be changed in backward-incompatible ways and that it is not guaranteed to be released.
         * @param matchesPattern matchesPattern or {@code null} for none
         */
        public Condition setMatchesPattern(java.lang.String matchesPattern) {
          this.matchesPattern = matchesPattern;
          return this;
        }

        /**
         * Objects having any of the storage classes specified by this condition will be matched. Values
         * include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, STANDARD, and
         * DURABLE_REDUCED_AVAILABILITY.
         * @return value or {@code null} for none
         */
        public java.util.List<java.lang.String> getMatchesStorageClass() {
          return matchesStorageClass;
        }

        /**
         * Objects having any of the storage classes specified by this condition will be matched. Values
         * include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, STANDARD, and
         * DURABLE_REDUCED_AVAILABILITY.
         * @param matchesStorageClass matchesStorageClass or {@code null} for none
         */
        public Condition setMatchesStorageClass(java.util.List<java.lang.String> matchesStorageClass) {
          this.matchesStorageClass = matchesStorageClass;
          return this;
        }

        /**
         * Relevant only for versioned objects. If the value is N, this condition is satisfied when there
         * are at least N versions (including the live version) newer than this version of the object.
         * @return value or {@code null} for none
         */
        public java.lang.Integer getNumNewerVersions() {
          return numNewerVersions;
        }

        /**
         * Relevant only for versioned objects. If the value is N, this condition is satisfied when there
         * are at least N versions (including the live version) newer than this version of the object.
         * @param numNewerVersions numNewerVersions or {@code null} for none
         */
        public Condition setNumNewerVersions(java.lang.Integer numNewerVersions) {
          this.numNewerVersions = numNewerVersions;
          return this;
        }

        @Override
        public Condition set(String fieldName, Object value) {
          return (Condition) super.set(fieldName, value);
        }

        @Override
        public Condition clone() {
          return (Condition) super.clone();
        }

      }
    }
  }

  /**
   * The bucket's logging configuration, which defines the destination bucket and optional name prefix
   * for the current bucket's logs.
   */
  public static final class Logging extends com.google.api.client.json.GenericJson {

    /**
     * The destination bucket where the current bucket's logs should be placed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String logBucket;

    /**
     * A prefix for log object names.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String logObjectPrefix;

    /**
     * The destination bucket where the current bucket's logs should be placed.
     * @return value or {@code null} for none
     */
    public java.lang.String getLogBucket() {
      return logBucket;
    }

    /**
     * The destination bucket where the current bucket's logs should be placed.
     * @param logBucket logBucket or {@code null} for none
     */
    public Logging setLogBucket(java.lang.String logBucket) {
      this.logBucket = logBucket;
      return this;
    }

    /**
     * A prefix for log object names.
     * @return value or {@code null} for none
     */
    public java.lang.String getLogObjectPrefix() {
      return logObjectPrefix;
    }

    /**
     * A prefix for log object names.
     * @param logObjectPrefix logObjectPrefix or {@code null} for none
     */
    public Logging setLogObjectPrefix(java.lang.String logObjectPrefix) {
      this.logObjectPrefix = logObjectPrefix;
      return this;
    }

    @Override
    public Logging set(String fieldName, Object value) {
      return (Logging) super.set(fieldName, value);
    }

    @Override
    public Logging clone() {
      return (Logging) super.clone();
    }

  }

  /**
   * The owner of the bucket. This is always the project team's owner group.
   */
  public static final class Owner extends com.google.api.client.json.GenericJson {

    /**
     * The entity, in the form project-owner-projectId.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String entity;

    /**
     * The ID for the entity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String entityId;

    /**
     * The entity, in the form project-owner-projectId.
     * @return value or {@code null} for none
     */
    public java.lang.String getEntity() {
      return entity;
    }

    /**
     * The entity, in the form project-owner-projectId.
     * @param entity entity or {@code null} for none
     */
    public Owner setEntity(java.lang.String entity) {
      this.entity = entity;
      return this;
    }

    /**
     * The ID for the entity.
     * @return value or {@code null} for none
     */
    public java.lang.String getEntityId() {
      return entityId;
    }

    /**
     * The ID for the entity.
     * @param entityId entityId or {@code null} for none
     */
    public Owner setEntityId(java.lang.String entityId) {
      this.entityId = entityId;
      return this;
    }

    @Override
    public Owner set(String fieldName, Object value) {
      return (Owner) super.set(fieldName, value);
    }

    @Override
    public Owner clone() {
      return (Owner) super.clone();
    }

  }

  /**
   * The bucket's retention policy. The retention policy enforces a minimum retention time for all
   * objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete
   * objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked
   * retention policy can be modified or removed from the bucket via a storage.buckets.update
   * operation. A locked retention policy cannot be removed or shortened in duration for the lifetime
   * of the bucket. Attempting to remove or decrease period of a locked retention policy will result
   * in a PERMISSION_DENIED error.
   */
  public static final class RetentionPolicy extends com.google.api.client.json.GenericJson {

    /**
     * Server-determined value that indicates the time from which policy was enforced and effective.
     * This value is in RFC 3339 format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime effectiveTime;

    /**
     * Once locked, an object retention policy cannot be modified.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean isLocked;

    /**
     * The duration in seconds that objects need to be retained. Retention duration must be greater
     * than zero and less than 100 years. Note that enforcement of retention periods less than a day
     * is not guaranteed. Such periods should only be used for testing purposes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long retentionPeriod;

    /**
     * Server-determined value that indicates the time from which policy was enforced and effective.
     * This value is in RFC 3339 format.
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getEffectiveTime() {
      return effectiveTime;
    }

    /**
     * Server-determined value that indicates the time from which policy was enforced and effective.
     * This value is in RFC 3339 format.
     * @param effectiveTime effectiveTime or {@code null} for none
     */
    public RetentionPolicy setEffectiveTime(com.google.api.client.util.DateTime effectiveTime) {
      this.effectiveTime = effectiveTime;
      return this;
    }

    /**
     * Once locked, an object retention policy cannot be modified.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getIsLocked() {
      return isLocked;
    }

    /**
     * Once locked, an object retention policy cannot be modified.
     * @param isLocked isLocked or {@code null} for none
     */
    public RetentionPolicy setIsLocked(java.lang.Boolean isLocked) {
      this.isLocked = isLocked;
      return this;
    }

    /**
     * The duration in seconds that objects need to be retained. Retention duration must be greater
     * than zero and less than 100 years. Note that enforcement of retention periods less than a day
     * is not guaranteed. Such periods should only be used for testing purposes.
     * @return value or {@code null} for none
     */
    public java.lang.Long getRetentionPeriod() {
      return retentionPeriod;
    }

    /**
     * The duration in seconds that objects need to be retained. Retention duration must be greater
     * than zero and less than 100 years. Note that enforcement of retention periods less than a day
     * is not guaranteed. Such periods should only be used for testing purposes.
     * @param retentionPeriod retentionPeriod or {@code null} for none
     */
    public RetentionPolicy setRetentionPeriod(java.lang.Long retentionPeriod) {
      this.retentionPeriod = retentionPeriod;
      return this;
    }

    @Override
    public RetentionPolicy set(String fieldName, Object value) {
      return (RetentionPolicy) super.set(fieldName, value);
    }

    @Override
    public RetentionPolicy clone() {
      return (RetentionPolicy) super.clone();
    }

  }

  /**
   * The bucket's versioning configuration.
   */
  public static final class Versioning extends com.google.api.client.json.GenericJson {

    /**
     * While set to true, versioning is fully enabled for this bucket.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean enabled;

    /**
     * While set to true, versioning is fully enabled for this bucket.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getEnabled() {
      return enabled;
    }

    /**
     * While set to true, versioning is fully enabled for this bucket.
     * @param enabled enabled or {@code null} for none
     */
    public Versioning setEnabled(java.lang.Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    @Override
    public Versioning set(String fieldName, Object value) {
      return (Versioning) super.set(fieldName, value);
    }

    @Override
    public Versioning clone() {
      return (Versioning) super.clone();
    }

  }

  /**
   * The bucket's website configuration, controlling how the service behaves when accessing bucket
   * contents as a web site. See the Static Website Examples for more information.
   */
  public static final class Website extends com.google.api.client.json.GenericJson {

    /**
     * If the requested object path is missing, the service will ensure the path has a trailing '/',
     * append this suffix, and attempt to retrieve the resulting object. This allows the creation of
     * index.html objects to represent directory pages.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String mainPageSuffix;

    /**
     * If the requested object path is missing, and any mainPageSuffix object is missing, if
     * applicable, the service will return the named object from this bucket as the content for a 404
     * Not Found result.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String notFoundPage;

    /**
     * If the requested object path is missing, the service will ensure the path has a trailing '/',
     * append this suffix, and attempt to retrieve the resulting object. This allows the creation of
     * index.html objects to represent directory pages.
     * @return value or {@code null} for none
     */
    public java.lang.String getMainPageSuffix() {
      return mainPageSuffix;
    }

    /**
     * If the requested object path is missing, the service will ensure the path has a trailing '/',
     * append this suffix, and attempt to retrieve the resulting object. This allows the creation of
     * index.html objects to represent directory pages.
     * @param mainPageSuffix mainPageSuffix or {@code null} for none
     */
    public Website setMainPageSuffix(java.lang.String mainPageSuffix) {
      this.mainPageSuffix = mainPageSuffix;
      return this;
    }

    /**
     * If the requested object path is missing, and any mainPageSuffix object is missing, if
     * applicable, the service will return the named object from this bucket as the content for a 404
     * Not Found result.
     * @return value or {@code null} for none
     */
    public java.lang.String getNotFoundPage() {
      return notFoundPage;
    }

    /**
     * If the requested object path is missing, and any mainPageSuffix object is missing, if
     * applicable, the service will return the named object from this bucket as the content for a 404
     * Not Found result.
     * @param notFoundPage notFoundPage or {@code null} for none
     */
    public Website setNotFoundPage(java.lang.String notFoundPage) {
      this.notFoundPage = notFoundPage;
      return this;
    }

    @Override
    public Website set(String fieldName, Object value) {
      return (Website) super.set(fieldName, value);
    }

    @Override
    public Website clone() {
      return (Website) super.clone();
    }

  }
}
