/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * An Anywhere Cache instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AnywhereCache extends com.google.api.client.json.GenericJson {

  /**
   * The cache-level entry admission policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String admissionPolicy;

  /**
   * The ID of the Anywhere cache instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String anywhereCacheId;

  /**
   * The name of the bucket containing this cache instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * The creation time of the cache instance in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createTime;

  /**
   * The ID of the resource, including the project number, bucket name and anywhere cache ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For Anywhere Cache, this is always storage#anywhereCache.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * True if the cache instance has an active Update long-running operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pendingUpdate;

  /**
   * The link to this cache instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The current state of the cache instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The TTL of all cache entries in whole seconds. e.g., "7200s".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * The modification time of the cache instance metadata in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updateTime;

  /**
   * The zone in which the cache instance is running. For example, us-central1-a.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * The cache-level entry admission policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdmissionPolicy() {
    return admissionPolicy;
  }

  /**
   * The cache-level entry admission policy.
   * @param admissionPolicy admissionPolicy or {@code null} for none
   */
  public AnywhereCache setAdmissionPolicy(java.lang.String admissionPolicy) {
    this.admissionPolicy = admissionPolicy;
    return this;
  }

  /**
   * The ID of the Anywhere cache instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getAnywhereCacheId() {
    return anywhereCacheId;
  }

  /**
   * The ID of the Anywhere cache instance.
   * @param anywhereCacheId anywhereCacheId or {@code null} for none
   */
  public AnywhereCache setAnywhereCacheId(java.lang.String anywhereCacheId) {
    this.anywhereCacheId = anywhereCacheId;
    return this;
  }

  /**
   * The name of the bucket containing this cache instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket containing this cache instance.
   * @param bucket bucket or {@code null} for none
   */
  public AnywhereCache setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The creation time of the cache instance in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreateTime() {
    return createTime;
  }

  /**
   * The creation time of the cache instance in RFC 3339 format.
   * @param createTime createTime or {@code null} for none
   */
  public AnywhereCache setCreateTime(com.google.api.client.util.DateTime createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The ID of the resource, including the project number, bucket name and anywhere cache ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the resource, including the project number, bucket name and anywhere cache ID.
   * @param id id or {@code null} for none
   */
  public AnywhereCache setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For Anywhere Cache, this is always storage#anywhereCache.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For Anywhere Cache, this is always storage#anywhereCache.
   * @param kind kind or {@code null} for none
   */
  public AnywhereCache setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * True if the cache instance has an active Update long-running operation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPendingUpdate() {
    return pendingUpdate;
  }

  /**
   * True if the cache instance has an active Update long-running operation.
   * @param pendingUpdate pendingUpdate or {@code null} for none
   */
  public AnywhereCache setPendingUpdate(java.lang.Boolean pendingUpdate) {
    this.pendingUpdate = pendingUpdate;
    return this;
  }

  /**
   * The link to this cache instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this cache instance.
   * @param selfLink selfLink or {@code null} for none
   */
  public AnywhereCache setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The current state of the cache instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The current state of the cache instance.
   * @param state state or {@code null} for none
   */
  public AnywhereCache setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * The TTL of all cache entries in whole seconds. e.g., "7200s".
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * The TTL of all cache entries in whole seconds. e.g., "7200s".
   * @param ttl ttl or {@code null} for none
   */
  public AnywhereCache setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  /**
   * The modification time of the cache instance metadata in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdateTime() {
    return updateTime;
  }

  /**
   * The modification time of the cache instance metadata in RFC 3339 format.
   * @param updateTime updateTime or {@code null} for none
   */
  public AnywhereCache setUpdateTime(com.google.api.client.util.DateTime updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * The zone in which the cache instance is running. For example, us-central1-a.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * The zone in which the cache instance is running. For example, us-central1-a.
   * @param zone zone or {@code null} for none
   */
  public AnywhereCache setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public AnywhereCache set(String fieldName, Object value) {
    return (AnywhereCache) super.set(fieldName, value);
  }

  @Override
  public AnywhereCache clone() {
    return (AnywhereCache) super.clone();
  }

}
