/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storagetransfer;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storagetransfer.StoragetransferRequest;
import com.google.api.services.storagetransfer.StoragetransferRequestInitializer;
import com.google.api.services.storagetransfer.model.Empty;
import com.google.api.services.storagetransfer.model.GoogleServiceAccount;
import com.google.api.services.storagetransfer.model.ListOperationsResponse;
import com.google.api.services.storagetransfer.model.ListTransferJobsResponse;
import com.google.api.services.storagetransfer.model.Operation;
import com.google.api.services.storagetransfer.model.PauseTransferOperationRequest;
import com.google.api.services.storagetransfer.model.ResumeTransferOperationRequest;
import com.google.api.services.storagetransfer.model.TransferJob;
import com.google.api.services.storagetransfer.model.UpdateTransferJobRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storagetransfer
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://storagetransfer.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://storagetransfer.googleapis.com/";

    public Storagetransfer(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Storagetransfer(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public GoogleServiceAccounts googleServiceAccounts() {
        return new GoogleServiceAccounts();
    }

    public TransferJobs transferJobs() {
        return new TransferJobs();
    }

    public TransferOperations transferOperations() {
        return new TransferOperations();
    }

    public V1 v1() {
        return new V1();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Google Storage Transfer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://storagetransfer.googleapis.com/", Storagetransfer.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Storagetransfer build() {
            return new Storagetransfer(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setStoragetransferRequestInitializer(StoragetransferRequestInitializer storagetransferRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storagetransferRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class V1 {
        public GetGoogleServiceAccount getGoogleServiceAccount() throws IOException {
            GetGoogleServiceAccount getGoogleServiceAccount = new GetGoogleServiceAccount();
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)getGoogleServiceAccount);
            return getGoogleServiceAccount;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetGoogleServiceAccount
        extends StoragetransferRequest<GoogleServiceAccount> {
            private static final String REST_PATH = "v1:getGoogleServiceAccount";
            @Key
            private String projectId;

            protected GetGoogleServiceAccount() {
                super(Storagetransfer.this, "GET", REST_PATH, null, GoogleServiceAccount.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetGoogleServiceAccount set$Xgafv(String string) {
                return (GetGoogleServiceAccount)super.set$Xgafv(string);
            }

            public GetGoogleServiceAccount setAccessToken(String string) {
                return (GetGoogleServiceAccount)super.setAccessToken(string);
            }

            public GetGoogleServiceAccount setAlt(String string) {
                return (GetGoogleServiceAccount)super.setAlt(string);
            }

            public GetGoogleServiceAccount setBearerToken(String string) {
                return (GetGoogleServiceAccount)super.setBearerToken(string);
            }

            public GetGoogleServiceAccount setCallback(String string) {
                return (GetGoogleServiceAccount)super.setCallback(string);
            }

            public GetGoogleServiceAccount setFields(String string) {
                return (GetGoogleServiceAccount)super.setFields(string);
            }

            public GetGoogleServiceAccount setKey(String string) {
                return (GetGoogleServiceAccount)super.setKey(string);
            }

            public GetGoogleServiceAccount setOauthToken(String string) {
                return (GetGoogleServiceAccount)super.setOauthToken(string);
            }

            public GetGoogleServiceAccount setPp(Boolean bl) {
                return (GetGoogleServiceAccount)super.setPp(bl);
            }

            public GetGoogleServiceAccount setPrettyPrint(Boolean bl) {
                return (GetGoogleServiceAccount)super.setPrettyPrint(bl);
            }

            public GetGoogleServiceAccount setQuotaUser(String string) {
                return (GetGoogleServiceAccount)super.setQuotaUser(string);
            }

            public GetGoogleServiceAccount setUploadType(String string) {
                return (GetGoogleServiceAccount)super.setUploadType(string);
            }

            public GetGoogleServiceAccount setUploadProtocol(String string) {
                return (GetGoogleServiceAccount)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetGoogleServiceAccount setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public GetGoogleServiceAccount set(String string, Object object) {
                return (GetGoogleServiceAccount)super.set(string, object);
            }
        }
    }

    public class TransferOperations {
        public Cancel cancel(String string) throws IOException {
            Cancel cancel = new Cancel(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Pause pause(String string, PauseTransferOperationRequest pauseTransferOperationRequest) throws IOException {
            Pause pause = new Pause(string, pauseTransferOperationRequest);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)pause);
            return pause;
        }

        public Resume resume(String string, ResumeTransferOperationRequest resumeTransferOperationRequest) throws IOException {
            Resume resume = new Resume(string, resumeTransferOperationRequest);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)resume);
            return resume;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Resume
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:resume";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Resume(String string, ResumeTransferOperationRequest resumeTransferOperationRequest) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)resumeTransferOperationRequest, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Resume set$Xgafv(String string) {
                return (Resume)super.set$Xgafv(string);
            }

            public Resume setAccessToken(String string) {
                return (Resume)super.setAccessToken(string);
            }

            public Resume setAlt(String string) {
                return (Resume)super.setAlt(string);
            }

            public Resume setBearerToken(String string) {
                return (Resume)super.setBearerToken(string);
            }

            public Resume setCallback(String string) {
                return (Resume)super.setCallback(string);
            }

            public Resume setFields(String string) {
                return (Resume)super.setFields(string);
            }

            public Resume setKey(String string) {
                return (Resume)super.setKey(string);
            }

            public Resume setOauthToken(String string) {
                return (Resume)super.setOauthToken(string);
            }

            public Resume setPp(Boolean bl) {
                return (Resume)super.setPp(bl);
            }

            public Resume setPrettyPrint(Boolean bl) {
                return (Resume)super.setPrettyPrint(bl);
            }

            public Resume setQuotaUser(String string) {
                return (Resume)super.setQuotaUser(string);
            }

            public Resume setUploadType(String string) {
                return (Resume)super.setUploadType(string);
            }

            public Resume setUploadProtocol(String string) {
                return (Resume)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Resume setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Resume set(String string, Object object) {
                return (Resume)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Pause
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:pause";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Pause(String string, PauseTransferOperationRequest pauseTransferOperationRequest) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)pauseTransferOperationRequest, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Pause set$Xgafv(String string) {
                return (Pause)super.set$Xgafv(string);
            }

            public Pause setAccessToken(String string) {
                return (Pause)super.setAccessToken(string);
            }

            public Pause setAlt(String string) {
                return (Pause)super.setAlt(string);
            }

            public Pause setBearerToken(String string) {
                return (Pause)super.setBearerToken(string);
            }

            public Pause setCallback(String string) {
                return (Pause)super.setCallback(string);
            }

            public Pause setFields(String string) {
                return (Pause)super.setFields(string);
            }

            public Pause setKey(String string) {
                return (Pause)super.setKey(string);
            }

            public Pause setOauthToken(String string) {
                return (Pause)super.setOauthToken(string);
            }

            public Pause setPp(Boolean bl) {
                return (Pause)super.setPp(bl);
            }

            public Pause setPrettyPrint(Boolean bl) {
                return (Pause)super.setPrettyPrint(bl);
            }

            public Pause setQuotaUser(String string) {
                return (Pause)super.setQuotaUser(string);
            }

            public Pause setUploadType(String string) {
                return (Pause)super.setUploadType(string);
            }

            public Pause setUploadProtocol(String string) {
                return (Pause)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Pause setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Pause set(String string, Object object) {
                return (Pause)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StoragetransferRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List(String string) {
                super(Storagetransfer.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations$");
                }
                this.name = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StoragetransferRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(Storagetransfer.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String string) {
                super(Storagetransfer.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends StoragetransferRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String string) {
                super(Storagetransfer.this, "POST", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^transferOperations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
            }

            public Cancel set$Xgafv(String string) {
                return (Cancel)super.set$Xgafv(string);
            }

            public Cancel setAccessToken(String string) {
                return (Cancel)super.setAccessToken(string);
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setBearerToken(String string) {
                return (Cancel)super.setBearerToken(string);
            }

            public Cancel setCallback(String string) {
                return (Cancel)super.setCallback(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPp(Boolean bl) {
                return (Cancel)super.setPp(bl);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUploadType(String string) {
                return (Cancel)super.setUploadType(string);
            }

            public Cancel setUploadProtocol(String string) {
                return (Cancel)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^transferOperations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }

    public class TransferJobs {
        public Create create(TransferJob transferJob) throws IOException {
            Create create = new Create(transferJob);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, UpdateTransferJobRequest updateTransferJobRequest) throws IOException {
            Patch patch = new Patch(string, updateTransferJobRequest);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/{+jobName}";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;

            protected Patch(String string, UpdateTransferJobRequest updateTransferJobRequest) {
                super(Storagetransfer.this, "PATCH", REST_PATH, (Object)updateTransferJobRequest, TransferJob.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
            }

            public Patch set$Xgafv(String string) {
                return (Patch)super.set$Xgafv(string);
            }

            public Patch setAccessToken(String string) {
                return (Patch)super.setAccessToken(string);
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setBearerToken(String string) {
                return (Patch)super.setBearerToken(string);
            }

            public Patch setCallback(String string) {
                return (Patch)super.setCallback(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPp(Boolean bl) {
                return (Patch)super.setPp(bl);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUploadType(String string) {
                return (Patch)super.setUploadType(string);
            }

            public Patch setUploadProtocol(String string) {
                return (Patch)super.setUploadProtocol(string);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Patch setJobName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StoragetransferRequest<ListTransferJobsResponse> {
            private static final String REST_PATH = "v1/transferJobs";
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Storagetransfer.this, "GET", REST_PATH, null, ListTransferJobsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/{+jobName}";
            private final Pattern JOB_NAME_PATTERN;
            @Key
            private String jobName;
            @Key
            private String projectId;

            protected Get(String string) {
                super(Storagetransfer.this, "GET", REST_PATH, null, TransferJob.class);
                this.JOB_NAME_PATTERN = Pattern.compile("^transferJobs/.*$");
                this.jobName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter jobName must be specified.");
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getJobName() {
                return this.jobName;
            }

            public Get setJobName(String string) {
                if (!Storagetransfer.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.JOB_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter jobName must conform to the pattern ^transferJobs/.*$");
                }
                this.jobName = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends StoragetransferRequest<TransferJob> {
            private static final String REST_PATH = "v1/transferJobs";

            protected Create(TransferJob transferJob) {
                super(Storagetransfer.this, "POST", REST_PATH, (Object)transferJob, TransferJob.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class GoogleServiceAccounts {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Storagetransfer.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StoragetransferRequest<GoogleServiceAccount> {
            private static final String REST_PATH = "v1/googleServiceAccounts/{projectId}";
            @Key
            private String projectId;

            protected Get(String string) {
                super(Storagetransfer.this, "GET", REST_PATH, null, GoogleServiceAccount.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

