/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1;

/**
 * Service definition for Storagetransfer (v1).
 *
 * <p>
 * Transfers data from external data sources to a Google Cloud Storage bucket or between Google Cloud Storage buckets. 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/storage-transfer/docs" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link StoragetransferRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Storagetransfer extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Storage Transfer API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://storagetransfer.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://storagetransfer.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Storagetransfer(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Storagetransfer(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the GoogleServiceAccounts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storagetransfer storagetransfer = new Storagetransfer(...);}
   *   {@code Storagetransfer.GoogleServiceAccounts.List request = storagetransfer.googleServiceAccounts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GoogleServiceAccounts googleServiceAccounts() {
    return new GoogleServiceAccounts();
  }

  /**
   * The "googleServiceAccounts" collection of methods.
   */
  public class GoogleServiceAccounts {

    /**
     * Returns the Google service account that is used by Storage Transfer Service to access buckets in
     * the project where transfers run or in other projects. Each Google service account is associated
     * with one Google Cloud project. Users should add this service account to the Google Cloud Storage
     * bucket ACLs to grant access to Storage Transfer Service. This service account is created and
     * owned by Storage Transfer Service and can only be used by Storage Transfer Service.
     *
     * Create a request for the method "googleServiceAccounts.get".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. The ID of the Google Cloud project that the Google service account is associated with.
     * @return the request
     */
    public Get get(java.lang.String projectId) throws java.io.IOException {
      Get result = new Get(projectId);
      initialize(result);
      return result;
    }

    public class Get extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.GoogleServiceAccount> {

      private static final String REST_PATH = "v1/googleServiceAccounts/{projectId}";

      /**
       * Returns the Google service account that is used by Storage Transfer Service to access buckets
       * in the project where transfers run or in other projects. Each Google service account is
       * associated with one Google Cloud project. Users should add this service account to the Google
       * Cloud Storage bucket ACLs to grant access to Storage Transfer Service. This service account is
       * created and owned by Storage Transfer Service and can only be used by Storage Transfer Service.
       *
       * Create a request for the method "googleServiceAccounts.get".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. The ID of the Google Cloud project that the Google service account is associated with.
       * @since 1.13
       */
      protected Get(java.lang.String projectId) {
        super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.GoogleServiceAccount.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The ID of the Google Cloud project that the Google service account is associated
       * with.
       */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. The ID of the Google Cloud project that the Google service account is associated with.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /**
       * Required. The ID of the Google Cloud project that the Google service account is associated
       * with.
       */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storagetransfer storagetransfer = new Storagetransfer(...);}
   *   {@code Storagetransfer.Projects.List request = storagetransfer.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the AgentPools collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Storagetransfer storagetransfer = new Storagetransfer(...);}
     *   {@code Storagetransfer.AgentPools.List request = storagetransfer.agentPools().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AgentPools agentPools() {
      return new AgentPools();
    }

    /**
     * The "agentPools" collection of methods.
     */
    public class AgentPools {

      /**
       * Creates an agent pool resource.
       *
       * Create a request for the method "agentPools.create".
       *
       * This request holds the parameters needed by the storagetransfer server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId Required. The ID of the Google Cloud project that owns the agent pool.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.AgentPool}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.storagetransfer.v1.model.AgentPool content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.AgentPool> {

        private static final String REST_PATH = "v1/projects/{+projectId}/agentPools";

        private final java.util.regex.Pattern PROJECT_ID_PATTERN =
            java.util.regex.Pattern.compile("^[^/]+$");

        /**
         * Creates an agent pool resource.
         *
         * Create a request for the method "agentPools.create".
         *
         * This request holds the parameters needed by the the storagetransfer server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId Required. The ID of the Google Cloud project that owns the agent pool.
         * @param content the {@link com.google.api.services.storagetransfer.v1.model.AgentPool}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.storagetransfer.v1.model.AgentPool content) {
          super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.AgentPool.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
                "Parameter projectId must conform to the pattern " +
                "^[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Google Cloud project that owns the agent pool. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Required. The ID of the Google Cloud project that owns the agent pool.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** Required. The ID of the Google Cloud project that owns the agent pool. */
        public Create setProjectId(java.lang.String projectId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
                "Parameter projectId must conform to the pattern " +
                "^[^/]+$");
          }
          this.projectId = projectId;
          return this;
        }

        /**
         * Required. The ID of the agent pool to create. The `agent_pool_id` must meet the following
         * requirements: * Length of 128 characters or less. * Not start with the string `goog`. *
         * Start with a lowercase ASCII character, followed by: * Zero or more: lowercase Latin
         * alphabet characters, numerals, hyphens (`-`), periods (`.`), underscores (`_`), or tildes
         * (`~`). * One or more numerals or lowercase ASCII characters. As expressed by the regular
         * expression: `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
         */
        @com.google.api.client.util.Key
        private java.lang.String agentPoolId;

        /** Required. The ID of the agent pool to create. The `agent_pool_id` must meet the following
       requirements: * Length of 128 characters or less. * Not start with the string `goog`. * Start with
       a lowercase ASCII character, followed by: * Zero or more: lowercase Latin alphabet characters,
       numerals, hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`). * One or more numerals
       or lowercase ASCII characters. As expressed by the regular expression:
       `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
         */
        public java.lang.String getAgentPoolId() {
          return agentPoolId;
        }

        /**
         * Required. The ID of the agent pool to create. The `agent_pool_id` must meet the following
         * requirements: * Length of 128 characters or less. * Not start with the string `goog`. *
         * Start with a lowercase ASCII character, followed by: * Zero or more: lowercase Latin
         * alphabet characters, numerals, hyphens (`-`), periods (`.`), underscores (`_`), or tildes
         * (`~`). * One or more numerals or lowercase ASCII characters. As expressed by the regular
         * expression: `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
         */
        public Create setAgentPoolId(java.lang.String agentPoolId) {
          this.agentPoolId = agentPoolId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an agent pool.
       *
       * Create a request for the method "agentPools.delete".
       *
       * This request holds the parameters needed by the storagetransfer server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the agent pool to delete.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");

        /**
         * Deletes an agent pool.
         *
         * Create a request for the method "agentPools.delete".
         *
         * This request holds the parameters needed by the the storagetransfer server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the agent pool to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Storagetransfer.this, "DELETE", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The name of the agent pool to delete. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the agent pool to delete.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The name of the agent pool to delete. */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets an agent pool.
       *
       * Create a request for the method "agentPools.get".
       *
       * This request holds the parameters needed by the storagetransfer server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the agent pool to get.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.AgentPool> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");

        /**
         * Gets an agent pool.
         *
         * Create a request for the method "agentPools.get".
         *
         * This request holds the parameters needed by the the storagetransfer server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the agent pool to get.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.AgentPool.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The name of the agent pool to get. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the agent pool to get.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The name of the agent pool to get. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists agent pools.
       *
       * Create a request for the method "agentPools.list".
       *
       * This request holds the parameters needed by the storagetransfer server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId Required. The ID of the Google Cloud project that owns the job.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.ListAgentPoolsResponse> {

        private static final String REST_PATH = "v1/projects/{+projectId}/agentPools";

        private final java.util.regex.Pattern PROJECT_ID_PATTERN =
            java.util.regex.Pattern.compile("^[^/]+$");

        /**
         * Lists agent pools.
         *
         * Create a request for the method "agentPools.list".
         *
         * This request holds the parameters needed by the the storagetransfer server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId Required. The ID of the Google Cloud project that owns the job.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.ListAgentPoolsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
                "Parameter projectId must conform to the pattern " +
                "^[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Google Cloud project that owns the job. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Required. The ID of the Google Cloud project that owns the job.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** Required. The ID of the Google Cloud project that owns the job. */
        public List setProjectId(java.lang.String projectId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
                "Parameter projectId must conform to the pattern " +
                "^[^/]+$");
          }
          this.projectId = projectId;
          return this;
        }

        /**
         * An optional list of query parameters specified as JSON text in the form of:
         * `{"agentPoolNames":["agentpool1","agentpool2",...]}` Since `agentPoolNames` support
         * multiple values, its values must be specified with array notation. When the filter is
         * either empty or not provided, the list returns all agent pools for the project.
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** An optional list of query parameters specified as JSON text in the form of:
       `{"agentPoolNames":["agentpool1","agentpool2",...]}` Since `agentPoolNames` support multiple
       values, its values must be specified with array notation. When the filter is either empty or not
       provided, the list returns all agent pools for the project.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * An optional list of query parameters specified as JSON text in the form of:
         * `{"agentPoolNames":["agentpool1","agentpool2",...]}` Since `agentPoolNames` support
         * multiple values, its values must be specified with array notation. When the filter is
         * either empty or not provided, the list returns all agent pools for the project.
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The list page size. The max allowed value is `256`. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The list page size. The max allowed value is `256`.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The list page size. The max allowed value is `256`. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** The list page token. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The list page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** The list page token. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing agent pool resource.
       *
       * Create a request for the method "agentPools.patch".
       *
       * This request holds the parameters needed by the storagetransfer server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Required. Specifies a unique string that identifies the agent pool. Format:
       *        `projects/{project_id}/agentPools/{agent_pool_id}`
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.AgentPool}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.storagetransfer.v1.model.AgentPool content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.AgentPool> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/agentPools/[^/]+$");

        /**
         * Updates an existing agent pool resource.
         *
         * Create a request for the method "agentPools.patch".
         *
         * This request holds the parameters needed by the the storagetransfer server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Specifies a unique string that identifies the agent pool. Format:
       *        `projects/{project_id}/agentPools/{agent_pool_id}`
         * @param content the {@link com.google.api.services.storagetransfer.v1.model.AgentPool}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.storagetransfer.v1.model.AgentPool content) {
          super(Storagetransfer.this, "PATCH", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.AgentPool.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Specifies a unique string that identifies the agent pool. Format:
         * `projects/{project_id}/agentPools/{agent_pool_id}`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Specifies a unique string that identifies the agent pool. Format:
       `projects/{project_id}/agentPools/{agent_pool_id}`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Specifies a unique string that identifies the agent pool. Format:
         * `projects/{project_id}/agentPools/{agent_pool_id}`
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/agentPools/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * The [field mask] (https://developers.google.com/protocol-
         * buffers/docs/reference/google.protobuf) of the fields in `agentPool` to update in this
         * request. The following `agentPool` fields can be updated: * display_name *
         * bandwidth_limit
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** The [field mask] (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf) of
       the fields in `agentPool` to update in this request. The following `agentPool` fields can be
       updated: * display_name * bandwidth_limit
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * The [field mask] (https://developers.google.com/protocol-
         * buffers/docs/reference/google.protobuf) of the fields in `agentPool` to update in this
         * request. The following `agentPool` fields can be updated: * display_name *
         * bandwidth_limit
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the TransferJobs collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storagetransfer storagetransfer = new Storagetransfer(...);}
   *   {@code Storagetransfer.TransferJobs.List request = storagetransfer.transferJobs().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TransferJobs transferJobs() {
    return new TransferJobs();
  }

  /**
   * The "transferJobs" collection of methods.
   */
  public class TransferJobs {

    /**
     * Creates a transfer job that runs periodically.
     *
     * Create a request for the method "transferJobs.create".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.TransferJob}
     * @return the request
     */
    public Create create(com.google.api.services.storagetransfer.v1.model.TransferJob content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.TransferJob> {

      private static final String REST_PATH = "v1/transferJobs";

      /**
       * Creates a transfer job that runs periodically.
       *
       * Create a request for the method "transferJobs.create".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       * <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.TransferJob}
       * @since 1.13
       */
      protected Create(com.google.api.services.storagetransfer.v1.model.TransferJob content) {
        super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.TransferJob.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a transfer job. Deleting a transfer job sets its status to DELETED.
     *
     * Create a request for the method "transferJobs.delete".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param jobName Required. The job to delete.
     * @param projectId Required. The ID of the Google Cloud project that owns the job.
     * @return the request
     */
    public Delete delete(java.lang.String jobName, java.lang.String projectId) throws java.io.IOException {
      Delete result = new Delete(jobName, projectId);
      initialize(result);
      return result;
    }

    public class Delete extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+jobName}";

      private final java.util.regex.Pattern JOB_NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferJobs/.*$");

      /**
       * Deletes a transfer job. Deleting a transfer job sets its status to DELETED.
       *
       * Create a request for the method "transferJobs.delete".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param jobName Required. The job to delete.
       * @param projectId Required. The ID of the Google Cloud project that owns the job.
       * @since 1.13
       */
      protected Delete(java.lang.String jobName, java.lang.String projectId) {
        super(Storagetransfer.this, "DELETE", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.Empty.class);
        this.jobName = com.google.api.client.util.Preconditions.checkNotNull(jobName, "Required parameter jobName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The job to delete. */
      @com.google.api.client.util.Key
      private java.lang.String jobName;

      /** Required. The job to delete.
       */
      public java.lang.String getJobName() {
        return jobName;
      }

      /** Required. The job to delete. */
      public Delete setJobName(java.lang.String jobName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.jobName = jobName;
        return this;
      }

      /** Required. The ID of the Google Cloud project that owns the job. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. The ID of the Google Cloud project that owns the job.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. The ID of the Google Cloud project that owns the job. */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a transfer job.
     *
     * Create a request for the method "transferJobs.get".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param jobName Required. The job to get.
     * @param projectId Required. The ID of the Google Cloud project that owns the job.
     * @return the request
     */
    public Get get(java.lang.String jobName, java.lang.String projectId) throws java.io.IOException {
      Get result = new Get(jobName, projectId);
      initialize(result);
      return result;
    }

    public class Get extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.TransferJob> {

      private static final String REST_PATH = "v1/{+jobName}";

      private final java.util.regex.Pattern JOB_NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferJobs/.*$");

      /**
       * Gets a transfer job.
       *
       * Create a request for the method "transferJobs.get".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param jobName Required. The job to get.
       * @param projectId Required. The ID of the Google Cloud project that owns the job.
       * @since 1.13
       */
      protected Get(java.lang.String jobName, java.lang.String projectId) {
        super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.TransferJob.class);
        this.jobName = com.google.api.client.util.Preconditions.checkNotNull(jobName, "Required parameter jobName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The job to get. */
      @com.google.api.client.util.Key
      private java.lang.String jobName;

      /** Required. The job to get.
       */
      public java.lang.String getJobName() {
        return jobName;
      }

      /** Required. The job to get. */
      public Get setJobName(java.lang.String jobName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.jobName = jobName;
        return this;
      }

      /** Required. The ID of the Google Cloud project that owns the job. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. The ID of the Google Cloud project that owns the job.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. The ID of the Google Cloud project that owns the job. */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists transfer jobs.
     *
     * Create a request for the method "transferJobs.list".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param filter Required. A list of query parameters specified as JSON text in the form of:
     *        `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...],
     *        "jobStatuses":["status1","status2",...]}` Since `jobNames` and `jobStatuses` support
     *        multiple values, their values must be specified with array notation. `projectId` is
     *        required. `jobNames` and `jobStatuses` are optional. The valid values for `jobStatuses`
     *        are case-insensitive: ENABLED, DISABLED, and DELETED.
     * @return the request
     */
    public List list(java.lang.String filter) throws java.io.IOException {
      List result = new List(filter);
      initialize(result);
      return result;
    }

    public class List extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.ListTransferJobsResponse> {

      private static final String REST_PATH = "v1/transferJobs";

      /**
       * Lists transfer jobs.
       *
       * Create a request for the method "transferJobs.list".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param filter Required. A list of query parameters specified as JSON text in the form of:
     *        `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...],
     *        "jobStatuses":["status1","status2",...]}` Since `jobNames` and `jobStatuses` support
     *        multiple values, their values must be specified with array notation. `projectId` is
     *        required. `jobNames` and `jobStatuses` are optional. The valid values for `jobStatuses`
     *        are case-insensitive: ENABLED, DISABLED, and DELETED.
       * @since 1.13
       */
      protected List(java.lang.String filter) {
        super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.ListTransferJobsResponse.class);
        this.filter = com.google.api.client.util.Preconditions.checkNotNull(filter, "Required parameter filter must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...],
       * "jobStatuses":["status1","status2",...]}` Since `jobNames` and `jobStatuses` support
       * multiple values, their values must be specified with array notation. `projectId` is
       * required. `jobNames` and `jobStatuses` are optional. The valid values for `jobStatuses` are
       * case-insensitive: ENABLED, DISABLED, and DELETED.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Required. A list of query parameters specified as JSON text in the form of:
     `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...],
     "jobStatuses":["status1","status2",...]}` Since `jobNames` and `jobStatuses` support multiple
     values, their values must be specified with array notation. `projectId` is required. `jobNames` and
     `jobStatuses` are optional. The valid values for `jobStatuses` are case-insensitive: ENABLED,
     DISABLED, and DELETED.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...],
       * "jobStatuses":["status1","status2",...]}` Since `jobNames` and `jobStatuses` support
       * multiple values, their values must be specified with array notation. `projectId` is
       * required. `jobNames` and `jobStatuses` are optional. The valid values for `jobStatuses` are
       * case-insensitive: ENABLED, DISABLED, and DELETED.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The list page size. The max allowed value is 256. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The list page size. The max allowed value is 256.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The list page size. The max allowed value is 256. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** The list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a transfer job. Updating a job's transfer spec does not affect transfer operations that
     * are running already. **Note:** The job's status field can be modified using this RPC (for
     * example, to set a job's status to DELETED, DISABLED, or ENABLED).
     *
     * Create a request for the method "transferJobs.patch".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param jobName Required. The name of job to update.
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.UpdateTransferJobRequest}
     * @return the request
     */
    public Patch patch(java.lang.String jobName, com.google.api.services.storagetransfer.v1.model.UpdateTransferJobRequest content) throws java.io.IOException {
      Patch result = new Patch(jobName, content);
      initialize(result);
      return result;
    }

    public class Patch extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.TransferJob> {

      private static final String REST_PATH = "v1/{+jobName}";

      private final java.util.regex.Pattern JOB_NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferJobs/.*$");

      /**
       * Updates a transfer job. Updating a job's transfer spec does not affect transfer operations that
       * are running already. **Note:** The job's status field can be modified using this RPC (for
       * example, to set a job's status to DELETED, DISABLED, or ENABLED).
       *
       * Create a request for the method "transferJobs.patch".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param jobName Required. The name of job to update.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.UpdateTransferJobRequest}
       * @since 1.13
       */
      protected Patch(java.lang.String jobName, com.google.api.services.storagetransfer.v1.model.UpdateTransferJobRequest content) {
        super(Storagetransfer.this, "PATCH", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.TransferJob.class);
        this.jobName = com.google.api.client.util.Preconditions.checkNotNull(jobName, "Required parameter jobName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of job to update. */
      @com.google.api.client.util.Key
      private java.lang.String jobName;

      /** Required. The name of job to update.
       */
      public java.lang.String getJobName() {
        return jobName;
      }

      /** Required. The name of job to update. */
      public Patch setJobName(java.lang.String jobName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.jobName = jobName;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Starts a new operation for the specified transfer job. A `TransferJob` has a maximum of one
     * active `TransferOperation`. If this method is called while a `TransferOperation` is active, an
     * error is returned.
     *
     * Create a request for the method "transferJobs.run".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Run#execute()} method to invoke the remote operation.
     *
     * @param jobName Required. The name of the transfer job.
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.RunTransferJobRequest}
     * @return the request
     */
    public Run run(java.lang.String jobName, com.google.api.services.storagetransfer.v1.model.RunTransferJobRequest content) throws java.io.IOException {
      Run result = new Run(jobName, content);
      initialize(result);
      return result;
    }

    public class Run extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+jobName}:run";

      private final java.util.regex.Pattern JOB_NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferJobs/.*$");

      /**
       * Starts a new operation for the specified transfer job. A `TransferJob` has a maximum of one
       * active `TransferOperation`. If this method is called while a `TransferOperation` is active, an
       * error is returned.
       *
       * Create a request for the method "transferJobs.run".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Run#execute()} method to invoke the remote operation. <p>
       * {@link Run#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param jobName Required. The name of the transfer job.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.RunTransferJobRequest}
       * @since 1.13
       */
      protected Run(java.lang.String jobName, com.google.api.services.storagetransfer.v1.model.RunTransferJobRequest content) {
        super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.Operation.class);
        this.jobName = com.google.api.client.util.Preconditions.checkNotNull(jobName, "Required parameter jobName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
      }

      @Override
      public Run set$Xgafv(java.lang.String $Xgafv) {
        return (Run) super.set$Xgafv($Xgafv);
      }

      @Override
      public Run setAccessToken(java.lang.String accessToken) {
        return (Run) super.setAccessToken(accessToken);
      }

      @Override
      public Run setAlt(java.lang.String alt) {
        return (Run) super.setAlt(alt);
      }

      @Override
      public Run setCallback(java.lang.String callback) {
        return (Run) super.setCallback(callback);
      }

      @Override
      public Run setFields(java.lang.String fields) {
        return (Run) super.setFields(fields);
      }

      @Override
      public Run setKey(java.lang.String key) {
        return (Run) super.setKey(key);
      }

      @Override
      public Run setOauthToken(java.lang.String oauthToken) {
        return (Run) super.setOauthToken(oauthToken);
      }

      @Override
      public Run setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Run) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Run setQuotaUser(java.lang.String quotaUser) {
        return (Run) super.setQuotaUser(quotaUser);
      }

      @Override
      public Run setUploadType(java.lang.String uploadType) {
        return (Run) super.setUploadType(uploadType);
      }

      @Override
      public Run setUploadProtocol(java.lang.String uploadProtocol) {
        return (Run) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the transfer job. */
      @com.google.api.client.util.Key
      private java.lang.String jobName;

      /** Required. The name of the transfer job.
       */
      public java.lang.String getJobName() {
        return jobName;
      }

      /** Required. The name of the transfer job. */
      public Run setJobName(java.lang.String jobName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_NAME_PATTERN.matcher(jobName).matches(),
              "Parameter jobName must conform to the pattern " +
              "^transferJobs/.*$");
        }
        this.jobName = jobName;
        return this;
      }

      @Override
      public Run set(String parameterName, Object value) {
        return (Run) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TransferOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storagetransfer storagetransfer = new Storagetransfer(...);}
   *   {@code Storagetransfer.TransferOperations.List request = storagetransfer.transferOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TransferOperations transferOperations() {
    return new TransferOperations();
  }

  /**
   * The "transferOperations" collection of methods.
   */
  public class TransferOperations {

    /**
     * Cancels a transfer. Use the transferOperations.get method to check if the cancellation succeeded
     * or if the operation completed despite the `cancel` request. When you cancel an operation, the
     * currently running transfer is interrupted. For recurring transfer jobs, the next instance of the
     * transfer job will still run. For example, if your job is configured to run every day at 1pm and
     * you cancel Monday's operation at 1:05pm, Monday's transfer will stop. However, a transfer job
     * will still be attempted on Tuesday. This applies only to currently running operations. If an
     * operation is not currently running, `cancel` does nothing. *Caution:* Canceling a transfer job
     * can leave your data in an unknown state. We recommend that you restore the state at both the
     * destination and the source after the `cancel` request completes so that your data is in a
     * consistent state. When you cancel a job, the next job computes a delta of files and may repair
     * any inconsistent state. For instance, if you run a job every day, and today's job found 10 new
     * files and transferred five files before you canceled the job, tomorrow's transfer operation will
     * compute a new delta with the five files that were not copied today plus any new files discovered
     * tomorrow.
     *
     * Create a request for the method "transferOperations.cancel".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be cancelled.
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.CancelOperationRequest}
     * @return the request
     */
    public Cancel cancel(java.lang.String name, com.google.api.services.storagetransfer.v1.model.CancelOperationRequest content) throws java.io.IOException {
      Cancel result = new Cancel(name, content);
      initialize(result);
      return result;
    }

    public class Cancel extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:cancel";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferOperations/.*$");

      /**
       * Cancels a transfer. Use the transferOperations.get method to check if the cancellation
       * succeeded or if the operation completed despite the `cancel` request. When you cancel an
       * operation, the currently running transfer is interrupted. For recurring transfer jobs, the next
       * instance of the transfer job will still run. For example, if your job is configured to run
       * every day at 1pm and you cancel Monday's operation at 1:05pm, Monday's transfer will stop.
       * However, a transfer job will still be attempted on Tuesday. This applies only to currently
       * running operations. If an operation is not currently running, `cancel` does nothing. *Caution:*
       * Canceling a transfer job can leave your data in an unknown state. We recommend that you restore
       * the state at both the destination and the source after the `cancel` request completes so that
       * your data is in a consistent state. When you cancel a job, the next job computes a delta of
       * files and may repair any inconsistent state. For instance, if you run a job every day, and
       * today's job found 10 new files and transferred five files before you canceled the job,
       * tomorrow's transfer operation will compute a new delta with the five files that were not copied
       * today plus any new files discovered tomorrow.
       *
       * Create a request for the method "transferOperations.cancel".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be cancelled.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.CancelOperationRequest}
       * @since 1.13
       */
      protected Cancel(java.lang.String name, com.google.api.services.storagetransfer.v1.model.CancelOperationRequest content) {
        super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
      }

      @Override
      public Cancel set$Xgafv(java.lang.String $Xgafv) {
        return (Cancel) super.set$Xgafv($Xgafv);
      }

      @Override
      public Cancel setAccessToken(java.lang.String accessToken) {
        return (Cancel) super.setAccessToken(accessToken);
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setCallback(java.lang.String callback) {
        return (Cancel) super.setCallback(callback);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUploadType(java.lang.String uploadType) {
        return (Cancel) super.setUploadType(uploadType);
      }

      @Override
      public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
        return (Cancel) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be cancelled. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be cancelled.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be cancelled. */
      public Cancel setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Gets the latest state of a long-running operation. Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "transferOperations.get".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferOperations/.*$");

      /**
       * Gets the latest state of a long-running operation. Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "transferOperations.get".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists transfer operations. Operations are ordered by their creation time in reverse chronological
     * order.
     *
     * Create a request for the method "transferOperations.list".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the type being listed; must be `transferOperations`.
     * @param filter Required. A list of query parameters specified as JSON text in the form of:
     *        `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...], "jobNamePattern":
     *        "job_name_pattern", "operationNames":["opid1","opid2",...], "operationNamePattern":
     *        "operation_name_pattern", "minCreationTime": "min_creation_time", "maxCreationTime":
     *        "max_creation_time", "transferStatuses":["status1","status2",...]}` Since `jobNames`,
     *        `operationNames`, and `transferStatuses` support multiple values, they must be specified
     *        with array notation. `projectId` is the only argument that is required. If specified,
     *        `jobNamePattern` and `operationNamePattern` must match the full job or operation name
     *        respectively. '*' is a wildcard matching 0 or more characters. `minCreationTime` and
     *        `maxCreationTime` should be timestamps encoded as a string in the [RFC
     *        3339](https://www.ietf.org/rfc/rfc3339.txt) format. The valid values for
     *        `transferStatuses` are case-insensitive: IN_PROGRESS, PAUSED, SUCCESS, FAILED, and
     *        ABORTED.
     * @return the request
     */
    public List list(java.lang.String name, java.lang.String filter) throws java.io.IOException {
      List result = new List(name, filter);
      initialize(result);
      return result;
    }

    public class List extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.ListOperationsResponse> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferOperations$");

      /**
       * Lists transfer operations. Operations are ordered by their creation time in reverse
       * chronological order.
       *
       * Create a request for the method "transferOperations.list".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the type being listed; must be `transferOperations`.
       * @param filter Required. A list of query parameters specified as JSON text in the form of:
     *        `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...], "jobNamePattern":
     *        "job_name_pattern", "operationNames":["opid1","opid2",...], "operationNamePattern":
     *        "operation_name_pattern", "minCreationTime": "min_creation_time", "maxCreationTime":
     *        "max_creation_time", "transferStatuses":["status1","status2",...]}` Since `jobNames`,
     *        `operationNames`, and `transferStatuses` support multiple values, they must be specified
     *        with array notation. `projectId` is the only argument that is required. If specified,
     *        `jobNamePattern` and `operationNamePattern` must match the full job or operation name
     *        respectively. '*' is a wildcard matching 0 or more characters. `minCreationTime` and
     *        `maxCreationTime` should be timestamps encoded as a string in the [RFC
     *        3339](https://www.ietf.org/rfc/rfc3339.txt) format. The valid values for
     *        `transferStatuses` are case-insensitive: IN_PROGRESS, PAUSED, SUCCESS, FAILED, and
     *        ABORTED.
       * @since 1.13
       */
      protected List(java.lang.String name, java.lang.String filter) {
        super(Storagetransfer.this, "GET", REST_PATH, null, com.google.api.services.storagetransfer.v1.model.ListOperationsResponse.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations$");
        }
        this.filter = com.google.api.client.util.Preconditions.checkNotNull(filter, "Required parameter filter must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the type being listed; must be `transferOperations`. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the type being listed; must be `transferOperations`.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. The name of the type being listed; must be `transferOperations`. */
      public List setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...], "jobNamePattern":
       * "job_name_pattern", "operationNames":["opid1","opid2",...], "operationNamePattern":
       * "operation_name_pattern", "minCreationTime": "min_creation_time", "maxCreationTime":
       * "max_creation_time", "transferStatuses":["status1","status2",...]}` Since `jobNames`,
       * `operationNames`, and `transferStatuses` support multiple values, they must be specified
       * with array notation. `projectId` is the only argument that is required. If specified,
       * `jobNamePattern` and `operationNamePattern` must match the full job or operation name
       * respectively. '*' is a wildcard matching 0 or more characters. `minCreationTime` and
       * `maxCreationTime` should be timestamps encoded as a string in the [RFC
       * 3339](https://www.ietf.org/rfc/rfc3339.txt) format. The valid values for `transferStatuses`
       * are case-insensitive: IN_PROGRESS, PAUSED, SUCCESS, FAILED, and ABORTED.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Required. A list of query parameters specified as JSON text in the form of:
     `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...], "jobNamePattern":
     "job_name_pattern", "operationNames":["opid1","opid2",...], "operationNamePattern":
     "operation_name_pattern", "minCreationTime": "min_creation_time", "maxCreationTime":
     "max_creation_time", "transferStatuses":["status1","status2",...]}` Since `jobNames`,
     `operationNames`, and `transferStatuses` support multiple values, they must be specified with array
     notation. `projectId` is the only argument that is required. If specified, `jobNamePattern` and
     `operationNamePattern` must match the full job or operation name respectively. '*' is a wildcard
     matching 0 or more characters. `minCreationTime` and `maxCreationTime` should be timestamps encoded
     as a string in the [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. The valid values for
     `transferStatuses` are case-insensitive: IN_PROGRESS, PAUSED, SUCCESS, FAILED, and ABORTED.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id", "jobNames":["jobid1","jobid2",...], "jobNamePattern":
       * "job_name_pattern", "operationNames":["opid1","opid2",...], "operationNamePattern":
       * "operation_name_pattern", "minCreationTime": "min_creation_time", "maxCreationTime":
       * "max_creation_time", "transferStatuses":["status1","status2",...]}` Since `jobNames`,
       * `operationNames`, and `transferStatuses` support multiple values, they must be specified
       * with array notation. `projectId` is the only argument that is required. If specified,
       * `jobNamePattern` and `operationNamePattern` must match the full job or operation name
       * respectively. '*' is a wildcard matching 0 or more characters. `minCreationTime` and
       * `maxCreationTime` should be timestamps encoded as a string in the [RFC
       * 3339](https://www.ietf.org/rfc/rfc3339.txt) format. The valid values for `transferStatuses`
       * are case-insensitive: IN_PROGRESS, PAUSED, SUCCESS, FAILED, and ABORTED.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The list page size. The max allowed value is 256. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The list page size. The max allowed value is 256.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The list page size. The max allowed value is 256. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** The list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Pauses a transfer operation.
     *
     * Create a request for the method "transferOperations.pause".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Pause#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the transfer operation.
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.PauseTransferOperationRequest}
     * @return the request
     */
    public Pause pause(java.lang.String name, com.google.api.services.storagetransfer.v1.model.PauseTransferOperationRequest content) throws java.io.IOException {
      Pause result = new Pause(name, content);
      initialize(result);
      return result;
    }

    public class Pause extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:pause";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferOperations/.*$");

      /**
       * Pauses a transfer operation.
       *
       * Create a request for the method "transferOperations.pause".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Pause#execute()} method to invoke the remote operation.
       * <p> {@link
       * Pause#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the transfer operation.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.PauseTransferOperationRequest}
       * @since 1.13
       */
      protected Pause(java.lang.String name, com.google.api.services.storagetransfer.v1.model.PauseTransferOperationRequest content) {
        super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
      }

      @Override
      public Pause set$Xgafv(java.lang.String $Xgafv) {
        return (Pause) super.set$Xgafv($Xgafv);
      }

      @Override
      public Pause setAccessToken(java.lang.String accessToken) {
        return (Pause) super.setAccessToken(accessToken);
      }

      @Override
      public Pause setAlt(java.lang.String alt) {
        return (Pause) super.setAlt(alt);
      }

      @Override
      public Pause setCallback(java.lang.String callback) {
        return (Pause) super.setCallback(callback);
      }

      @Override
      public Pause setFields(java.lang.String fields) {
        return (Pause) super.setFields(fields);
      }

      @Override
      public Pause setKey(java.lang.String key) {
        return (Pause) super.setKey(key);
      }

      @Override
      public Pause setOauthToken(java.lang.String oauthToken) {
        return (Pause) super.setOauthToken(oauthToken);
      }

      @Override
      public Pause setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Pause) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Pause setQuotaUser(java.lang.String quotaUser) {
        return (Pause) super.setQuotaUser(quotaUser);
      }

      @Override
      public Pause setUploadType(java.lang.String uploadType) {
        return (Pause) super.setUploadType(uploadType);
      }

      @Override
      public Pause setUploadProtocol(java.lang.String uploadProtocol) {
        return (Pause) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the transfer operation. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the transfer operation.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. The name of the transfer operation. */
      public Pause setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Pause set(String parameterName, Object value) {
        return (Pause) super.set(parameterName, value);
      }
    }
    /**
     * Resumes a transfer operation that is paused.
     *
     * Create a request for the method "transferOperations.resume".
     *
     * This request holds the parameters needed by the storagetransfer server.  After setting any
     * optional parameters, call the {@link Resume#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the transfer operation.
     * @param content the {@link com.google.api.services.storagetransfer.v1.model.ResumeTransferOperationRequest}
     * @return the request
     */
    public Resume resume(java.lang.String name, com.google.api.services.storagetransfer.v1.model.ResumeTransferOperationRequest content) throws java.io.IOException {
      Resume result = new Resume(name, content);
      initialize(result);
      return result;
    }

    public class Resume extends StoragetransferRequest<com.google.api.services.storagetransfer.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:resume";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^transferOperations/.*$");

      /**
       * Resumes a transfer operation that is paused.
       *
       * Create a request for the method "transferOperations.resume".
       *
       * This request holds the parameters needed by the the storagetransfer server.  After setting any
       * optional parameters, call the {@link Resume#execute()} method to invoke the remote operation.
       * <p> {@link
       * Resume#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the transfer operation.
       * @param content the {@link com.google.api.services.storagetransfer.v1.model.ResumeTransferOperationRequest}
       * @since 1.13
       */
      protected Resume(java.lang.String name, com.google.api.services.storagetransfer.v1.model.ResumeTransferOperationRequest content) {
        super(Storagetransfer.this, "POST", REST_PATH, content, com.google.api.services.storagetransfer.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
      }

      @Override
      public Resume set$Xgafv(java.lang.String $Xgafv) {
        return (Resume) super.set$Xgafv($Xgafv);
      }

      @Override
      public Resume setAccessToken(java.lang.String accessToken) {
        return (Resume) super.setAccessToken(accessToken);
      }

      @Override
      public Resume setAlt(java.lang.String alt) {
        return (Resume) super.setAlt(alt);
      }

      @Override
      public Resume setCallback(java.lang.String callback) {
        return (Resume) super.setCallback(callback);
      }

      @Override
      public Resume setFields(java.lang.String fields) {
        return (Resume) super.setFields(fields);
      }

      @Override
      public Resume setKey(java.lang.String key) {
        return (Resume) super.setKey(key);
      }

      @Override
      public Resume setOauthToken(java.lang.String oauthToken) {
        return (Resume) super.setOauthToken(oauthToken);
      }

      @Override
      public Resume setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resume) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resume setQuotaUser(java.lang.String quotaUser) {
        return (Resume) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resume setUploadType(java.lang.String uploadType) {
        return (Resume) super.setUploadType(uploadType);
      }

      @Override
      public Resume setUploadProtocol(java.lang.String uploadProtocol) {
        return (Resume) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the transfer operation. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the transfer operation.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. The name of the transfer operation. */
      public Resume setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^transferOperations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Resume set(String parameterName, Object value) {
        return (Resume) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Storagetransfer}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Storagetransfer}. */
    @Override
    public Storagetransfer build() {
      return new Storagetransfer(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link StoragetransferRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setStoragetransferRequestInitializer(
        StoragetransferRequestInitializer storagetransferRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(storagetransferRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }

    @Override
    public Builder setUniverseDomain(String universeDomain) {
      return (Builder) super.setUniverseDomain(universeDomain);
    }
  }
}
