/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * An AwsS3CompatibleData resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AwsS3CompatibleData extends com.google.api.client.json.GenericJson {

  /**
   * Required. Specifies the name of the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucketName;

  /**
   * Required. Specifies the endpoint of the storage service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endpoint;

  /**
   * Specifies the root path to transfer objects. Must be an empty string or full path name that
   * ends with a '/'. This field is treated as an object prefix. As such, it should generally not
   * begin with a '/'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Specifies the region to sign requests with. This can be left blank if requests should be signed
   * with an empty region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * A S3 compatible metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private S3CompatibleMetadata s3Metadata;

  /**
   * Required. Specifies the name of the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucketName() {
    return bucketName;
  }

  /**
   * Required. Specifies the name of the bucket.
   * @param bucketName bucketName or {@code null} for none
   */
  public AwsS3CompatibleData setBucketName(java.lang.String bucketName) {
    this.bucketName = bucketName;
    return this;
  }

  /**
   * Required. Specifies the endpoint of the storage service.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndpoint() {
    return endpoint;
  }

  /**
   * Required. Specifies the endpoint of the storage service.
   * @param endpoint endpoint or {@code null} for none
   */
  public AwsS3CompatibleData setEndpoint(java.lang.String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * Specifies the root path to transfer objects. Must be an empty string or full path name that
   * ends with a '/'. This field is treated as an object prefix. As such, it should generally not
   * begin with a '/'.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Specifies the root path to transfer objects. Must be an empty string or full path name that
   * ends with a '/'. This field is treated as an object prefix. As such, it should generally not
   * begin with a '/'.
   * @param path path or {@code null} for none
   */
  public AwsS3CompatibleData setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Specifies the region to sign requests with. This can be left blank if requests should be signed
   * with an empty region.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * Specifies the region to sign requests with. This can be left blank if requests should be signed
   * with an empty region.
   * @param region region or {@code null} for none
   */
  public AwsS3CompatibleData setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * A S3 compatible metadata.
   * @return value or {@code null} for none
   */
  public S3CompatibleMetadata getS3Metadata() {
    return s3Metadata;
  }

  /**
   * A S3 compatible metadata.
   * @param s3Metadata s3Metadata or {@code null} for none
   */
  public AwsS3CompatibleData setS3Metadata(S3CompatibleMetadata s3Metadata) {
    this.s3Metadata = s3Metadata;
    return this;
  }

  @Override
  public AwsS3CompatibleData set(String fieldName, Object value) {
    return (AwsS3CompatibleData) super.set(fieldName, value);
  }

  @Override
  public AwsS3CompatibleData clone() {
    return (AwsS3CompatibleData) super.clone();
  }

}
