/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * An AzureBlobStorageData resource can be a data source, but not a data sink. An
 * AzureBlobStorageData resource represents one Azure container. The storage account determines the
 * [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-
 * account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the
 * [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-
 * us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AzureBlobStorageData extends com.google.api.client.json.GenericJson {

  /**
   * Required. Input only. Credentials used to authenticate API requests to Azure. For information
   * on our data retention policy for user credentials, see [User credentials](/storage-
   * transfer/docs/data-retention#user-credentials).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AzureCredentials azureCredentials;

  /**
   * Required. The container to transfer from the Azure Storage account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String container;

  /**
   * Optional. The Resource name of a secret in Secret Manager. The Azure SAS token must be stored
   * in Secret Manager in JSON format: { "sas_token" : "SAS_TOKEN" } GoogleServiceAccount must be
   * granted `roles/secretmanager.secretAccessor` for the resource. See [Configure access to a
   * source: Microsoft Azure Blob Storage] (https://cloud.google.com/storage-transfer/docs/source-
   * microsoft-azure#secret_manager) for more information. If `credentials_secret` is specified, do
   * not specify azure_credentials. Format: `projects/{project_number}/secrets/{secret_name}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String credentialsSecret;

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Required. The name of the Azure Storage account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageAccount;

  /**
   * Required. Input only. Credentials used to authenticate API requests to Azure. For information
   * on our data retention policy for user credentials, see [User credentials](/storage-
   * transfer/docs/data-retention#user-credentials).
   * @return value or {@code null} for none
   */
  public AzureCredentials getAzureCredentials() {
    return azureCredentials;
  }

  /**
   * Required. Input only. Credentials used to authenticate API requests to Azure. For information
   * on our data retention policy for user credentials, see [User credentials](/storage-
   * transfer/docs/data-retention#user-credentials).
   * @param azureCredentials azureCredentials or {@code null} for none
   */
  public AzureBlobStorageData setAzureCredentials(AzureCredentials azureCredentials) {
    this.azureCredentials = azureCredentials;
    return this;
  }

  /**
   * Required. The container to transfer from the Azure Storage account.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainer() {
    return container;
  }

  /**
   * Required. The container to transfer from the Azure Storage account.
   * @param container container or {@code null} for none
   */
  public AzureBlobStorageData setContainer(java.lang.String container) {
    this.container = container;
    return this;
  }

  /**
   * Optional. The Resource name of a secret in Secret Manager. The Azure SAS token must be stored
   * in Secret Manager in JSON format: { "sas_token" : "SAS_TOKEN" } GoogleServiceAccount must be
   * granted `roles/secretmanager.secretAccessor` for the resource. See [Configure access to a
   * source: Microsoft Azure Blob Storage] (https://cloud.google.com/storage-transfer/docs/source-
   * microsoft-azure#secret_manager) for more information. If `credentials_secret` is specified, do
   * not specify azure_credentials. Format: `projects/{project_number}/secrets/{secret_name}`
   * @return value or {@code null} for none
   */
  public java.lang.String getCredentialsSecret() {
    return credentialsSecret;
  }

  /**
   * Optional. The Resource name of a secret in Secret Manager. The Azure SAS token must be stored
   * in Secret Manager in JSON format: { "sas_token" : "SAS_TOKEN" } GoogleServiceAccount must be
   * granted `roles/secretmanager.secretAccessor` for the resource. See [Configure access to a
   * source: Microsoft Azure Blob Storage] (https://cloud.google.com/storage-transfer/docs/source-
   * microsoft-azure#secret_manager) for more information. If `credentials_secret` is specified, do
   * not specify azure_credentials. Format: `projects/{project_number}/secrets/{secret_name}`
   * @param credentialsSecret credentialsSecret or {@code null} for none
   */
  public AzureBlobStorageData setCredentialsSecret(java.lang.String credentialsSecret) {
    this.credentialsSecret = credentialsSecret;
    return this;
  }

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * @param path path or {@code null} for none
   */
  public AzureBlobStorageData setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Required. The name of the Azure Storage account.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageAccount() {
    return storageAccount;
  }

  /**
   * Required. The name of the Azure Storage account.
   * @param storageAccount storageAccount or {@code null} for none
   */
  public AzureBlobStorageData setStorageAccount(java.lang.String storageAccount) {
    this.storageAccount = storageAccount;
    return this;
  }

  @Override
  public AzureBlobStorageData set(String fieldName, Object value) {
    return (AzureBlobStorageData) super.set(fieldName, value);
  }

  @Override
  public AzureBlobStorageData clone() {
    return (AzureBlobStorageData) super.clone();
  }

}
