/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * An entry describing an error that has occurred.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ErrorLogEntry extends com.google.api.client.json.GenericJson {

  /**
   * A list of messages that carry the error details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> errorDetails;

  /**
   * Required. A URL that refers to the target (a data source, a data sink, or an object) with which
   * the error is associated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * A list of messages that carry the error details.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getErrorDetails() {
    return errorDetails;
  }

  /**
   * A list of messages that carry the error details.
   * @param errorDetails errorDetails or {@code null} for none
   */
  public ErrorLogEntry setErrorDetails(java.util.List<java.lang.String> errorDetails) {
    this.errorDetails = errorDetails;
    return this;
  }

  /**
   * Required. A URL that refers to the target (a data source, a data sink, or an object) with which
   * the error is associated.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * Required. A URL that refers to the target (a data source, a data sink, or an object) with which
   * the error is associated.
   * @param url url or {@code null} for none
   */
  public ErrorLogEntry setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public ErrorLogEntry set(String fieldName, Object value) {
    return (ErrorLogEntry) super.set(fieldName, value);
  }

  @Override
  public ErrorLogEntry clone() {
    return (ErrorLogEntry) super.clone();
  }

}
