/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * A summary of errors by error code, plus a count and sample error log entries.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ErrorSummary extends com.google.api.client.json.GenericJson {

  /**
   * Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorCode;

  /**
   * Required. Count of this type of error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long errorCount;

  /**
   * Error samples. At most 5 error log entries are recorded for a given error code for a single
   * transfer operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ErrorLogEntry> errorLogEntries;

  static {
    // hack to force ProGuard to consider ErrorLogEntry used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ErrorLogEntry.class);
  }

  /**
   * Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorCode() {
    return errorCode;
  }

  /**
   * Required.
   * @param errorCode errorCode or {@code null} for none
   */
  public ErrorSummary setErrorCode(java.lang.String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * Required. Count of this type of error.
   * @return value or {@code null} for none
   */
  public java.lang.Long getErrorCount() {
    return errorCount;
  }

  /**
   * Required. Count of this type of error.
   * @param errorCount errorCount or {@code null} for none
   */
  public ErrorSummary setErrorCount(java.lang.Long errorCount) {
    this.errorCount = errorCount;
    return this;
  }

  /**
   * Error samples. At most 5 error log entries are recorded for a given error code for a single
   * transfer operation.
   * @return value or {@code null} for none
   */
  public java.util.List<ErrorLogEntry> getErrorLogEntries() {
    return errorLogEntries;
  }

  /**
   * Error samples. At most 5 error log entries are recorded for a given error code for a single
   * transfer operation.
   * @param errorLogEntries errorLogEntries or {@code null} for none
   */
  public ErrorSummary setErrorLogEntries(java.util.List<ErrorLogEntry> errorLogEntries) {
    this.errorLogEntries = errorLogEntries;
    return this;
  }

  @Override
  public ErrorSummary set(String fieldName, Object value) {
    return (ErrorSummary) super.set(fieldName, value);
  }

  @Override
  public ErrorSummary clone() {
    return (ErrorSummary) super.clone();
  }

}
