/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to
 * transfer updated files.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventStream extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the data and time at which Storage Transfer Service stops listening for events from
   * this stream. After this time, any transfers in progress will complete, but no new transfers are
   * initiated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String eventStreamExpirationTime;

  /**
   * Specifies the date and time that Storage Transfer Service starts listening for events from this
   * stream. If no start time is specified or start time is in the past, Storage Transfer Service
   * starts listening immediately.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String eventStreamStartTime;

  /**
   * Required. Specifies a unique name of the resource such as AWS SQS ARN in the form
   * 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form
   * 'projects/{project}/subscriptions/{sub}'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies the data and time at which Storage Transfer Service stops listening for events from
   * this stream. After this time, any transfers in progress will complete, but no new transfers are
   * initiated.
   * @return value or {@code null} for none
   */
  public String getEventStreamExpirationTime() {
    return eventStreamExpirationTime;
  }

  /**
   * Specifies the data and time at which Storage Transfer Service stops listening for events from
   * this stream. After this time, any transfers in progress will complete, but no new transfers are
   * initiated.
   * @param eventStreamExpirationTime eventStreamExpirationTime or {@code null} for none
   */
  public EventStream setEventStreamExpirationTime(String eventStreamExpirationTime) {
    this.eventStreamExpirationTime = eventStreamExpirationTime;
    return this;
  }

  /**
   * Specifies the date and time that Storage Transfer Service starts listening for events from this
   * stream. If no start time is specified or start time is in the past, Storage Transfer Service
   * starts listening immediately.
   * @return value or {@code null} for none
   */
  public String getEventStreamStartTime() {
    return eventStreamStartTime;
  }

  /**
   * Specifies the date and time that Storage Transfer Service starts listening for events from this
   * stream. If no start time is specified or start time is in the past, Storage Transfer Service
   * starts listening immediately.
   * @param eventStreamStartTime eventStreamStartTime or {@code null} for none
   */
  public EventStream setEventStreamStartTime(String eventStreamStartTime) {
    this.eventStreamStartTime = eventStreamStartTime;
    return this;
  }

  /**
   * Required. Specifies a unique name of the resource such as AWS SQS ARN in the form
   * 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form
   * 'projects/{project}/subscriptions/{sub}'.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. Specifies a unique name of the resource such as AWS SQS ARN in the form
   * 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form
   * 'projects/{project}/subscriptions/{sub}'.
   * @param name name or {@code null} for none
   */
  public EventStream setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public EventStream set(String fieldName, Object value) {
    return (EventStream) super.set(fieldName, value);
  }

  @Override
  public EventStream clone() {
    return (EventStream) super.clone();
  }

}
