/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * In a GcsData resource, an object's name is the Cloud Storage object's name and its "last
 * modification time" refers to the object's `updated` property of Cloud Storage objects, which
 * changes when the content or the metadata of the object is updated.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GcsData extends com.google.api.client.json.GenericJson {

  /**
   * Required. Cloud Storage bucket name. Must meet [Bucket Name
   * Requirements](/storage/docs/naming#requirements).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucketName;

  /**
   * Preview. Enables the transfer of managed folders between Cloud Storage buckets. Set this option
   * on the gcs_data_source. If set to true: - Managed folders in the source bucket are transferred
   * to the destination bucket. - Managed folders in the destination bucket are overwritten. Other
   * OVERWRITE options are not supported. See [Transfer Cloud Storage managed folders](/storage-
   * transfer/docs/managed-folders).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean managedFolderTransferEnabled;

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Required. Cloud Storage bucket name. Must meet [Bucket Name
   * Requirements](/storage/docs/naming#requirements).
   * @return value or {@code null} for none
   */
  public java.lang.String getBucketName() {
    return bucketName;
  }

  /**
   * Required. Cloud Storage bucket name. Must meet [Bucket Name
   * Requirements](/storage/docs/naming#requirements).
   * @param bucketName bucketName or {@code null} for none
   */
  public GcsData setBucketName(java.lang.String bucketName) {
    this.bucketName = bucketName;
    return this;
  }

  /**
   * Preview. Enables the transfer of managed folders between Cloud Storage buckets. Set this option
   * on the gcs_data_source. If set to true: - Managed folders in the source bucket are transferred
   * to the destination bucket. - Managed folders in the destination bucket are overwritten. Other
   * OVERWRITE options are not supported. See [Transfer Cloud Storage managed folders](/storage-
   * transfer/docs/managed-folders).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getManagedFolderTransferEnabled() {
    return managedFolderTransferEnabled;
  }

  /**
   * Preview. Enables the transfer of managed folders between Cloud Storage buckets. Set this option
   * on the gcs_data_source. If set to true: - Managed folders in the source bucket are transferred
   * to the destination bucket. - Managed folders in the destination bucket are overwritten. Other
   * OVERWRITE options are not supported. See [Transfer Cloud Storage managed folders](/storage-
   * transfer/docs/managed-folders).
   * @param managedFolderTransferEnabled managedFolderTransferEnabled or {@code null} for none
   */
  public GcsData setManagedFolderTransferEnabled(java.lang.Boolean managedFolderTransferEnabled) {
    this.managedFolderTransferEnabled = managedFolderTransferEnabled;
    return this;
  }

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'.
   * This field is treated as an object prefix. As such, it should generally not begin with a '/'.
   * The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
   * @param path path or {@code null} for none
   */
  public GcsData setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public GcsData set(String fieldName, Object value) {
    return (GcsData) super.set(fieldName, value);
  }

  @Override
  public GcsData clone() {
    return (GcsData) super.clone();
  }

}
