/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Response from ListAgentPools.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAgentPoolsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A list of agent pools.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AgentPool> agentPools;

  static {
    // hack to force ProGuard to consider AgentPool used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AgentPool.class);
  }

  /**
   * The list next page token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A list of agent pools.
   * @return value or {@code null} for none
   */
  public java.util.List<AgentPool> getAgentPools() {
    return agentPools;
  }

  /**
   * A list of agent pools.
   * @param agentPools agentPools or {@code null} for none
   */
  public ListAgentPoolsResponse setAgentPools(java.util.List<AgentPool> agentPools) {
    this.agentPools = agentPools;
    return this;
  }

  /**
   * The list next page token.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The list next page token.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAgentPoolsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAgentPoolsResponse set(String fieldName, Object value) {
    return (ListAgentPoolsResponse) super.set(fieldName, value);
  }

  @Override
  public ListAgentPoolsResponse clone() {
    return (ListAgentPoolsResponse) super.clone();
  }

}
