/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storagetransfer.v1.model;

/**
 * Specifies the logging behavior for transfer operations. Logs can be sent to Cloud Logging for all
 * transfer types. See [Read transfer logs](https://cloud.google.com/storage-transfer/docs/read-
 * transfer-logs) for details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Storage Transfer API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LoggingConfig extends com.google.api.client.json.GenericJson {

  /**
   * For PosixFilesystem transfers, enables [file system transfer
   * logs](https://cloud.google.com/storage-transfer/docs/on-prem-transfer-log-format) instead of,
   * or in addition to, Cloud Logging. This option ignores [LoggableAction] and
   * [LoggableActionState]. If these are set, Cloud Logging will also be enabled for this transfer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableOnpremGcsTransferLogs;

  /**
   * States in which `log_actions` are logged. If empty, no logs are generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> logActionStates;

  /**
   * Specifies the actions to be logged. If empty, no logs are generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> logActions;

  /**
   * For PosixFilesystem transfers, enables [file system transfer
   * logs](https://cloud.google.com/storage-transfer/docs/on-prem-transfer-log-format) instead of,
   * or in addition to, Cloud Logging. This option ignores [LoggableAction] and
   * [LoggableActionState]. If these are set, Cloud Logging will also be enabled for this transfer.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableOnpremGcsTransferLogs() {
    return enableOnpremGcsTransferLogs;
  }

  /**
   * For PosixFilesystem transfers, enables [file system transfer
   * logs](https://cloud.google.com/storage-transfer/docs/on-prem-transfer-log-format) instead of,
   * or in addition to, Cloud Logging. This option ignores [LoggableAction] and
   * [LoggableActionState]. If these are set, Cloud Logging will also be enabled for this transfer.
   * @param enableOnpremGcsTransferLogs enableOnpremGcsTransferLogs or {@code null} for none
   */
  public LoggingConfig setEnableOnpremGcsTransferLogs(java.lang.Boolean enableOnpremGcsTransferLogs) {
    this.enableOnpremGcsTransferLogs = enableOnpremGcsTransferLogs;
    return this;
  }

  /**
   * States in which `log_actions` are logged. If empty, no logs are generated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLogActionStates() {
    return logActionStates;
  }

  /**
   * States in which `log_actions` are logged. If empty, no logs are generated.
   * @param logActionStates logActionStates or {@code null} for none
   */
  public LoggingConfig setLogActionStates(java.util.List<java.lang.String> logActionStates) {
    this.logActionStates = logActionStates;
    return this;
  }

  /**
   * Specifies the actions to be logged. If empty, no logs are generated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLogActions() {
    return logActions;
  }

  /**
   * Specifies the actions to be logged. If empty, no logs are generated.
   * @param logActions logActions or {@code null} for none
   */
  public LoggingConfig setLogActions(java.util.List<java.lang.String> logActions) {
    this.logActions = logActions;
    return this;
  }

  @Override
  public LoggingConfig set(String fieldName, Object value) {
    return (LoggingConfig) super.set(fieldName, value);
  }

  @Override
  public LoggingConfig clone() {
    return (LoggingConfig) super.clone();
  }

}
